/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * BeanInfoTest.java
 * JUnit based test
 *
 * Created on September 1, 2006, 1:01 PM
 */

package org.netbeans.modules.visualweb.test;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.html.*;
import junit.framework.*;

/**
 *
 * @author gjmurphy
 */
public class BeanInfoTest extends TestCase {
    
    Map beanMap = new HashMap();
    
    public BeanInfoTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        beanMap.put(HtmlCommandButton.class,
                new String[] {
            "accesskey",
            "action",
            "actionListener",
            "alt",
            "attributes",
            "children",
            "childCount",
            "dir",
            "disabled",
            "id", "family", "facets",
            "image",
            "immediate",
            "lang",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "style",
            "styleClass",
            "tabindex",
            "title",
            "type",
            "value",
        });
        beanMap.put(HtmlCommandLink.class,
                new String[] {
            "accesskey",
            "action",
            "actionListener",
            "attributes",
            "charset",
            "children",
            "childCount",
            "coords",
            "dir",
            "hreflang",
            "id", "family", "facets",
            "immediate",
            "lang",
            "onblur",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "parent",
            "rel",
            "rendered",
            "rendererType",
            "rendersChildren",
            "rev",
            "shape",
            "style",
            "styleClass",
            "tabindex",
            "target",
            "title",
            "type",
            "value",
        });
        beanMap.put(HtmlDataTable.class,
                new String[] {
            "attributes",
            "bgcolor",
            "border",
            "cellpadding",
            "cellspacing",
            "children",
            "childCount",
            "columnClasses",
            "dir",
            "first",
            "footerClass",
            "frame",
            "headerClass",
            "id", "family", "facets",
            "lang",
            "onclick",
            "ondblclick",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "rowAvailable",
            "rowClasses",
            "rowCount",
            "rowData",
            "rowIndex",
            "rows",
            "rules",
            "style",
            "styleClass",
            "summary",
            "title",
            "value",
            "var",
            "width",
        });
        beanMap.put(HtmlGraphicImage.class,
                new String[] {
            "alt",
            "attributes",
            "children",
            "childCount",
            "dir",
            "height",
            "id", "family", "facets",
            "ismap",
            "lang",
            "longdesc",
            "onclick",
            "ondblclick",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "style",
            "styleClass",
            "title",
            "url",
            "usemap",
            "value",
            "width",
        });
        beanMap.put(HtmlInputHidden.class,
                new String[] {
            "attributes",
            "children",
            "childCount",
            "converter",
            "id", "family", "facets",
            "immediate",
            "localValue",
            "localValueSet",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "submittedValue",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlInputSecret.class,
                new String[] {
            "accesskey",
            "alt",
            "attributes",
            "children",
            "childCount",
            "converter",
            "dir",
            "disabled",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "maxlength",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "redisplay",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "size",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlInputText.class,
                new String[] {
            "accesskey",
            "alt",
            "attributes",
            "children",
            "childCount",
            "converter",
            "dir",
            "disabled",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "maxlength",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "size",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlInputTextarea.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",
            "childCount",
            "cols",
            "converter",
            "dir",
            "disabled",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "rows",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlMessage.class,
                new String[] {
            "attributes",
            "children",
            "childCount",
            "errorClass",
            "errorStyle",
            "fatalClass",
            "fatalStyle",
            "for",
            "id", "family", "facets",
            "infoClass",
            "infoStyle",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "showDetail",
            "showSummary",
            "style",
            "styleClass",
            "title",
            "tooltip",
            "warnClass",
            "warnStyle",
        });
        beanMap.put(HtmlMessages.class,
                new String[] {
            "attributes",
            "children",
            "childCount",
            "errorClass",
            "errorStyle",
            "fatalClass",
            "fatalStyle",
            "globalOnly",
            "id", "family", "facets",
            "infoClass",
            "infoStyle",
            "layout",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "showDetail",
            "showSummary",
            "style",
            "styleClass",
            "title",
            "tooltip",
            "warnClass",
            "warnStyle",
        });
        beanMap.put(HtmlOutputFormat.class,
                new String[] {
            "attributes",
            "children",            "childCount",
            "converter",
            "escape",
            "id", "family", "facets",
            "localValue",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "style",
            "styleClass",
            "title",
            "value",
        });
        beanMap.put(HtmlOutputLabel.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",           "childCount",
            "converter",
            "dir",
            "for",
            "id", "family", "facets",
            "lang",
            "localValue",
            "onblur",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "style",
            "styleClass",
            "tabindex",
            "title",
            "value",
        });
        beanMap.put(HtmlOutputLink.class,
                new String[] {
            "accesskey",
            "attributes",
            "charset",
            "children",           "childCount",
            "converter",
            "coords",
            "dir",
            "hreflang",
            "id", "family", "facets",
            "lang",
            "localValue",
            "onblur",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "parent",
            "rel",
            "rendered",
            "rendererType",
            "rendersChildren",
            "rev",
            "shape",
            "style",
            "styleClass",
            "tabindex",
            "target",
            "title",
            "type",
            "value",
        });
        beanMap.put(HtmlOutputText.class,
                new String[] {
            "attributes",
            "children",           "childCount",
            "converter",
            "escape",
            "id", "family", "facets",
            "localValue",
            "parent",
            "rendered",
            "rendererType",
            "rendersChildren",
            "style",
            "styleClass",
            "title",
            "value",
        });
        beanMap.put(HtmlSelectBooleanCheckbox.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",            "childCount",
            "converter",
            "dir",
            "disabled",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "selected",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectManyCheckbox.class,
                new String[] {
            "accesskey",
            "attributes",
            "border",
            "children",         "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "layout",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "selectedValues",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectManyListbox.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",           "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "selectedValues",
            "size",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectManyMenu.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",           "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "selectedValues",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectOneListbox.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",           "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "size",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectOneMenu.class,
                new String[] {
            "accesskey",
            "attributes",
            "children",            "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        beanMap.put(HtmlSelectOneRadio.class,
                new String[] {
            "accesskey",
            "attributes",
            "border",
            "children",           "childCount",
            "converter",
            "dir",
            "disabled",
            "disabledClass",
            "enabledClass",
            "id", "family", "facets",
            "immediate",
            "lang",
            "layout",
            "localValue",
            "localValueSet",
            "onblur",
            "onchange",
            "onclick",
            "ondblclick",
            "onfocus",
            "onkeydown",
            "onkeypress",
            "onkeyup",
            "onmousedown",
            "onmousemove",
            "onmouseout",
            "onmouseover",
            "onmouseup",
            "onselect",
            "parent",
            "readonly",
            "rendered",
            "rendererType",
            "rendersChildren",
            "required",
            "style",
            "styleClass",
            "submittedValue",
            "tabindex",
            "title",
            "validator",
            "value",
            "valueChangeListener",
        });
        
        String[] sp = Introspector.getBeanInfoSearchPath();
        List paths = new ArrayList(Arrays.asList(sp));
        paths.add("org.netbeans.modules.visualweb.faces.dt_1_1.component");
        paths.add("org.netbeans.modules.visualweb.faces.dt_1_1.component.html");
        Introspector.setBeanInfoSearchPath((String []) paths.toArray(new String[paths.size()]));
    }
    
    protected void tearDown() throws Exception {
    }
    
    public void testBeanInfos() throws Exception {
        for(Object key : beanMap.keySet()) {
            Class beanClass = (Class) key;
            this.testBeanInfo(beanClass);
        }
    }
    
    public void testBeanInfo(Class beanClass) throws Exception {
        System.out.print(beanClass.getName() + "... ");
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        String beanName = beanInfo.getBeanDescriptor().getName();
        Set<String> expectedPropertySet = new HashSet(Arrays.asList((String []) beanMap.get(beanClass)));
        Set<String> introspectedPropertySet = new HashSet();
        for (PropertyDescriptor p : beanInfo.getPropertyDescriptors()) {
            introspectedPropertySet.add(p.getName());
        }
        for (String prop : expectedPropertySet) {
            this.assertTrue(beanName + " is missing '" + prop + "'", introspectedPropertySet.contains(prop));
        }
        for (String prop : introspectedPropertySet) {
            this.assertTrue(beanName + " should not have '" + prop + "'", expectedPropertySet.contains(prop));
        }
        System.out.println("done");
    }
    
}
