/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.uml.project.ui.customizer.uiapi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  phrebejk
 */
public class CustomizerPane extends javax.swing.JPanel implements HelpCtx.Provider {

    public static final String HELP_CTX_PROPERTY = "helpCtxProperty";
    public static final String OK_ENABLE_PROPERTY = "okEnableProperty";
    
    private Component currentCustomizer;
    private HelpCtx currentHelpCtx;
    
    private GridBagConstraints fillConstraints;
    
    private ProjectCustomizer.CategoryComponentProvider componentProvider;
    
    //private DialogDescriptor dialogDescriptor;
    
    /** Creates new form J2SECustomizer */
    public CustomizerPane( JPanel categoryView, CategoryModel categoryModel, ProjectCustomizer.CategoryComponentProvider componentProvider ) {
        initComponents();
        // HelpCtx.setHelpIDString( customizerPanel, "org.netbeans.modules.java.j2seproject.ui.customizer.J2SECustomizer" ); // NOI18N
        this.getAccessibleContext().setAccessibleDescription (NbBundle.getMessage(CustomizerPane.class,"AD_CustomizerPane")); // NOI18N
        this.componentProvider = componentProvider;
        fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        fillConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        fillConstraints.fill = java.awt.GridBagConstraints.BOTH;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;
        categoryModel.addPropertyChangeListener( new CategoryChangeListener() );
        categoryPanel.add( categoryView, fillConstraints );
        setCategory( categoryModel.getCurrentCategory() );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        categoryPanel = new javax.swing.JPanel();
        customizerPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(750, 450));
        jLabel1.setLabelFor(categoryPanel);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 11, 0, 0);
        add(jLabel1, gridBagConstraints);
        jLabel1.getAccessibleContext().setAccessibleName("");
        jLabel1.getAccessibleContext().setAccessibleDescription("");

        categoryPanel.setLayout(new java.awt.GridBagLayout());

        categoryPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        categoryPanel.setMinimumSize(new java.awt.Dimension(220, 4));
        categoryPanel.setPreferredSize(new java.awt.Dimension(220, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 11, 8, 11);
        add(categoryPanel, gridBagConstraints);
        categoryPanel.getAccessibleContext().setAccessibleName("");
        categoryPanel.getAccessibleContext().setAccessibleDescription("");

        customizerPanel.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 8, 11);
        add(customizerPanel, gridBagConstraints);
        customizerPanel.getAccessibleContext().setAccessibleName("");
        customizerPanel.getAccessibleContext().setAccessibleDescription("");

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel categoryPanel;
    private javax.swing.JPanel customizerPanel;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
    
    // HelpCtx.Provider implementation -----------------------------------------
    
    public HelpCtx getHelpCtx() {        
        return currentHelpCtx;        
        /*
        Debug.out.println("Get Help Ctx");
        Thread.dumpStack();
        
        if ( currentCustomizer != null  ) {
            // Debug.out.println( "C " + HelpCtx.findHelp( currentCustomizer )  );
            return HelpCtx.findHelp( currentCustomizer );
        }

        else {
            // Debug.out.println( "P " + HelpCtx.findHelp( currentCustomizer )  );
            return HelpCtx.findHelp( customizerPanel );
        }
              
        // XXX
        return null;
        */
    }
    
    
    // Private methods ---------------------------------------------------------
    
    private void setCategory( ProjectCustomizer.Category newCategory) {
        if ( newCategory == null ) {
            return;
        }

        if ( currentCustomizer != null ) {
            customizerPanel.remove( currentCustomizer );
        }

        JComponent newCustomizer = componentProvider.create( newCategory );

        if ( newCustomizer != null ) {
            currentCustomizer = newCustomizer;            
            currentHelpCtx = HelpCtx.findHelp( currentCustomizer );
            
            /*
            if ( currentCustomizer instanceof javax.swing.JComponent ) {
                ((javax.swing.JComponent)currentCustomizer).setPreferredSize( new java.awt.Dimension( 600, 0 ) );
            }
            */
            customizerPanel.add( currentCustomizer, fillConstraints );
            customizerPanel.validate();
            customizerPanel.repaint();
            newCustomizer.addPropertyChangeListener(mListener);
            firePropertyChange( HELP_CTX_PROPERTY, null, getHelpCtx() );
        }
        else {
            currentCustomizer = null;
        }

    }
    
    CategoryPanelChangeListener mListener = new CategoryPanelChangeListener();
    
    // Private innerclasses ----------------------------------------------------
                
    /** Listens to selection change and shows the customizers as
     *  panels
     */        
    private class CategoryChangeListener implements PropertyChangeListener {
        
        public void propertyChange(PropertyChangeEvent evt) {
            
            if ( CategoryModel.PROP_CURRENT_CATEGORY.equals( evt.getPropertyName() ) ) {                                
                ProjectCustomizer.Category newCategory = (ProjectCustomizer.Category)evt.getNewValue();
                setCategory( newCategory );
            }
        }
    }
    
     private class CategoryPanelChangeListener implements PropertyChangeListener
     {
        public void propertyChange(PropertyChangeEvent evt)
        {
           // Just forward this property change event to my listeners
           firePropertyChange(evt.getPropertyName(),
                              evt.getOldValue(),
                              evt.getNewValue());
        }
     }
}
