/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * WS70ConnectionTabVisualPanel.java
 */

package org.netbeans.modules.j2ee.sun.ws7.ui;
import org.netbeans.modules.j2ee.sun.ws7.dm.WS70SunDeploymentManager;
import javax.swing.*;
import java.awt.event.*;
/**
 *
 * @author  Mukesh Garg
 */
public class WS70ConnectionTabVisualPanel extends javax.swing.JPanel {

    private WS70SunDeploymentManager manager;
    /** Creates new form WS70ConnectionTabVisualPanel */
    public WS70ConnectionTabVisualPanel(WS70SunDeploymentManager dm) {
        manager = dm;
        initComponents();

        jAdminUrlTxt.setText(manager.getHost()+":"+manager.getPort());
        jAdminUserTxt.setText(manager.getUserName());
        jPasswordTxt.setText(manager.getPassword());
        jLocationTxt.setText(manager.getServerLocation());       

    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jAdminUrlLbl = new javax.swing.JLabel();
        jAdminUrlTxt = new javax.swing.JTextField();
        jLocationLbl = new javax.swing.JLabel();
        jLocationTxt = new javax.swing.JTextField();
        jAdminUserLbl = new javax.swing.JLabel();
        jAdminUserTxt = new javax.swing.JTextField();
        jPasswordLbl = new javax.swing.JLabel();
        jPasswordTxt = new javax.swing.JPasswordField();

        addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                formPropertyChange(evt);
            }
        });
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                formFocusLost(evt);
            }
        });

        jAdminUrlLbl.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_Connection_Url_Mnem").charAt(0));
        jAdminUrlLbl.setLabelFor(jAdminUrlTxt);
        jAdminUrlLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("LBL_ConnectionAdminUrl"));
        jAdminUrlLbl.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_NAME_ConnectionAdminUrl"));
        jAdminUrlLbl.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_DESC_ConnectionAdminUrl"));
        jAdminUrlLbl.getAccessibleContext().setAccessibleParent(this);

        jAdminUrlTxt.setEditable(false);

        jLocationLbl.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_Connection_Location_Mnem").charAt(0));
        jLocationLbl.setLabelFor(jLocationTxt);
        jLocationLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("LBL_ConnectionLocation"));
        jLocationLbl.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_NAME_ConnectionLocation"));
        jLocationLbl.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_DESC_ConnectionLocation"));
        jLocationLbl.getAccessibleContext().setAccessibleParent(this);

        jLocationTxt.setEditable(false);

        jAdminUserLbl.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_Connection_User_Mnem").charAt(0));
        jAdminUserLbl.setLabelFor(jAdminUserTxt);
        jAdminUserLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("LBL_ConnectionAdminUser"));
        jAdminUserLbl.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_NAME_ConnectionAdminUser"));
        jAdminUserLbl.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_DESC_ConnectionAdminUser"));
        jAdminUserLbl.getAccessibleContext().setAccessibleParent(this);

        jAdminUserTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jAdminUserTxtKeyReleased(evt);
            }
        });

        jPasswordLbl.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_Connection_Password_Mnem").charAt(0));
        jPasswordLbl.setLabelFor(jPasswordTxt);
        jPasswordLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("LBL_ConnectionPassword"));
        jPasswordLbl.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_NAME_ConnectionPassword"));
        jPasswordLbl.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ws7/ui/Bundle").getString("A11Y_DESC_ConnectionPassword"));
        jPasswordLbl.getAccessibleContext().setAccessibleParent(this);

        jPasswordTxt.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jPasswordTxtFocusLost(evt);
            }
        });
        jPasswordTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jPasswordTxtKeyReleased(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(22, 22, 22)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jAdminUrlLbl)
                    .add(jLocationLbl)
                    .add(jAdminUserLbl)
                    .add(jPasswordLbl))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jPasswordTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 248, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(layout.createSequentialGroup()
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(jAdminUrlTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE)
                                .add(jLocationTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE))
                            .add(96, 96, 96))
                        .add(layout.createSequentialGroup()
                            .add(jAdminUserTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE)
                            .addContainerGap()))))
        );

        layout.linkSize(new java.awt.Component[] {jAdminUrlTxt, jAdminUserTxt, jLocationTxt, jPasswordTxt}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(28, 28, 28)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jAdminUrlLbl)
                    .add(jAdminUrlTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLocationLbl)
                    .add(jLocationTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(19, 19, 19)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jAdminUserLbl)
                    .add(jAdminUserTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(17, 17, 17)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jPasswordTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPasswordLbl))
                .addContainerGap(138, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {jAdminUrlTxt, jAdminUserTxt, jLocationTxt, jPasswordTxt}, org.jdesktop.layout.GroupLayout.VERTICAL);

        layout.linkSize(new java.awt.Component[] {jAdminUrlLbl, jAdminUserLbl, jLocationLbl, jPasswordLbl}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents

    private void formPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_formPropertyChange
        
        String propertyname = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        
        // when server customizer gets closed, this panel is removed from the 
        // Server customizer WS70Customizer tab panel
        if(propertyname!=null && propertyname.equals("ancestor")){
            if(oldValue!=null && newValue==null){
                String uname = jAdminUserTxt.getText();                              
                char[] passWd = jPasswordTxt.getPassword();
                String password = new String(passWd);
                manager.refreshInnerDM(uname, password);
            }
        }        
    }//GEN-LAST:event_formPropertyChange

    private void formFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusLost
    }//GEN-LAST:event_formFocusLost

    private void jPasswordTxtFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jPasswordTxtFocusLost
    }//GEN-LAST:event_jPasswordTxtFocusLost

    private void jPasswordTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jPasswordTxtKeyReleased
    }//GEN-LAST:event_jPasswordTxtKeyReleased

    private void jAdminUserTxtKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jAdminUserTxtKeyReleased
    }//GEN-LAST:event_jAdminUserTxtKeyReleased
    
    public boolean isValid(){
        if(jAdminUserTxt.getText()==null || jAdminUserTxt.getText().trim().length()==0){
            return false;
            //LOG ERROR
        }
        return true;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jAdminUrlLbl;
    private javax.swing.JTextField jAdminUrlTxt;
    private javax.swing.JLabel jAdminUserLbl;
    private javax.swing.JTextField jAdminUserTxt;
    private javax.swing.JLabel jLocationLbl;
    private javax.swing.JTextField jLocationTxt;
    private javax.swing.JLabel jPasswordLbl;
    private javax.swing.JPasswordField jPasswordTxt;
    // End of variables declaration//GEN-END:variables
    
}
