/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
/*
 * KeyFieldEntryPanel.java
 *
 * Created on February 4, 2004, 12:37 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.text.MessageFormat;

import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.DefaultComboBoxModel;

import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;
import org.openide.util.NbBundle;

/**
 *
 * @author Peter Williams
 */
public class KeyFieldEntryPanel extends JPanel implements GenericTableDialogPanelAccessor {
	
	private final ResourceBundle webappBundle = NbBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");	// NOI18N

	private final ResourceBundle commonBundle = NbBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");	// NOI18N

	private static final TextMapping [] keyScopeTypes = ScopeMapping.getKeyScopeMappings();	

	// Field indices (maps to values[] handled by get/setValues()
	private static final int NAME_FIELD = 0;
	private static final int SCOPE_FIELD = 1;
	private static final int NUM_FIELDS = 2;	// Number of objects expected in get/setValue methods.

	// Local storage for data entered by user
	private String keyFieldName;
	private String keyFieldScope;

	// expression combo box model
	private DefaultComboBoxModel keyFieldScopeModel;	

	/** Creates new form KeyFieldEntryPanel */
	public KeyFieldEntryPanel() {
		initComponents();
		initUserComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblKeyFieldReq = new javax.swing.JLabel();
        jLblKeyFieldName = new javax.swing.JLabel();
        jTxtKeyFieldName = new javax.swing.JTextField();
        jLblFiller1 = new javax.swing.JLabel();
        jLblKeyScope = new javax.swing.JLabel();
        jCbxKeyScope = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        jLblKeyFieldReq.setLabelFor(jTxtKeyFieldName);
        jLblKeyFieldReq.setText(commonBundle.getString("LBL_RequiredMark"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(jLblKeyFieldReq, gridBagConstraints);
        jLblKeyFieldReq.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_RequiredMark"));
        jLblKeyFieldReq.getAccessibleContext().setAccessibleDescription(commonBundle.getString("ACSD_RequiredMark"));

        jLblKeyFieldName.setDisplayedMnemonic(webappBundle.getString("MNE_KeyFieldName").charAt(0));
        jLblKeyFieldName.setLabelFor(jTxtKeyFieldName);
        jLblKeyFieldName.setText(webappBundle.getString("LBL_KeyFieldName_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(jLblKeyFieldName, gridBagConstraints);

        jTxtKeyFieldName.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtKeyFieldNameKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jTxtKeyFieldName, gridBagConstraints);
        jTxtKeyFieldName.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_KeyFieldName"));
        jTxtKeyFieldName.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_KeyFieldName"));

        jLblFiller1.setLabelFor(jCbxKeyScope);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(jLblFiller1, gridBagConstraints);

        jLblKeyScope.setDisplayedMnemonic(webappBundle.getString("MNE_KeyFieldScope").charAt(0));
        jLblKeyScope.setLabelFor(jCbxKeyScope);
        jLblKeyScope.setText(webappBundle.getString("LBL_KeyFieldScope_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(jLblKeyScope, gridBagConstraints);

        jCbxKeyScope.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCbxKeyScopeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jCbxKeyScope, gridBagConstraints);
        jCbxKeyScope.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_KeyFieldScope"));
        jCbxKeyScope.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_KeyFieldScope"));

    }// </editor-fold>//GEN-END:initComponents

	private void jCbxKeyScopeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCbxKeyScopeActionPerformed
		TextMapping scope = (TextMapping) keyFieldScopeModel.getSelectedItem();
		keyFieldScope = scope.getXMLString();
		firePropertyChange(Constants.USER_DATA_CHANGED, null, null);
	}//GEN-LAST:event_jCbxKeyScopeActionPerformed

	private void jTxtKeyFieldNameKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtKeyFieldNameKeyReleased
		keyFieldName = jTxtKeyFieldName.getText();
		firePropertyChange(Constants.USER_DATA_CHANGED, null, null);
	}//GEN-LAST:event_jTxtKeyFieldNameKeyReleased
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jCbxKeyScope;
    private javax.swing.JLabel jLblFiller1;
    private javax.swing.JLabel jLblKeyFieldName;
    private javax.swing.JLabel jLblKeyFieldReq;
    private javax.swing.JLabel jLblKeyScope;
    private javax.swing.JTextField jTxtKeyFieldName;
    // End of variables declaration//GEN-END:variables
	
	private void initUserComponents() {
		// Setup match expression combobox
		keyFieldScopeModel = new DefaultComboBoxModel();
		for(int i = 0; i < keyScopeTypes.length; i++) {
			keyFieldScopeModel.addElement(keyScopeTypes[i]);
		}
		jCbxKeyScope.setModel(keyFieldScopeModel);		
	}
	
	private TextMapping getScopeMapping(String xmlKey) {
		TextMapping result = null;
		if(xmlKey == null) {
			xmlKey = ""; // NOI18N
		}
		for(int i = 0; i < keyScopeTypes.length; i++) {
			if(keyScopeTypes[i].getXMLString().compareTo(xmlKey) == 0) {
				result = keyScopeTypes[i];
				break;
			}
		}
		
		return result;
	}	
	
	/** -----------------------------------------------------------------------
	 *  Implementation of GenericTableDialogPanelAccessor interface
	 */	
	public void init(ASDDVersion asVersion, int preferredWidth, java.util.List entries, Object data) {
		setPreferredSize(new Dimension(preferredWidth, getPreferredSize().height));
	}
	
	public Object[] getValues() {
		Object [] result = new Object[NUM_FIELDS];
		
		result[NAME_FIELD] = keyFieldName;
		result[SCOPE_FIELD] = keyFieldScope;
		
		return result;		
	}	
	
	public void setValues(Object[] values) {
		if(values != null && values.length == NUM_FIELDS) {
			keyFieldName = (String) values[NAME_FIELD];
			keyFieldScope = (String) values[SCOPE_FIELD];
		} else {
			if(values != null) {
				assert (values.length == NUM_FIELDS);	// Should fail
			}
			
			// default values
			keyFieldName = "";	// NOI18N
			keyFieldScope = "";	// NOI18N
		}
		
		setComponentValues();
	}
	
	private void setComponentValues() {
		jTxtKeyFieldName.setText(keyFieldName);		
		keyFieldScopeModel.setSelectedItem(getScopeMapping(keyFieldScope));
	}
	
	public Collection getErrors(ValidationSupport validationSupport) {
		ArrayList errorList = new ArrayList();
		
		if(!Utils.notEmpty(keyFieldName)) {
			Object [] args = new Object [1];
			args[0] = webappBundle.getString("LBL_KeyFieldName");
			errorList.add(MessageFormat.format(commonBundle.getString("ERR_SpecifiedFieldIsEmpty"), args));
		} else if(!Utils.isJavaIdentifier(keyFieldName)) {
			Object [] args = new Object [1];
			args[0] = keyFieldName;
			errorList.add(MessageFormat.format(commonBundle.getString("ERR_NotValidIdentifier"), args));
		}
		
		return errorList;
	}	

	public boolean requiredFieldsFilled() {
		return (keyFieldName != null && keyFieldName.length() > 0);
	}
}
