/*
 * ServerTypeChooserVisual.java
 *
 * Created on 16 Май 2007 г., 13:15
 */

package org.netbeans.modules.php.rt.ui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

import org.netbeans.modules.php.rt.spi.providers.WebServerProvider;

/**
 *
 * @author  den
 */
class ServerTypeChooserVisual extends JPanel {

    private static final long serialVersionUID = -708817051948062887L;
    
    /** Creates new form ServerTypeChooserVisual */
    public ServerTypeChooserVisual() {
        initComponents();
        init();
    }
    
    void read( AddHostWizard wizard ) {
        WebServerProvider provider = wizard.getCurrentProvider();
        if ( provider != null  ) {
            myTypes.setSelectedItem( provider.getTypeName() );
            
            setDescription(provider);
        }
    }

    void store( AddHostWizard wizard ) {
        int index = myTypes.getSelectedIndex();
        WebServerProvider provider = WebServerProvider.ServerFactory.
            getProviders()[index];
        wizard.putProperty( AddHostWizard.PROVIDER, provider );
    }

    private void init() {
        /*
         * Init combobox and description for chosen element. 
         */
        WebServerProvider[] providers = 
            WebServerProvider.ServerFactory.getProviders();
        String[] names = new String[ providers.length ];
        int i=0;
        for (WebServerProvider provider : providers) {
            names[i++] = provider.getTypeName();
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel( names );
        myTypes.setModel( model );
        
        myDescription.setText(providers[ myTypes.getSelectedIndex()].
                getDescription() );
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myTypeLabel = new javax.swing.JLabel();
        myTypes = new javax.swing.JComboBox();
        myDescriptionLabel = new javax.swing.JLabel();
        myDescription = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(myTypeLabel, org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "LBL_ServerType")); // NOI18N

        myTypes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(myDescriptionLabel, org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "LBL_Description")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myDescription, "");
        myDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(myTypeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(myTypes, 0, 337, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(myDescriptionLabel)
                        .add(18, 18, 18)
                        .add(myDescription, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 335, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myTypeLabel)
                    .add(myTypes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDescriptionLabel)
                    .add(myDescription, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 252, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myTypeLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "A11_ServerTypeLbl")); // NOI18N
        myTypes.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "A11_ServerTypeChooser")); // NOI18N
        myDescriptionLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "A11_DescriptionLbl")); // NOI18N
        myDescription.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ServerTypeChooserVisual.class, "A11_Description")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void typeChanged(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeChanged
        int index = myTypes.getSelectedIndex();
        WebServerProvider provider = WebServerProvider.ServerFactory.
            getProviders()[index];
        
        setDescription(provider);
    }//GEN-LAST:event_typeChanged
    
    private void setDescription( WebServerProvider provider ) {
        String descr = provider.getDescription();
        myDescription.setText( descr );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel myDescription;
    private javax.swing.JLabel myDescriptionLabel;
    private javax.swing.JLabel myTypeLabel;
    private javax.swing.JComboBox myTypes;
    // End of variables declaration//GEN-END:variables
    
}
