/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.rt.providers.impl.ftp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.rt.WebServerRegistry;
import org.netbeans.modules.php.rt.providers.impl.HostImpl;
import org.netbeans.modules.php.rt.providers.impl.ServerCustomizerComponent;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  ads
 */
public abstract  class FtpConfigPanelVisual extends ServerCustomizerComponent {

    private static final long serialVersionUID = -4482997001849592268L;

    private static final String TXT_DEFAULT_PORT = "TXT_DefaultPort"; // NOI18N
    private static final String MSG_WARNING_DOMAIN = "MSG_DomainWarning"; // NOI18N
    private static final String MSG_INCORRECT_DOMAIN = "MSG_IncorrectDomainName"; // NOI18N
    private static final String MSG_WARNING_FTP_SERVER = "MSG_FtpServerWarning"; // NOI18N
    private static final String MSG_INCORRECT_FTP_SERVER = "MSG_IncorrectFtpServerName"; // NOI18N
    private static final String MSG_DUPLICATE_HOST = "MSG_DuplicateHost"; // NOI18N
    private static final String LBL_VALIDATING_SERVERS = "LBL_ValidatingServers"; // NOI18N

    /** Creates new form FtpConfigPanelVisual */
    public FtpConfigPanelVisual(FtpServerProvider provider) {
        myProvider = provider;

        initComponents();
        
        init();
    }

    private void init() {
        setDefaults();

        DocumentListener listener = new TextFieldListener();

        getDomain().getDocument().addDocumentListener(listener);
        getPort().getDocument().addDocumentListener(listener);
        getFtpServer().getDocument().addDocumentListener(listener);
    }


    protected abstract void setErrorMessage(String message);
    protected abstract void setDefaults();

    public void readValues(HostImpl host) {
        if (host != null) {
            assert host instanceof FtpHostImpl;
            FtpHostImpl impl = (FtpHostImpl) host;

            String domain = (String) impl.getProperty(HostImpl.DOMAIN);
            String port = (String) impl.getProperty(HostImpl.PORT);
            String contextRootPath = (String) impl.getProperty(FtpHostImpl.CONTEXT_ROOT_PATH);
            String ftpServer = (String) impl.getProperty(FtpHostImpl.FTP_SERVER);
            String ftpUserName = (String) impl.getProperty(FtpHostImpl.FTP_USER_NAME);
            char[] ftpPassword = (char[]) impl.getProperty(FtpHostImpl.FTP_PASSWORD);
            String ftpDirectory = (String) impl.getProperty(FtpHostImpl.FTP_DIRECTORY);

            if (port == null || port.trim().length() == 0) {
                port = getMessage(TXT_DEFAULT_PORT);
            }

            getPort().setText(port);
            getDomain().setText(domain);
            getContextRootPath().setText(contextRootPath);
            getFtpServer().setText(ftpServer);
            getFtpUserName().setText(ftpUserName);
            getFtpPassword().setText(String.copyValueOf(ftpPassword));
            getFtpDirectory().setText(ftpDirectory);
        }
        doContentValidation(false);
    }

    public HostImpl storeValues() {
        FtpHostImpl impl = createHostImpl();

        impl.setProperty(FtpHostImpl.CONTEXT_ROOT_PATH, getContextRootPath().getText());
        impl.setProperty(FtpHostImpl.FTP_SERVER, getFtpServer().getText());
        impl.setProperty(FtpHostImpl.FTP_USER_NAME, getFtpUserName().getText());
        impl.setProperty(FtpHostImpl.FTP_PASSWORD, getFtpPassword().getPassword());
        impl.setProperty(FtpHostImpl.FTP_DIRECTORY, getFtpDirectory().getText());

        return impl;
    }

    private FtpHostImpl createHostImpl() {
        FtpHostImpl impl = new FtpHostImpl(getDomain().getText(), getPort().getText(), getProvider());
        return impl;
    }

    public boolean doContentValidation() {
        boolean validateUnique = true;
        return doContentValidation(validateUnique);
    }

    public boolean doContentValidation(boolean validateUnique) {
        boolean isContentValid = validatePort() && validateDomain() && validateFtpServer() && validateFtpDirectory() && validateContextRootPath();
        if (!validateUnique) {
            return isContentValid;
        }
        return isContentValid && validateUnique();
    }

    public void doFinalContentValidation() {
        ProgressHandle progress = ProgressHandleFactory.createHandle(getMessage(LBL_VALIDATING_SERVERS));
        progress.start();
        
        validateDomainFinaly();
        validateFtpServerFinaly();

        progress.finish();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        myDomainLbl = new javax.swing.JLabel();
        myPortLbl = new javax.swing.JLabel();
        myFtpServerLbl = new javax.swing.JLabel();
        myFtpUserNameLbl = new javax.swing.JLabel();
        myFtpPasswordLbl = new javax.swing.JLabel();
        myContextRootPathLbl = new javax.swing.JLabel();
        myFtpServer = new javax.swing.JTextField();
        myContextRootPath = new javax.swing.JTextField();
        myFtpUserName = new javax.swing.JTextField();
        myFtpPassword = new javax.swing.JPasswordField();
        myDomain = new javax.swing.JTextField();
        myPort = new javax.swing.JTextField();
        myFtpDirectory = new javax.swing.JTextField();
        myFtpDirectoryLbl = new javax.swing.JLabel();
        httpServerSeparator = new javax.swing.JSeparator();
        httpServerSeparatorLabel = new javax.swing.JLabel();
        ftpServerSeparator = new javax.swing.JSeparator();
        jLabel3 = new javax.swing.JLabel();

        jLabel1.setText("jLabel1");

        myDomainLbl.setLabelFor(myDomain);
        org.openide.awt.Mnemonics.setLocalizedText(myDomainLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_Domain")); // NOI18N

        myPortLbl.setLabelFor(myPort);
        org.openide.awt.Mnemonics.setLocalizedText(myPortLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_Port")); // NOI18N

        myFtpServerLbl.setLabelFor(myFtpServer);
        org.openide.awt.Mnemonics.setLocalizedText(myFtpServerLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_FtpServer")); // NOI18N

        myFtpUserNameLbl.setLabelFor(myFtpUserName);
        org.openide.awt.Mnemonics.setLocalizedText(myFtpUserNameLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_UserName")); // NOI18N

        myFtpPasswordLbl.setLabelFor(myFtpPassword);
        org.openide.awt.Mnemonics.setLocalizedText(myFtpPasswordLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_Password")); // NOI18N

        myContextRootPathLbl.setLabelFor(myContextRootPath);
        org.openide.awt.Mnemonics.setLocalizedText(myContextRootPathLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_ContextRootPath")); // NOI18N

        myFtpServer.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myFtpServer.text")); // NOI18N

        myContextRootPath.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myContextRootPath.text")); // NOI18N

        myFtpUserName.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myFtpUserName.text")); // NOI18N

        myFtpPassword.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myFtpPassword.text")); // NOI18N
        myFtpPassword.setPreferredSize(new java.awt.Dimension(6, 20));

        myDomain.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myDomain.text")); // NOI18N

        myPort.setDocument(new IntegerDocument());
        myPort.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myPort.text")); // NOI18N

        myFtpDirectory.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.myFtpDirectory.text")); // NOI18N

        myFtpDirectoryLbl.setLabelFor(myFtpDirectory);
        org.openide.awt.Mnemonics.setLocalizedText(myFtpDirectoryLbl, org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "LBL_FtpDirectory")); // NOI18N

        httpServerSeparator.setToolTipText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.httpServerSeparator.toolTipText")); // NOI18N

        httpServerSeparatorLabel.setFont(new java.awt.Font("Tahoma", 1, 11));
        httpServerSeparatorLabel.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.httpServerSeparatorLabel.text")); // NOI18N
        httpServerSeparatorLabel.setOpaque(true);

        ftpServerSeparator.setToolTipText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.ftpServerSeparator.toolTipText")); // NOI18N

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel3.setText(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "FtpConfigPanelVisual.jLabel3.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(httpServerSeparatorLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 103, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(httpServerSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 401, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(myPortLbl)
                            .add(myContextRootPathLbl)
                            .add(myDomainLbl))
                        .add(55, 55, 55)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, myPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 39, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, myDomain, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 365, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, myContextRootPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 365, Short.MAX_VALUE)))
                    .add(layout.createSequentialGroup()
                        .add(jLabel3)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(ftpServerSeparator, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 429, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(myFtpServerLbl)
                            .add(myFtpDirectoryLbl)
                            .add(myFtpPasswordLbl)
                            .add(myFtpUserNameLbl))
                        .add(11, 11, 11)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(myFtpDirectory, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 368, Short.MAX_VALUE))
                            .add(myFtpPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 125, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(myFtpUserName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 125, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(myFtpServer, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 368, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(httpServerSeparatorLabel)
                    .add(layout.createSequentialGroup()
                        .add(8, 8, 8)
                        .add(httpServerSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDomainLbl)
                    .add(myDomain, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myPortLbl)
                    .add(myPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myContextRootPathLbl)
                    .add(myContextRootPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(layout.createSequentialGroup()
                        .add(9, 9, 9)
                        .add(ftpServerSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myFtpServerLbl)
                    .add(myFtpServer, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myFtpUserName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(myFtpUserNameLbl))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myFtpPasswordLbl)
                    .add(myFtpPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myFtpDirectoryLbl)
                    .add(myFtpDirectory, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(27, Short.MAX_VALUE))
        );

        myDomainLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_DomainLbl")); // NOI18N
        myFtpServerLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_FtpServerLbl")); // NOI18N
        myFtpUserNameLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_UserNameLbl")); // NOI18N
        myFtpPasswordLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_PasswordLbl")); // NOI18N
        myContextRootPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_DocumentPathLbl")); // NOI18N
        myFtpServer.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_FtpServer")); // NOI18N
        myContextRootPath.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_ContextRootPath")); // NOI18N
        myFtpUserName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_UserName")); // NOI18N
        myFtpPassword.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_Password")); // NOI18N
        myDomain.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_Domain")); // NOI18N
        myPort.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_Port")); // NOI18N
        myFtpDirectory.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_FtpDirectory")); // NOI18N
        myFtpDirectoryLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FtpConfigPanelVisual.class, "A11_FtpDirectoryLbl")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private boolean validateContextRootPath() {

        boolean empty = getContextRootPath().getText().trim().length() == 0;
        if (!empty) {
            // TODO: add validation
        }
        return true;
    }

    private boolean validateFtpDirectory() {
        boolean empty = getFtpDirectory().getText().trim().length() == 0;
        if (!empty) {
            // TODO: add validation
        }
        return true;
    }

    private boolean validatePort() {
        /*
         * This is check only for sure. No message will appear
         * as error in the case of error becuase port should
         * not be incorrect. It is prevented by special document in
         * port text field.
         */
        return isValidNumber(getPort().getText());
    }


    private boolean validateFtpServer() {
        String ftpServer = getFtpServer().getText();
        if (ftpServer == null || ftpServer.trim().length() == 0) {
            setErrorMessage(getMessage(MSG_INCORRECT_FTP_SERVER));
            return false;
        }
        return true;
    }

    private void validateFtpServerFinaly() {
        /*
         * check is performed for notification only.
         * User could don't have direct connect to Internet and
         * in this case Proxy can be used ( for name resolution also ).
         */
        String ftpServer = getFtpServer().getText();
        if (!isValidInetAddress(ftpServer)) {
            NotifyDescriptor descriptor = new NotifyDescriptor.Message(getMessage(MSG_WARNING_FTP_SERVER, ftpServer));
            DialogDisplayer.getDefault().notify(descriptor);
        }
    }

    private boolean validateDomain() {
        String domain = getDomain().getText();
        if (domain == null || domain.trim().length() == 0) {
            setErrorMessage(getMessage(MSG_INCORRECT_DOMAIN));
            return false;
        }
        return true;
    }

    private void validateDomainFinaly() {
        /*
         * check is performed for notification only.
         * User could don't have direct connect to Internet and
         * in this case Proxy can be used ( for name resolution also ).
         */
        String domain = getDomain().getText();
        if (!isValidInetAddress(domain)) {
            NotifyDescriptor descriptor = new NotifyDescriptor.Message(getMessage(MSG_WARNING_DOMAIN, domain));
            DialogDisplayer.getDefault().notify(descriptor);
        }
    }

    private boolean isValidInetAddress(String addressName) {
        boolean valid = true;
        try {
            InetAddress address = InetAddress.getByName(addressName);
            valid = address != null;
        } catch (UnknownHostException e) {
            valid = false;
        }
        return valid;
    }

    private boolean validateUnique() {
        Collection<Host> collection = WebServerRegistry.getInstance().getHosts();
        Host host = createHostImpl();
        boolean flag = collection.contains(host);
        if (flag) {
            setErrorMessage(getMessage(MSG_DUPLICATE_HOST, host));
        }
        return !flag;
    }

    String getMessage(String key, Object... args) {
        String message = null;
        if (args.length > 0) {
            message = MessageFormat.format(NbBundle.getMessage(FtpConfigPanelVisual.class, key), args);
        } else {
            message = NbBundle.getMessage(FtpConfigPanelVisual.class, key);
        }
        return message;
    }

    static boolean isValidNumber(String str) {
        boolean flag;
        try {
            Integer.parseInt(str);
            flag = true;
        } catch (NumberFormatException e) {
            flag = false;
        }
        return flag;
    }

    protected JTextField getPort() {
        return myPort;
    }

    protected JTextField getDomain() {
        return myDomain;
    }

    protected JTextField getContextRootPath() {
        return myContextRootPath;
    }

    protected JTextField getFtpServer() {
        return myFtpServer;
    }

    protected JPasswordField getFtpPassword() {
        return myFtpPassword;
    }

    protected JTextField getFtpUserName() {
        return myFtpUserName;
    }

    protected JTextField getFtpDirectory() {
        return myFtpDirectory;
    }

    private FtpServerProvider getProvider() {
        return myProvider;
    }

    private static class IntegerDocument extends PlainDocument {

        private static final long serialVersionUID = -6127390393638310191L;

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {

            if (str == null) {
                return;
            }

            if (isValidNumber(str)) {
                super.insertString(offs, str, a);
            }
        }
    }

    class TextFieldListener implements DocumentListener {

        public void changedUpdate(DocumentEvent e) {
            actionPerformed();
        }

        public void insertUpdate(DocumentEvent e) {
            actionPerformed();
        }

        public void removeUpdate(DocumentEvent e) {
            actionPerformed();
        }
        
        private void actionPerformed() {
            stateChanged();
        }
    }
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator ftpServerSeparator;
    private javax.swing.JSeparator httpServerSeparator;
    private javax.swing.JLabel httpServerSeparatorLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField myContextRootPath;
    private javax.swing.JLabel myContextRootPathLbl;
    private javax.swing.JTextField myDomain;
    private javax.swing.JLabel myDomainLbl;
    private javax.swing.JTextField myFtpDirectory;
    private javax.swing.JLabel myFtpDirectoryLbl;
    private javax.swing.JPasswordField myFtpPassword;
    private javax.swing.JLabel myFtpPasswordLbl;
    private javax.swing.JTextField myFtpServer;
    private javax.swing.JLabel myFtpServerLbl;
    private javax.swing.JTextField myFtpUserName;
    private javax.swing.JLabel myFtpUserNameLbl;
    private javax.swing.JTextField myPort;
    private javax.swing.JLabel myPortLbl;
    // End of variables declaration//GEN-END:variables
    private FtpServerProvider myProvider;
}
