/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.models;

import javax.swing.Action;
import org.netbeans.modules.scripting.php.dbginterface.DbgDebuggerImpl;
import org.netbeans.modules.scripting.php.dbginterface.ModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.spi.debugger.ui.Constants;
import org.openide.util.NbBundle;

/**
 *
 * @author   Jan Jancura
 */
public class ThreadsModel extends ModelSupport
        implements TreeModel, NodeModel, NodeActionsProvider, TableModel {

    private static final boolean DEBUG = false;

    public static final String CURRENT =
        "org/netbeans/modules/debugger/resources/threadsView/CurrentThread"; // NOI18N
    public static final String RUNNING =
        "org/netbeans/modules/debugger/resources/threadsView/RunningThread"; // NOI18N
    public static final String SUSPENDED =
        "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread"; // NOI18N

    public ThreadsModel(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    private ContextProvider contextProvider;

    private ContextProvider getContextProvider() {
        return contextProvider;
    }

    private DbgDebuggerImpl getDebugger() {
        return (DbgDebuggerImpl)contextProvider.lookupFirst(null, DbgDebuggerImpl.class);
    }

    // ------------------------------------------------------------------------
    // TreeModel implementation
    // ------------------------------------------------------------------------
    public Object getRoot() {
        return ROOT;
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getChildren",parent); // NOI18N
        if (parent == ROOT) {
            return getDebugger().getScriptContexts();
        }
        
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"isLeaf",node); // NOI18N
        if (node == ROOT) {
            return false;
        }
        else if (node instanceof DbgDebuggerImpl.Context) {
            return true;
        }

        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getChildrenCount",node); // NOI18N
        if (node == ROOT) {
            return getDebugger().getScriptContexts().length;
        }
        throw new UnknownTypeException(node);
    }

    // ------------------------------------------------------------------------
    // NodeModel implementation
    // ------------------------------------------------------------------------
    public String getDisplayName(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getDisplayName",node); // NOI18N
        if (node instanceof DbgDebuggerImpl.Context) {
            DbgDebuggerImpl.Context context = (DbgDebuggerImpl.Context) node;
            String contextName = context.toString();
            String debuggerName = context.getServer().toString();
            
            return NbBundle.getMessage(ThreadsModel.class, "LBL_ThreadName", contextName, debuggerName); // NOI18N
        }
        else if (node == ROOT) {
            return ROOT.toString();
        }
        
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getIconBase",node); // NOI18N
        if (node instanceof DbgDebuggerImpl.Context) {
            if (((DbgDebuggerImpl.Context)node).isSuspended()) {
                return SUSPENDED;
            }
            else if (((DbgDebuggerImpl.Context)node).isCurrent()) {
                return CURRENT;
            }
            else {
                return RUNNING;
            }
        }
        else if (node == ROOT) {
            return null;
        }
        
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getShortDescription",node); // NOI18N
        if (node == ROOT) {
            return null;
        }
        else if (node instanceof DbgDebuggerImpl.Context) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    // ------------------------------------------------------------------------
    // NodeActionsProvider implementation
    // ------------------------------------------------------------------------
    public void performDefaultAction(Object node) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"performDefaultAction",node); // NOI18N
        if (node instanceof DbgDebuggerImpl.Context) {
            DbgDebuggerImpl.Context context = (DbgDebuggerImpl.Context) node;
            
            if (!context.isCurrent()) {
                getDebugger().setCurrentScriptContext(context);
                refresh(false);
            }
        }
        
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action [] {};
    }

    // ------------------------------------------------------------------------
    // TableModel implementation
    // ------------------------------------------------------------------------
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"getValueAt", node); // NOI18N
        if (node == ROOT) {
            return null;
        }

        if (node instanceof DbgDebuggerImpl.Context) {
            DbgDebuggerImpl.Context context = (DbgDebuggerImpl.Context)node;
            
            if (columnID == Constants.THREAD_SUSPENDED_COLUMN_ID) {
                return context.isSuspended();
            }
            else if (columnID == Constants.THREAD_STATE_COLUMN_ID) {
                String result = NbBundle.getMessage(ThreadsModel.class,
                        (context.isCurrent() ? "LBL_ActiveThreadState" : "LBL_InactiveThreadState"), // NOI18N
                        NbBundle.getMessage(ThreadsModel.class,
                        (context.isSuspended() ? "LBL_Suspended" : "LBL_Running"))); // NOI18N
                return result;
            }
        }

        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"isReadOnly", node); // NOI18N
        if (node == ROOT) {
            return true;
        }
        else if (node instanceof DbgDebuggerImpl.Context) {
            return true;
        }

        // if(DEBUG) Debug.verboseWithin(this, "isReadOnly", "THROWING -> UTE + " + node); // NOI18N
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
//        if(DEBUG) Debug.verboseWithin(this,"setValueAt", node); // NOI18N
        throw new UnknownTypeException(node);
    }


    // ------------------------------------------------------------------------
    // Event support
    // ------------------------------------------------------------------------

    public void updateThreadState(DbgDebuggerImpl.Context context) {
        // if(DEBUG) Debug.verboseWithin(this, "updateThreadState"); // NOI18N

        fireChangeEvent(new ModelEvent.NodeChanged(this, context));
    }

    public void updateThreadState(DbgDebuggerImpl.Context[] context) {
        // if(DEBUG) Debug.verboseWithin(this, "updateThreadState[]"); // NOI18N

        ModelEvent[] events = new ModelEvent[context.length];
        
        for(int i = 0; i < context.length; i++) {
            events[i] = new ModelEvent.NodeChanged(this, context[i]);
        }
        fireChangeEvents(events);
    }
}
