/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 
package org.netbeans.microedition.testme.bt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;

/**
 *
 * @author PavelBenes
 */
public class BTLogger implements ConnectionWizard.ConnectionListener, CommandListener {
    public static final  Command BT_CONNECT  = new Command("BT connect", Command.SCREEN, 1);
    public static final  Command BT_RESET    = new Command("BT reset", Command.SCREEN, 1);
    public static final  Command BT_STATUS   = new Command("BT status", Command.SCREEN, 1);
    public static final  Command BT_VIEW_LOG = new Command("BT log", Command.SCREEN, 1);
    public static final  Command BT_LOG_BACK = new Command("Back", Command.BACK, 0);
    
    private final MIDlet                    midletContext;
    private Displayable                     previousScreen;
    private OutputStream                    btOut;
    private ConnectionWizard.ConnectionInfo conInfo;
    private Form                            logForm;
    private Displayable                     beforeLogScreen;
    
    /** Creates a new instance of BTLogger */
    public BTLogger(MIDlet midletContext) {
        this.midletContext = midletContext;
        logForm = new Form("BT Log");
        logForm.addCommand(BT_LOG_BACK);
        logForm.setCommandListener(this);
    }

    public void addCommands( Displayable screen) {
        screen.addCommand(BT_RESET);
        screen.addCommand(BT_CONNECT);
        screen.addCommand(BT_STATUS);
        screen.addCommand(BT_VIEW_LOG);
    }

    public void removeCommands( Displayable screen) {
        screen.removeCommand(BT_RESET);
        screen.removeCommand(BT_CONNECT);
        screen.removeCommand(BT_STATUS);
        screen.addCommand(BT_VIEW_LOG);
    }
        
    public boolean handleCommand( Command command, boolean isLoggerActive) {
        boolean wasHandled = false;
        
        if (command == BT_RESET) {
            if (isLoggerActive) {
                ConnectionWizard.resetURL();
                Alert alert = new Alert("BT status", "Connection reset.", null, AlertType.INFO);
                alert.setTimeout(700);
                getDisplay().setCurrent(alert, getDisplay().getCurrent());
            } else {
                alertLoggerNotActive();
            }
            wasHandled = true;
        } else if (command == BT_CONNECT) {
            if (isLoggerActive) {
                connect();                
            } else {
                alertLoggerNotActive();
            }
            wasHandled = true;
        } else if (command == BT_STATUS) {
            if ( isLoggerActive) {
                Alert alert = null;
                try {
                    log("BT ping\n");
                    if (conInfo != null) {
                        alert = new Alert("BT status", "Connected to " + conInfo.toString(), null, AlertType.INFO);
                    }
                } catch(Exception e) {
                    alert = new Alert("BT status", "Not connected - " + toString(e), null, AlertType.WARNING);                
                }

                if (alert == null) {
                    alert = new Alert("BT status", "Not connected", null, AlertType.WARNING);                
                }
                alert.setTimeout(Alert.FOREVER);
                getDisplay().setCurrent(alert, getDisplay().getCurrent());
            } else {
                alertLoggerNotActive();
            }
            wasHandled = true;
        } else if (command == BT_VIEW_LOG) {
            beforeLogScreen = getDisplay().getCurrent();
            getDisplay().setCurrent( logForm);
        }
        return wasHandled;
    }
    
    public synchronized void log(String msg) {
        if (btOut == null) {
            if ( !quickConnect()) {
                throw new BTLoggerException("No connection available.");
            }            
        }
        try {
            sendMessage(msg);
        } catch (Exception e) {
            throw new BTLoggerException("Could not write data - " + toString(e));
        }
    }

    private boolean quickConnect() throws BTLoggerException {
        btLog("Retrieving stored connection ...");
        try {
            conInfo = ConnectionWizard.retrieveConnection();
        } catch (Exception ex) {
            btError("Read from RMS failed", ex);
            conInfo = null;
        }
        if (conInfo != null) {
            try {
                btLog("Using stored connection ...");
                createConnection(conInfo.url);
                return true;
            } catch (Exception e) {
                btError( "Could not establish connection", e);
                throw new BTLoggerException("Could not establish connection to " + conInfo.url);
            }
        } else {
            btLog("No connection found.");
        }
        return false;
    }
    
    public synchronized void connect() {
        if ( btOut == null) {
            try {
                // try the quick connect first
                if (quickConnect()) {
                    return;
                }
            } catch( Exception e) {}
            
            previousScreen = getDisplay().getCurrent();
            ConnectionWizard selector = new ConnectionWizard(midletContext, this, logForm);
            selector.startSelection();
        }
    }

    private static final String toString(Exception e) {
        if (e != null) {
            return e.getClass().getName() + "(" + e.getMessage() + ")";
        } else {
            return "null";
        }
    }
    
    public void connectionSelected(final ConnectionWizard.ConnectionInfo ci, String msg) {
        Alert alert;
        if (ci != null) {
            conInfo = ci;
            try {
                btLog("Using selected connection ...");                
                createConnection(conInfo.url);
                alert = new Alert("BT Logger", msg, null, AlertType.INFO);
            } catch (Exception e) {
                alert = new Alert("BT Logger", "Could not connect to " + ci.toString() + "-" + toString(e), null, AlertType.ERROR);
            }
        } else {
            alert = new Alert("BT Logger", msg, null, AlertType.ERROR);
        }
        alert.setTimeout(Alert.FOREVER);
        getDisplay().setCurrent( alert, previousScreen);
    }  
    
    private Display getDisplay() {
        return Display.getDisplay(midletContext);
    }

    private void alertLoggerNotActive() {
        Alert alert = new Alert("BT status", "Bluetooth logger not active.", null, AlertType.WARNING);
        alert.setTimeout(Alert.FOREVER);
        getDisplay().setCurrent(alert, getDisplay().getCurrent());
    }
    
    private void btLog(String msg) {
        logForm.append(msg + "\n");
    }
    
    private void btError(String msg, Exception e) {
        logForm.append( msg + " - " + e.getClass().getName() + "[" + e.getMessage() + "]\n");
        
    }
    StreamConnection _con;
    
    /**
     * Create new connection and write a few bytes to verify it is alive.
     */
    private void createConnection(String url) throws Exception {
        btLog("Getting device info ...");
        LocalDevice device = BluetoothManager.instance().getLocalDevice();
        String name, address;
        try {
            name = device.getFriendlyName();
        } catch( Exception e) {
            name = null;
        }
        
        btLog("Name: " + name);
        
        try {
            address = device.getBluetoothAddress();
        } catch( Exception e) {
            address = null;
        }
        btLog("Address: " + address);

        final String descr = BluetoothManager.getDescription(name, address);
        
        btLog("Connecting to: " + url);
        _con = (StreamConnection) Connector.open(url, Connector.WRITE, false);
        btLog("Connection opened.");
        btOut  = _con.openOutputStream();
        btLog("Output stream opened.");
        
        /*final InputStream btIn = con.openInputStream();
        btLog("Input stream opened.");

        Thread th = new Thread( new Runnable() {
            public void run() {
                byte[] readBuffer = new byte[30];
                while(true) {
                    try {
                        // only do read if some bytes available
                        int numBytes = btIn.available();
                        if (numBytes > 0) {
                            btIn.read(readBuffer);
                            // do something with readBuffer
                        } else {
                            Thread.sleep(100);
                        }
                    } catch (Exception e) {
                        // handle it
                    }
                }
            }            
        });
        th.start();
*/
        Thread.sleep(100);
        btLog("Sending initial message.");
        
        //writeTestPattern();
        sendMessage("Log attached from " + descr);
        //sendMessage("Log attached.\n");
        
        /*
        th = new Thread( new Runnable() {
           public void run() {
                try {
                    sendMessage("Log attached from " + descr + "\n");
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
           } 
        });        
        th.start();
         */
    }
    
    private void writeTestPattern() {
        int i = 0;
        while(true) {
            try {
                btOut.write('a');
                i++;
                if ((i % 20) == 0) {
                    btOut.flush();
                }
            } catch (IOException ex) {
                ex.printStackTrace();
                btLog(i + " bytes sent.");
            }
        }
    }
    
    private synchronized void sendMessage(final String msg) throws Exception {
        btLog("> sendMessage(" + msg + ")");
        if (msg != null) {
            int len = msg.length();
            for (int i = 0; i < len; i++) {
                //TODO Handle non ASCII characters
                //btOut.write( msg.charAt(i));
                writeByte(msg.charAt(i));
            }
            //btOut.write('\n');
            writeByte('\n');
            //btOut.write(0);
            writeByte(0);
            btOut.flush();
        }
        btLog("< sendMessage()");               
    }

    private void writeByte(int b) throws Exception {
        int trialNum = 3;
        do {
            try {
                btOut.write(b);
                return;
            } catch (IOException ex) {
                if (trialNum-- == 0) {
                    throw ex;
                } else {
                    Thread.sleep(100);
                }
            }
        } while(true);
    }
    
    public void commandAction(Command command, Displayable displayable) {
        if (command == BT_LOG_BACK && beforeLogScreen != null) {
            getDisplay().setCurrent(beforeLogScreen);
            beforeLogScreen = null;            
        }
    }
}
