/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

/*
 * Logger.java
 *
 * Created on January 19, 2007, 9:59 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.testme;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import org.netbeans.microedition.testme.rms.RMSLogger;
//#ifdef JSR82    
import org.netbeans.microedition.testme.bt.BTLogger;
//#endif

/**
 *
 * @author breh
 */
public class Logger {
    public static final int INFO    = 1;
    public static final int WARNING = 2;
    public static final int ERROR   = 3;
    
    public static final int DO_NOT_LOG    =  0;
    public static final int LOG_TO_STDOUT =  1;
    public static final int LOG_TO_STDERR =  2;
    public static final int LOG_TO_MEMORY =  4;
    public static final int LOG_TO_RMS    =  8;
    public static final int LOG_TO_BT     = 16;
    
    public static final int LOG_TO_ALL    = LOG_TO_STDOUT | LOG_TO_STDERR |
                                            LOG_TO_MEMORY | LOG_TO_RMS | LOG_TO_BT;
    
    private final MIDlet midletContext;
    
    private Vector /*<LogEntry>*/ log = new Vector();
    
    private int logTo = LOG_TO_STDOUT | LOG_TO_MEMORY | LOG_TO_RMS;
    
    private RMSLogger rmsLogger = null;
   
    //#ifdef JSR82
     private final BTLogger  btLogger;
    //#endif
    
    /** Creates a new instance of Logger */
    public Logger(MIDlet midletContext) {
        this.midletContext = midletContext;
    //#ifdef JSR82
        this.btLogger      = new BTLogger(midletContext);
    //#endif
    }
    
    public synchronized void setLogTo(int logTo) {
        this.logTo = logTo;
    }
    
    public int getLogTo() {
        return logTo;
    }
    
    public void addCommands(Displayable screen) {
    //#ifdef JSR82
        btLogger.addCommands(screen);
    //#endif
    }
    
    public boolean handleCommand(Command cmd) {
    //#ifdef JSR82
        return btLogger.handleCommand(cmd, isBTLoggerActive(logTo));
    //#else
//#         return false;
    //#endif
    }
    
    /*
    public static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }*/
    

    public Enumeration getLogEntries() {
        return log.elements();
    }
    
    public LogEntry getLogEntry(int index) {
        if ((index < 0) || (index > log.size())) {
            return null;
        } else {
            return (LogEntry)log.elementAt(index);
        }
    }
    
    public void clearMemoryLog() {
        log.removeAllElements();
    }
    
    public void log(int priority, String message, Throwable t) {
        if (logTo != DO_NOT_LOG) {
            LogEntry entry = new LogEntry(message, t, priority);
            int logTo = getLogTo();
            if ( (logTo & LOG_TO_STDOUT) == LOG_TO_STDOUT) {
                System.out.println(entry.toString());
            } 
            if ( (logTo & LOG_TO_STDERR) == LOG_TO_STDERR) {
                System.err.println(entry.toString());
            } 
            if ( (logTo & LOG_TO_MEMORY) == LOG_TO_MEMORY) {
                log.addElement(entry);
            } 
            if ( (logTo & LOG_TO_RMS) == LOG_TO_RMS) {
                synchronized(this) {
                    if (rmsLogger == null) {
                        rmsLogger = new RMSLogger();
                    }
                    rmsLogger.log(entry.toString());
                    rmsLogger.flush();
                }
            }
//#ifdef JSR82
            if ( isBTLoggerActive(logTo)) {
                btLogger.log(entry.toString());
            }
//#endif    
        }
    }
    
    private static boolean isBTLoggerActive(int logDest) {
        return (logDest & LOG_TO_BT) == LOG_TO_BT;
    }
    
    public static class LogEntry {
        private int       priority;
        private long      timestamp;
        private String    message;
        private Throwable throwable;
        private String    strRep;
            
        public LogEntry(String message, Throwable t, int priority) {
            this.timestamp = System.currentTimeMillis();
            this.message = message;
            this.throwable = t;
            this.priority = priority;
        }

        public int getPriority() {
            return priority;
        }

        public long getTimestamp() {
            return timestamp;
        }

        public String getMessage() {
            return message;
        }

        public Throwable getThrowable() {
            return throwable;
        }
        
        public String getPriorityAsString() {
            switch (priority) {
                case INFO: return "INFO"; 
                case WARNING: return "WARNING";
                case ERROR: return "ERROR"; 
                default: return "Uknown priority: "+priority;
            }
        }
        
        public synchronized String toString() {
            if ( strRep == null) {
                strRep = new Date(timestamp).toString() + ":[" + getPriorityAsString() 
                        + "]:" + getMessage() + ((throwable == null) ? "" : ", Throwable="+throwable.getMessage());
            } 
            return strRep;
        }
    }
    
}
