/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 
package org.netbeans.microedition.testme.svg.tests;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m2g.ScalableGraphics;
import org.netbeans.microedition.testme.svg.support.SVGTestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGLocatableElement;

/**
 * The J2ME test suite for known issue related to the change of element attribute 
 * through SVG DOM. If the element is defined in the <defs> section on some devices 
 * than change ( via setTrait() method) is not propagated correctly to elements that
 * are using this element using xlink:href attribute.
 *
 * @author  PavelBenes
 * @version
 */
public class UseDefsTest extends SVGTestMIDlet {
    private static String TRAIT_HEIGHT = "height";
    
    public UseDefsTest() throws Exception {
        super("Use Defs change unit test(s)", 1, "useDefs.svg", true);
    }
    
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testSvgUseDefs(); break;
            default: break;
        }
    }    
    
    /**
     * This test that SVG DOM change of attribute of SVG element defined in <defs> section 
     * is correctly propagated (and rendered) to all elements that are using this
     * element definition. The simple SVG image contains three SVG rect elements. The
     * elements reference the fourth SVG rect defined in the SVG defs element. Only 
     * coordinates and fill color are overriden other atributes are used from the common
     * rectangle. From a midlet we change the height of the rectangle in SVG defs section.
     * The height of all referencing rectangles should change as well. Since the new height
     * is 0 all boxes should become invisible. On some devices the trait change is ignored
     * and boxes' size remain unchanged.
     */    
    protected void testSvgUseDefs() {
        //wait one second the give user chance to see the starting SVG image
        
        //after one second set the height of referenced SVG rect element to 0.
        new Timer().schedule( new TimerTask() {
            public void run() {
                try {
                    getSVGAnimator().invokeAndWait( new Runnable() {
                        public void run() {
                            // set height of box to 0, so that is should become invisible
                            // and the screen should be empty
                            Document doc = getSVGImage().getDocument();
                            SVGLocatableElement element = (SVGLocatableElement)doc.getElementById("rectDef");
                            log("Height before: " + element.getFloatTrait(TRAIT_HEIGHT));
                            element.setFloatTrait(TRAIT_HEIGHT, (float) 0.0);
                            log("Height after: " + element.getFloatTrait(TRAIT_HEIGHT));
                        }                    
                    });
                } catch (Exception ex) {
                    ex.printStackTrace();
                } 
            }
        }, 1000);
        
        // one more second later, check if the boxes are still visible on the screen
        new Timer().schedule( new TimerTask() {
            public void run() {
                log("Checking the screenshot.");
                asynchronousTestCompleted( SVGUtils.isImageEmpty(takeScreenshot()), "The boxes should not be visible");
            }
        }, 2000);
    }   
}

