/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * BTLogViewer.java
 *
 * Created on April 13, 2007, 4:01 PM
 */
package org.netbeans.microedition.testme.logviever;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

/**
 *
 * @author  PavelBenes
 */
public class BTLogViewer extends javax.swing.JFrame {

    private class PortReader implements Runnable {
        private final InputStream  m_in;
        private final SerialPort   serialPort;
        private final String       m_portName;
        Thread       readThread;
        StringBuffer m_readBuffer;
        int          m_bytesRead = 0;

        public PortReader(CommPortIdentifier portId) throws Exception {
            m_portName = portId.getName();
            serialPort = (SerialPort) portId.open("SimpleReadApp" + m_portName, 30000);
            m_in = serialPort.getInputStream();
            serialPort.setSerialPortParams(19200, SerialPort.DATABITS_8, 
                                           SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
            readThread = new Thread(this);
            readThread.start();
        }

        public void run() {
            StringBuffer sb = new StringBuffer();
            int c;

            try {
                while ( (c=m_in.read()) != -1) {
                    if ( c == 0) {
                        log(sb.toString());
                        status( " " + m_bytesRead + " bytes read from " + m_portName);
                        sb.setLength(0);
                    } else {
                        m_bytesRead++;
                        sb.append( (char) c);
                    }
                }
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
    
    /** Creates new form BTLogViewer */
    public BTLogViewer() {
        initComponents();
        for (Enumeration ports = CommPortIdentifier.getPortIdentifiers(); ports.hasMoreElements(); ) {
            final CommPortIdentifier port = (CommPortIdentifier) ports.nextElement();
            if ( port.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                Thread th = new Thread( new Runnable() {
                    public void run() {
                        try {
                            new PortReader(port);
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                th.setDaemon(false);
                th.start();
            }
        }
    }
    
    protected synchronized void log(String str) {
        m_logText.append(str);
        logText.setText(m_logText.toString());
        logText.repaint();
    }
    
    protected synchronized void resetLog() {
        m_logText.setLength(0);
        logText.setText("");
        logText.repaint();
        
    }
    
    protected synchronized void status(String msg) {
        statusLabel.setText(msg);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        statusPanel = new javax.swing.JPanel();
        statusLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        logText = new javax.swing.JTextArea();
        jToolBar1 = new javax.swing.JToolBar();
        clearLogButton = new javax.swing.JButton();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        itemClearLog = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        itemExit = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Bluetooth Log Viewer");
        statusPanel.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        statusLabel.setFont(new java.awt.Font("Dialog", 0, 10));
        statusLabel.setText("No activity on COM ports ...");

        org.jdesktop.layout.GroupLayout statusPanelLayout = new org.jdesktop.layout.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusPanelLayout.createSequentialGroup()
                .add(statusLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 396, Short.MAX_VALUE)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );

        logText.setColumns(20);
        logText.setEditable(false);
        logText.setRows(5);
        jScrollPane1.setViewportView(logText);

        clearLogButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/res/reset-icon.png")));
        clearLogButton.setBorder(null);
        clearLogButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearLog(evt);
            }
        });

        jToolBar1.add(clearLogButton);

        jMenu1.setText("File");
        itemClearLog.setText("Clear Log");
        itemClearLog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearLog(evt);
            }
        });

        jMenu1.add(itemClearLog);

        jMenu1.add(jSeparator1);

        itemExit.setText("Exit");
        itemExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitViewer(evt);
            }
        });

        jMenu1.add(itemExit);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jToolBar1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE)
            .add(statusPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(jToolBar1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 360, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statusPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitViewer(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitViewer
        System.exit(0);
    }//GEN-LAST:event_exitViewer

    private void clearLog(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearLog
        resetLog();
    }//GEN-LAST:event_clearLog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new BTLogViewer().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton clearLogButton;
    private javax.swing.JMenuItem itemClearLog;
    private javax.swing.JMenuItem itemExit;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JTextArea logText;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables
    private StringBuffer m_logText = new StringBuffer();
}

