/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.utils.HttpUtils;

/**
 *
 * @author Jan Horvath
 */
public class IssuezillaUpdater extends Thread {
    
    public static final int MAX_RETRY = 10;
    
    public static final int DELAY = 45000; // time in ms
    
    EntityManagerFactory emf = Persistence.createEntityManagerFactory("StrutsExceptionsPU");
    
    private HashMap<Integer, Integer> issues;
    
    private boolean run = true;
    
    /** Creates a new instance of IssuezillaUpdater */
    public IssuezillaUpdater() {
        issues = new HashMap();
    }
    
    public synchronized void addIssue(Integer id) {
        System.err.println("*** add:" + id);
        if (!issues.containsKey(id)) {
            issues.put(id, new Integer(0));
        }
    }
    
    public synchronized void removeIssue(Integer id) {
        if (issues.containsKey(id)) {
            issues.remove(id);
        }
    }
    
    public synchronized Collection getIssues() {
        return Collections.unmodifiableCollection(issues.keySet());
    }
    
    public synchronized void checkIssue(Integer id) {
        int count = issues.get(id).intValue();
        if (count > MAX_RETRY) {
            issues.remove(id);
        } else {
            count++;
            issues.put(id, new Integer(count));
        }
    }
    
    public void stopUpdating() {
        run = false;
    }
    
    public void run() {
        while (run) {
            Collection<Integer> col = getIssues();
            for(Integer id:col) {
                System.err.println("*** " + id);
                checkIssue(id);
                Exceptions issue = (Exceptions) getEntity(Exceptions.class, id);
                if ((issue.getIssuezillaid() == null ) ||(issue.getIssuezillaid().intValue() == 0)) {
                    Integer iz = HttpUtils.checkIssuezillaId(issue.getId());
                    if (iz != null) {
                        removeIssue(id);
                        issue.setIssuezillaid(iz);
                        merge(issue);
                    }
                }
            }
            try {
                Thread.sleep(DELAY);
            } catch (java.lang.InterruptedException e) {
            }
        }
    }
    
    public void merge(Object object) {
        EntityManager em = getEM();
        try {
            em.getTransaction().begin();
            em.merge(object);
            em.getTransaction().commit();
        } catch (Exception e) {
            java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,
                    "exception caught", e);
            em.getTransaction().rollback();
        } finally {
            em.close();
        }
    }
    
    private EntityManager getEM() {
        EntityManager em = emf.createEntityManager();
        return em;
    }
    
    protected Object getEntity(Class entity, Object key) {
        Object result = null;
        EntityManager em = getEM();
        try {
            result =  em.find(entity, key);
        } catch(Exception e) {
            Logger.getLogger(getClass().getName()).log(Level.SEVERE,"exception caught", e);
            throw new RuntimeException(e);
        } finally {
            em.close();
        }
        return result;
    }
}
