/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.changeparam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.modules.websvc.wsdl.config.api.Wsdl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/**
 *
 * @author Martin Grebac
 */
public final class WebservicesXmlChangeParamRefactoring {
    
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.changeparam");   // NOI18N

    /* stores collection of other refactorings to be invoked */
    ArrayList otherRefactors = new ArrayList();
    
    /** Stores resolved class - filled in preCheck */
    private JavaClass javaClass = null;
    /** Stores collection of potentialy affected modules by proposed change - value filled in preCheck*/
    private Collection emodules = null;
    
    public WebservicesXmlChangeParamRefactoring() { }
    
    public Problem preCheck(RefObject refObject) {
        Problem problem = null;
        if (refObject instanceof Method) {

            Method method = (Method)refObject;
            Resource res = method.getResource();
            FileObject fo = JavaModel.getFileObject(res);
            Collection wsmodules = Utility.getRelevantWSModules(fo);
            Iterator wsIter = wsmodules.iterator();
            String methodName = method.getName();
            ClassDefinition classDef = method.getDeclaringClass(); // get affected class
            
            if ((wsmodules != null) && (wsmodules.size() > 0)) { // there are web/ejb modules that can be affected by the change
                while (wsIter.hasNext()) {
                    WebServicesSupport ws = (WebServicesSupport)wsIter.next();
                    if (ws != null) {
                        FileObject webservicesXmlFO = ws.getWebservicesDD();
                        Webservices webservicesXmlDD = null;
                        try {
                            webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
                        } catch (IOException ioe) {
                            //ignore
                        }

                        if ((webservicesXmlDD != null) && (webservicesXmlDD.getStatus()!=Webservices.STATE_INVALID_UNPARSABLE)) {
                            WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                            err.log("Web Services: " + wservices);
                            if ((wservices != null) && (wservices.length > 0)) {
                                for (int w=0; w < wservices.length; w++) {
                                    WebserviceDescription webService = (WebserviceDescription)wservices[w];
                                    err.log("Web Service: " + webService);
                                    
                                    Project project = FileOwnerQuery.getOwner(webservicesXmlFO);
                                    if (isFromWSDL(ws, wservices[w].getWebserviceDescriptionName())) {
                                        String jaxRpcMappingFileStr = webService.getJaxrpcMappingFile();
                                        WebModule wmd = WebModule.getWebModule(project.getProjectDirectory());
                                        EjbJar ejbJar = EjbJar.getEjbJar(project.getProjectDirectory());
                                        
                                        FileObject jaxRpcMappingFile = null;
                                        if (wmd != null) {
                                            jaxRpcMappingFile = wmd.getDocumentBase().getFileObject(jaxRpcMappingFileStr);
                                        } else if (ejbJar != null) {
                                            // TODO: searching should be probably enhanced
                                            jaxRpcMappingFileStr = jaxRpcMappingFileStr.substring(jaxRpcMappingFileStr.lastIndexOf("/"));
                                            jaxRpcMappingFile = ejbJar.getMetaInf().getFileObject(jaxRpcMappingFileStr);
                                        }
                                        if (jaxRpcMappingFile != null) {
                                            String serviceEndpointInterface = getServiceEndpointInterface(jaxRpcMappingFile);
                                            JavaClass serviceEndpointInterfaceClass = JMIUtils.findClass(serviceEndpointInterface);
                                            if ((serviceEndpointInterface != null) && (classDef.isSubTypeOf(serviceEndpointInterfaceClass))) {
                                                String msg = NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebSvcFromWSDLWarningChangeParam");
                                                Problem newProblem = new Problem(true, msg);
                                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                                return problem;
                                            }
                                        }
                                    }
                                            
                                    PortComponent[] ports = webService.getPortComponent();
                                    err.log("Ports: " + ports);
                                    if ((ports != null) && (ports.length > 0)) {
                                        for (int p=0; p < ports.length; p++) {
                                            
                                            /* First check for presence in webservices.xml port */
                                            PortComponent portComponent = (PortComponent)ports[p];
                                            err.log("Port Component: " + portComponent);
                                            
                                            /* try to locate the local wscompile config file:
                                             *   get project for webservices.xml, get name of the webservice and try to find properties of the type 
                                             *   $propertyname-config.name - if found, get the property valu and the path and locate the descriptor, 
                                             *   then get the dd api descriptor object
                                             */
                                            String portName = portComponent.getPortComponentName();
                                            Map properties = ws.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                                            String propertyName = portName + WebServicesConstants.CONFIG_PROP_SUFFIX;
                                            String propertyValue = (String)properties.get(propertyName);
                                            
                                            if (propertyValue != null) { // there's such property in the project
                                                FileObject wsConfigXmlFO = null;
                                                
                                                File f = new File(propertyValue);
                                                if (f.isAbsolute()) {
                                                    wsConfigXmlFO = FileUtil.toFileObject(f);        
                                                } else {
                                                    wsConfigXmlFO = project.getProjectDirectory().getFileObject(propertyValue);
                                                }
                                                if (wsConfigXmlFO != null) {
                                                    Configuration wsConfigXmlDD = null;
                                                    try {
                                                        wsConfigXmlDD = org.netbeans.modules.websvc.wsdl.config.api.DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                                                    } catch (IOException ioe) {
                                                        //ignore
                                                    }
                                                    if (wsConfigXmlDD != null) {
                                                        org.netbeans.modules.websvc.wsdl.config.api.Service service = wsConfigXmlDD.getService();
                                                        if (service != null) {
                                                            org.netbeans.modules.websvc.wsdl.config.api.Interface[] interfaces = service.getInterface();
                                                            if ((interfaces != null) && (interfaces.length > 0)) {
                                                                for (int ii=0; ii < interfaces.length; ii++) {
                                                                    org.netbeans.modules.websvc.wsdl.config.api.Interface iface = interfaces[ii];
                                                                    String servant = iface.getServantName();
                                                                    String iname = iface.getName();

                                                                    if (classDef.getName().equals(iname)) { 

                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(servant);
                                                                        Method beanMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            beanMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("beanmethod: " + beanMethod);
                                                                        }
                                                                        
                                                                        if (!isFromWSDL(ws, service.getName())) {
                                                                            ChangeParametersRefactoring changeParamBeanMethod = new ChangeParametersRefactoring(beanMethod);
                                                                            Problem prob = changeParamBeanMethod.preCheck();
                                                                            problem = Utility.addProblemsToEnd(problem, prob);
                                                                            otherRefactors.add(changeParamBeanMethod);
                                                                        } else {
                                                                            String msg = NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebSvcFromWSDLWarningChangeParam");
                                                                            Problem newProblem = new Problem(true, msg);
                                                                            problem = Utility.addProblemsToEnd(problem, newProblem);
                                                                            return problem;
                                                                        }

                                                                    } else if (classDef.getName().equals(servant)) { 

                                                                        JavaClass jcl = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(iname);
                                                                        Method iMethod = null;
                                                                        if (!(jcl instanceof UnresolvedClass)) {
                                                                            iMethod = jcl.getMethod(methodName, Utility.getTypedParams(method.getParameters()), false); //NOI18N
                                                                            err.log("ifacemethod: " + iMethod);
                                                                        }

                                                                        if (!isFromWSDL(ws, service.getName())) {
                                                                            ChangeParametersRefactoring changeParamIfaceMethod = new ChangeParametersRefactoring(iMethod);
                                                                            Problem prob = changeParamIfaceMethod.preCheck();
                                                                            problem = Utility.addProblemsToEnd(problem, prob);
                                                                            String msg = NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebSvcBeanMethodWarningChangeParam");
                                                                            Problem newProblem = new Problem(false, msg);
                                                                            problem = Utility.addProblemsToEnd(problem, newProblem);
                                                                            otherRefactors.add(changeParamIfaceMethod);
                                                                        } else {
                                                                            String msg = NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebSvcFromWSDLWarningChangeParam");
                                                                            Problem newProblem = new Problem(true, msg);
                                                                            problem = Utility.addProblemsToEnd(problem, newProblem);
                                                                            return problem;
                                                                        }
                                                                    }

                                                                }
                                                            }
                                                        } else {
                                                            // check if the method is in this interface
                                                            String sei = portComponent.getServiceEndpointInterface();
                                                            JavaClass seiClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(sei);
                                                            JavaClass jc = (JavaClass)method.getDeclaringClass();

                                                            if (jc.equals(seiClass)) {
                                                                Wsdl wsdl = wsConfigXmlDD.getWsdl();
                                                                String msg = NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebSvcFromWSDLWarningChangeParam");
                                                                Problem newProblem = new Problem(true, msg);
                                                                problem = Utility.addProblemsToEnd(problem, newProblem);
                                                                return problem;
                                                            }
                                                        }
                                                    } else {
                                                        Object[] args = new Object [] {wsConfigXmlFO.getNameExt()};
                                                        String msg = MessageFormat.format(NbBundle.getMessage(WebservicesXmlChangeParamRefactoring.class, "TXT_WebservicesConfigXmlChangeParamInvalidProblem"), args);  //NOI18N
                                                        Problem newProblem = new Problem(false, msg);
                                                        problem = Utility.addProblemsToEnd(problem, newProblem);
                                                        return problem;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } //while
            }        
            
        }
        return problem;
    }

    public boolean isFromWSDL(WebServicesSupport ws, String serviceName) {
        Element data = ws.getAntProjectHelper().getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName(WebServicesConstants.WEB_SERVICES); //NOI18N
        Element webservices = null;
        Element wsNameNode = null;
        if(nodes.getLength() == 1){
            webservices = (Element)nodes.item(0);
            NodeList wsNodes = webservices.getElementsByTagName(WebServicesConstants.WEB_SERVICE); //NOI18N
            for(int j = 0; j < wsNodes.getLength(); j++) {
                Element wsNode = (Element)wsNodes.item(j);
                NodeList wsNameNodes = wsNode.getElementsByTagName(WebServicesConstants.WEB_SERVICE_NAME); //NOI18N
                if(wsNameNodes.getLength() == 1) {
                    wsNameNode = (Element)wsNameNodes.item(0);
                    NodeList nl = wsNameNode.getChildNodes();
                    if(nl.getLength() == 1) {
                        Node n = nl.item(0);
                        if(n.getNodeType() == Node.TEXT_NODE) {
                            if(serviceName.equals(n.getNodeValue())) {
                                NodeList fromWSDLNodes = wsNode.getElementsByTagName(WebServicesConstants.WEB_SERVICE_FROM_WSDL); //NOI18N
                                if(fromWSDLNodes.getLength() == 1) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private String getServiceEndpointInterface(FileObject fo) {
        javax.xml.parsers.SAXParserFactory fact = javax.xml.parsers.SAXParserFactory.newInstance();
        fact.setValidating(false);
        ServiceHandler sh = new ServiceHandler();
        try {
            javax.xml.parsers.SAXParser parser = fact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(sh);
            FileInputStream is = new FileInputStream(FileUtil.toFile(fo));
            try {
                if (is != null) {
                    reader.parse(new InputSource(is));
                }
            } catch (SAXException ex) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
            } catch (IOException ex) {
                ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
            } finally {
                try{
                    is.close();
                } catch (IOException ex) {
                    ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
                }
            }
        } catch (javax.xml.parsers.ParserConfigurationException ex) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
        } catch (SAXException ex) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
        } catch (FileNotFoundException ex) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, ex.getMessage());
        }
        if (sh != null) {
            return sh.getServiceName();
        }
        return null;
    }

    private class ServiceHandler extends org.xml.sax.helpers.DefaultHandler {
        
        private boolean inServiceInterfaceMapping = false;
        private boolean inServiceInterface = false;
        
        private String serviceName = null;
        
        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            if ("service-endpoint-interface-mapping".equals(rawName)) { //NOI18N
                inServiceInterfaceMapping = true;
            }
            if ("service-endpoint-interface".equals(rawName)) { //NOI18N
                inServiceInterface = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException{
            if (inServiceInterfaceMapping && inServiceInterface) {
                String text = (new String(ch, start, length)).trim();
                if (text != null && text.length() > 0) {
                    serviceName = text;
                    inServiceInterface = false;
                    inServiceInterfaceMapping = false;
                }
            }
        }
        
        public String getServiceName() {
            return serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }
    
    public Problem fastCheckParameters(RefObject refObject) {
        Problem problem = null;
//        if ((javaClass != null) && !(javaClass instanceof UnresolvedClass)) {
//            err.log("resolved class: " + javaClass);
//            
//       }
       return problem;
    }

    public Problem checkParameters(RefObject refObject) {
        return fastCheckParameters(refObject);
    }
    
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, ParameterInfo[] paramInfo, int modifier, RefactoringElementsBag refactoringElements) {
        RefactoringSession session = refactoringElements.getSession();
        Problem problem = null;
        
        if (refObject instanceof Method) {
        
            for (int i=0; i < otherRefactors.size(); i++) {
                ChangeParametersRefactoring chr = (ChangeParametersRefactoring)otherRefactors.get(i);
                chr.setModifiers(modifier);
                chr.setParameterInfo(paramInfo);
                Problem p = chr.prepare(session);
                problem = Utility.addProblemsToEnd(problem, p);
            }
        }
        
        return problem;
    }
    
    /** Checks if the parameters changed (name of parameter is not checked, as it's not reflected */
    private static boolean isChanged(Method method, ParameterInfo[] paramInfo) {
        if (paramInfo.length < method.getParameters().size()) { // parameter was removed
            return true;
        }
        if ((paramInfo != null) && (paramInfo.length > 0)) {
            for (int i=0; i<paramInfo.length; i++) {
                ParameterInfo pi = paramInfo[i];
                if ((pi.getDefaultValue() != null) ||
                    (pi.getOriginalIndex() != i) ||
                    (pi.getType() != null)
                   ) {
                    return true;
                }
            }
        }
        return false;
    }
    
    private static String[] getNewParameters(ParameterInfo[] paramInfo, String[] methodParams) {
        String[] newParams = new String[paramInfo.length];
        if ((paramInfo != null) && (paramInfo.length > 0)) {
            for (int i=0; i<paramInfo.length; i++) {
                ParameterInfo pi = paramInfo[i];
                Type newParamType = pi.getType();
                if (newParamType == null) {
                    newParams[i] = methodParams[pi.getOriginalIndex()];
                } else {
                    newParams[i] = newParamType.getName();
                }
            }
        }
        return newParams;
    }
}
