/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.w3c.dom.Element;

/**
 * Utility class for WSDL4J used in generation of client WSDL
 *
 * @author sgenipudi
 *
 */
public class

WSDL4JUtil {
    private static WSDL4JUtil mInstance = null;
    private static final String DIRSEP = "/";
    private static final String XSD_EXT = ".xsd";
    private static final String XSD_GEN_DELIM = "_";

    private WSDL4JUtil() {
    }

    public static WSDL4JUtil getInstance() {
        if (mInstance == null) {
            mInstance = new WSDL4JUtil();
        }
        return mInstance;
    }

    /**
     * Reads the wsdl file , searches for matching  schema using the input
     * schemaNamespace and returns the list of physical locations of the
     * schema file relative to either project source directory or build directory
     * depending on the schema is imported or inline.
     *
     * If the schema is imported the location will be relative to project source directory
     * else relative to build directory as schema will be serialized to build directory if the
     * schema is inline in WSDL.
     *
     * @param wsdlDef WSDL Definition
     * @param schemaNameSpace  Namespace of the schema
     * @param wsdlFileLocation  File location of the WSDL .This must be relative to project source directory
     * @param buildDir build directory
     * @param projectSourceDirectory project source directory.
     * @return List of  WSDL4JUtil.SchemaLocation
     */
    public

    Set<WSDL4JUtil.SchemaLocation> getSchemaLocations(Definition wsdlDef, 
                                                      String schemaNameSpace, 
                                                      File wsdlFileLocation, 
                                                      File buildDir, 
                                                      File projectSourceDirectory, 
                                                      Set<WSDL4JUtil.SchemaLocation> listOfSchLoc) {

        if (wsdlFileLocation == null || !wsdlFileLocation.exists()) {
            throw new RuntimeException(" WSDLFileLocation is invalid");
        }
        if (buildDir == null || !buildDir.exists()) {
            throw new RuntimeException(" Build directory is invalid");
        }
        if (schemaNameSpace == null) {
            return null;
        }
        String wsdlFileParentDirPath = wsdlFileLocation.getParent();
        if (wsdlFileParentDirPath == null) {
            throw new RuntimeException(" WSDLFileLocation is invalid");
        }
        Map wsdlNamespaceMap = wsdlDef.getNamespaces();

        wsdlFileParentDirPath = wsdlFileParentDirPath.replace('\\', '/');
        String projectSourceDirPath = 
            projectSourceDirectory.getAbsolutePath().replace('\\', '/');
        String buildDirPath = buildDir.getAbsolutePath().replace('\\', '/');


        int ind1 = wsdlFileParentDirPath.indexOf(projectSourceDirPath);
        if (ind1 == -1) {
            throw new RuntimeException("WSDL Location is not relative to Project source directory");
        }
        String prjRelativeWSDLFileDirPath = 
            wsdlFileParentDirPath.substring(ind1 + 
                                            projectSourceDirPath.length());

        if (listOfSchLoc == null) {
            listOfSchLoc = new HashSet<WSDL4JUtil.SchemaLocation>();
        }
        
        //If the Schema is Standard XSD Simple Types            
        if ( schemaNameSpace.equals("http://www.w3.org/2001/XMLSchema") ) {
            SchemaLocation   schLoc = 
                                    new SchemaLocation(null, null, null, 
                                                       false, schemaNameSpace);
            schLoc.setSimpleType(true);
            listOfSchLoc.add(schLoc);
            return listOfSchLoc;
                            
        }
        
        Types types = wsdlDef.getTypes();

        List<ExtensibilityElement> listOfExElems = 
            types.getExtensibilityElements();
        int inlineSchInd = 1;
        boolean bMatchingNSFound = false;
        for (ExtensibilityElement exElem: listOfExElems) {
            bMatchingNSFound = false;
            if (exElem instanceof javax.wsdl.extensions.schema.Schema) {
                Schema schm = (Schema)exElem;
                Map mapOfImports = schm.getImports();
                Element schmElem = schm.getElement();
                String schemaTNS = schmElem.getAttribute("targetNamespace");
                List listOfSchemaIncludes = schm.getIncludes();
                if (schemaTNS.equals(schemaNameSpace)) {
                    bMatchingNSFound = true;
                }
                SchemaLocation schLoc = null;
                if (mapOfImports.size() > 0) {
                    Iterator<Map.Entry> schImpItr = 
                        mapOfImports.entrySet().iterator();
                    while (schImpItr.hasNext()) {
                        Map.Entry schImpEntry = schImpItr.next();
                        List<SchemaImport> listOfSchImp = 
                            (List)schImpEntry.getValue();
                        for (SchemaImport schImp: listOfSchImp) {
                            // Check if the schemalocation is File and 
                            //   if it is relative 
                            //       then find out  the relative 
                            //        location from project source directory
                            // for  other type of schema location
                            // use the location as it is.
                            File schemaFile = null;
                            String schemaLocationURIString = 
                                schImp.getSchemaLocationURI();
                            String schemaNamepsaceURI = 
                                schImp.getNamespaceURI();
                            String relativeLocation = null;
                            if (prjRelativeWSDLFileDirPath.equals("")) {
                                relativeLocation = schemaLocationURIString;
                            } else {
                                relativeLocation = prjRelativeWSDLFileDirPath + 
                                    DIRSEP + 
                                    schemaLocationURIString.replace('\\','/' );

                            }
                            if (bMatchingNSFound || 
                                (!bMatchingNSFound && schemaNamepsaceURI != 
                                 null && 
                                 schemaNamepsaceURI.equals(schemaNameSpace))) {
                                bMatchingNSFound = true;
                                try {
                                    schemaFile = 
                                            new File(wsdlFileParentDirPath, 
                                                     schemaLocationURIString);
                                    if (schemaFile.exists()) {
                                        schLoc = 
                                                new SchemaLocation(schemaLocationURIString, 
                                                                   schemaFile, 
                                                                   relativeLocation,
                                                                   true, 
                                                                   schemaNamepsaceURI);

                                    } else {
                                        schemaFile = 
                                                new File(schemaLocationURIString);
                                        if (schemaFile.exists()) {
                                            schLoc = 
                                                    new SchemaLocation(schemaLocationURIString, 
                                                                       schemaFile, 
                                                                       null, 
                                                                       false, 
                                                                       schemaNamepsaceURI);
                                        }
                                    }
                                    listOfSchLoc.add(schLoc);
                                } catch (Exception ex) {
                                    schLoc = 
                                            new SchemaLocation(schemaLocationURIString, 
                                                               null, null, 
                                                               false, 
                                                               schemaNamepsaceURI);
                                    listOfSchLoc.add(schLoc);
                                }
                            }

                        }

                    }
                } else {
                    //Inline schema  - Generate Schema.
                    if (bMatchingNSFound) {
                        String genSchemaFilePath = 
                            buildDir.getAbsolutePath() + DIRSEP + 
                            prjRelativeWSDLFileDirPath;
                        String xsdFileName = 
                            wsdlFileLocation.getName().replace('.', '_') + 
                            XSD_GEN_DELIM + inlineSchInd + XSD_EXT;
                        genSchemaFilePath = 
                                genSchemaFilePath.replace('\\', '/') + DIRSEP + 
                                xsdFileName;
                        //Add missing namespace defenition to schema
                        //as inline schema is saved as seperate file.
                        addWSDLNamespacesToXMLElement(schmElem, 
                                                      wsdlNamespaceMap);
                        writeXML(genSchemaFilePath, schmElem);
                        File genSchemaFile = new File(genSchemaFilePath);
                        if (genSchemaFile.exists()) {
                            schLoc = 
                                    new SchemaLocation(null, genSchemaFile, prjRelativeWSDLFileDirPath + 
                                                       DIRSEP + xsdFileName, 
                                                       false, schemaTNS);
                            listOfSchLoc.add(schLoc);
                        } else {
                            throw new RuntimeException("Could not create " + 
                                                       genSchemaFilePath);
                        }
                        inlineSchInd++;
                    } else {
                        if ( schemaNameSpace.equals("http://www.w3.org/2001/XMLSchema")) {
                            schLoc = 
                                    new SchemaLocation(null, null, null, 
                                                       false, schemaNameSpace);
                            schLoc.setSimpleType(true);
                            listOfSchLoc.add(schLoc);
                            inlineSchInd++;
                        }
                    }

                }
            }


            //  exElem.
        }
        return listOfSchLoc;
    }
    
    public org.netbeans.modules.xml.schema.model.Schema getImportedSchema(WSDLModel wsdlModel, WSDL4JUtil.SchemaLocation schemaLoc ) {
       Collection<org.netbeans.modules.xml.schema.model.Schema> colSchema = wsdlModel.getDefinitions().getTypes().getSchemas();
        boolean bMatchingNSFound = false;
        String compareLocation = null;
        compareLocation = schemaLoc.getLocationURI();

        for (org.netbeans.modules.xml.schema.model.Schema exElem: colSchema) {
            bMatchingNSFound = false;
            org.netbeans.modules.xml.schema.model.Schema schm = (org.netbeans.modules.xml.schema.model.Schema)exElem;
            Collection<org.netbeans.modules.xml.schema.model.Import> mapOfImports = schm.getImports();
            SchemaLocation schLoc = null;
            if (mapOfImports.size() > 0) {
                Iterator<org.netbeans.modules.xml.schema.model.Import> schImpItr = 
                    mapOfImports.iterator();
                while (schImpItr.hasNext()) {
                    org.netbeans.modules.xml.schema.model.Import schImp = schImpItr.next();
                    String schemaLocationURIString = schImp.getSchemaLocation();
                    if ( compareLocation!= null && compareLocation.equals(schemaLocationURIString)) {
                        return schm;
                    }
                }
            }

        }
        return null;


    }


    private void addWSDLNamespacesToXMLElement(Element elem, 
                                               Map mapOfNamespaces) {
        //  NamedNodeMap nmMap = elem.getAttributes();
        Iterator<Map.Entry> nsMapEntryItr = 
            mapOfNamespaces.entrySet().iterator();
        elem.setAttribute("xmlns", "http://schemas.xmlsoap.org/wsdl/");
        while (nsMapEntryItr.hasNext()) {
            Map.Entry nsMapEntry = nsMapEntryItr.next();
            String mapPrefix = (String)nsMapEntry.getKey();
            if (mapPrefix.equals("")) {
                continue;
            }
            String mapNS = (String)nsMapEntry.getValue();
            if (!elem.hasAttribute("xmlns:" + mapPrefix)) {
                elem.setAttribute("xmlns:" + mapPrefix, mapNS);
            }
        }

    }

    public static void writeXML(String genFile, Element elem) {
        PrintWriter pw = null;
        try {
            // Use a Transformer for output
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(elem);
            pw = new PrintWriter(genFile, "UTF-8");
            StreamResult result = new StreamResult(pw);

            transformer.setOutputProperty(OutputKeys.METHOD, "xml"); // NOI18N
            transformer.setOutputProperty(OutputKeys.ENCODING, 
                                          "UTF-8"); // NOI18N
            transformer.setOutputProperty(OutputKeys.MEDIA_TYPE, 
                                          "text/xml"); // NOI18N
            transformer.setOutputProperty(OutputKeys.STANDALONE, 
                                          "yes"); // NOI18N

            // indent the output to make it more legible...
            //  transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");  // NOI18N
            //  transformer.setOutputProperty(OutputKeys.INDENT, "yes");  // NOI18N
            transformer.transform(source, result);
        } catch (Exception ex) {

        } finally {
            if (pw != null) {
                try {
                    pw.flush();
                } catch (Exception ex) {

                }

                try {
                    pw.close();
                } catch (Exception ex) {

                }
            }
        }


    }

    public class SchemaLocation {
        //Physical Location of the Schema File
        private File mPhysicalFileLocation = null;
        //Relative location of schema ( either to project or build dir) 
        private String mRelativeLocation = null;
        //If mRelativeLocation is relative to Project source directory
        private boolean mbRelativeToPrjSrcDir = true;
        //Locaton URI 
        private String mLocationURI = null;
        //Namespace URI
        private String mNamespaceURI = null;
        
        private boolean mbSimpleType = false;

        public SchemaLocation(String locationURI, File physicalFileLocation, 
                              String relativeLocation, 
                              boolean bRelativeToProject, 
                              String namespaceURI) {
            mLocationURI = locationURI;
            mPhysicalFileLocation = physicalFileLocation;
            mRelativeLocation = relativeLocation;
            mbRelativeToPrjSrcDir = bRelativeToProject;
            mNamespaceURI = namespaceURI;

        }

        public File getFileLocation() {
            return mPhysicalFileLocation;
        }

        public String getRelativeLocation() {
            return mRelativeLocation;
        }

        public String getLocationURI() {
            return mLocationURI;
        }

        public boolean isRelativeToProject() {
            return mbRelativeToPrjSrcDir;
        }

        public String getNamespaceURI() {
            return mNamespaceURI;
        }
        
        public boolean isSimpleType() {
            return mbSimpleType;
        }
        
        public void setSimpleType(boolean simpleType) {
            mbSimpleType = simpleType;
        }

        public int hashCode() {
            if (mNamespaceURI != null) {
                return mNamespaceURI.hashCode();
            }
            return 1;

        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaLocation)) {
                return false;
            }
            SchemaLocation compSchLoc = (SchemaLocation)obj;
            if (((mPhysicalFileLocation != null && 
                  compSchLoc.getFileLocation() != null && 
                  compSchLoc.getFileLocation().equals(mPhysicalFileLocation)) || 
                 (mPhysicalFileLocation == null && 
                  compSchLoc.getFileLocation() == null)) && 
                ((mRelativeLocation != null && 
                  compSchLoc.getRelativeLocation() != null && 
                  compSchLoc.getRelativeLocation().equals(mRelativeLocation)) || 
                 (mRelativeLocation == null && 
                  compSchLoc.getRelativeLocation() == null)) && 
                ((mNamespaceURI != null && 
                  compSchLoc.getNamespaceURI() != null && 
                  compSchLoc.getNamespaceURI().equals(mNamespaceURI)) || 
                 (mNamespaceURI == null && 
                  compSchLoc.getNamespaceURI() == null)) && 
                ((mLocationURI != null && 
                  compSchLoc.getLocationURI() != null && 
                  compSchLoc.getLocationURI().equals(mLocationURI)) || 
                 (mLocationURI == null && 
                  compSchLoc.getLocationURI() == null))) {
                return true;
            }
            return false;


        }


    }
}
