/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;

import com.sun.org.apache.xerces.internal.xs.*;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLMessage;
import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLOperation;
import org.netbeans.modules.workflow.project.anttasks.wsdl.WSDLPart;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.sun.jbi.workflow.model.ModelFactory;
import com.sun.jbi.workflow.model.Task;
import com.sun.jbi.workflow.model.Tasks;
import com.sun.org.apache.xerces.internal.xs.XSModel;

import org.openide.util.NbBundle;
import java.io.FileNotFoundException;

/**
 * 
 * This class is used to obtain the Task Model from workflow file and form relation between
 * PartnerLink+PartnerLinkType to TaskModel. This class is used by ServiceUnitManager to obtain the
 * taskmodel
 * 
 * @author sgenipudi
 */
public class Util {
    private static final Logger mLogger = Logger.getLogger(Util.class.getName());
    /**
     * XMLSchema Instance Namespace declaration
     */
    public static final String XMLSCHEMA_INSTANCE_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";

    /**
     * XMLNS Namespace declaration.
     */
    public static final String XMLNS_NAMESPACE_URI =
            "http://www.w3.org/2000/xmlns/";

    /**
     * XML Namespace declaration
     */
    public static final String XML_NAMESPACE_URI =
            "http://www.w3.org/XML/1998/namespace";

    /**
     * XForms namespace declaration.
     */
    public static final String XFORMS_NS = "http://www.w3.org/2002/xforms";

    /**
     * XLink namespace declaration.
     */
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";

    /**
     * XML Events namsepace declaration.
     */
    public static final String XMLEVENTS_NS = "http://www.w3.org/2001/xml-events";
    
    /**
     * Obeon xforms namespace declaration
     */
    public static final String XXFORMS = "http://orbeon.org/oxf/xml/xforms";

    /**
     * XForms prefix
     */
    public static final String xformsNSPrefix = "xforms:";

    /**
     * Xlink prefix
     */
    public static final String xlinkNSPrefix = "xlink:";

    /**
     * XMLSchema instance prefix *
     */
    public static final String xmlSchemaInstancePrefix = "xsi:";

    /**
     * XML Events prefix
     */
    public static final String xmleventsNSPrefix = "ev:";

    private static final String PROP_FILE = "resources/jbi_gen.properties";

    private static final String TASK_CLIENT_INTERFACE_SUFFIX = "TaskClient_Interface_Suffix";

    private static final String TASK_CLIENT_END_POINT_SUFFIX = "TaskClient_EndPoint_Suffix";

    private static final String TASK_CLIENT_END_POINT_PREFIX = "TaskClient_EndPoint_Prefix";
    
    public static final String TASK_SERVICE_NAME = "Task_ServiceName";
    
    private static Properties mProps;

    
    public Util() {
    }

    /**
     * Generate *TaskName*xform.xhtml based on the workflowFile in projectSourceDir
     * 
     * @param workFlowFile
     * @param buildDir
     * @param projectSourceDir
     * @throws Exception
     */
    public static boolean generateXForm(File workFlowFile, File buildDir, File projectSourceDir,
            boolean always) throws Exception {
        try {
            Tasks tasks = null;
            try {
                tasks = ModelFactory.getInstance().getTasksModel(workFlowFile.getAbsolutePath());
            } catch (Exception me) {
                mLogger.severe("Error creating WorkFlowModel " + workFlowFile.getAbsolutePath()
                        + " Reason " + me.toString());
                throw me;
            }
            List<com.sun.jbi.workflow.model.WSDLDefinition> listOfWSDLDefs = null;
            try {
                listOfWSDLDefs = tasks.getImportWSDLs();
            } catch (Exception ex) {
                throw new RuntimeException(
                        "Error encountered while retrieving the imported WSDL in workfile "
                                + workFlowFile.getAbsolutePath());
            }
            HashMap mapOfTNSToWsdlDef = new HashMap();
            for (com.sun.jbi.workflow.model.WSDLDefinition impWsdls : listOfWSDLDefs) {
                String wsdlTNS = impWsdls.getTargetNamespace();
                mapOfTNSToWsdlDef.put(impWsdls.getTargetNamespace(), impWsdls);
            }

            Task task = (Task) tasks.getTasks().get(0);
            String taskName = task.getName();
            File xhtml = new File(projectSourceDir, taskName + "Xform.xhtml");
            if (xhtml.exists() && !always) {
                return false;
            }

            javax.wsdl.PortType taskPT = null;
            javax.wsdl.Operation taskOpn = null;
            try {
                if (task == null) {
                    System.out.println(" task is null");
                }
                if (task.getWSDLOperation() == null) {
                    System.out.println("WSDL opn is null");
                }

                taskOpn = task.getWSDLOperation();
                taskPT = task.getPortType();
            } catch (Exception ex) {
                throw new RuntimeException(
                        "Error encountered while retreiving WSDL operation  in workfile "
                                + workFlowFile.getAbsolutePath());
            }

            Input taskOpnInp = taskOpn.getInput();
            javax.wsdl.Output taskOpnOut = taskOpn.getOutput();
            // Get the input message
            Message taskOpnInMsg = taskOpnInp.getMessage();

            Message taskOpnOutMsg = taskOpnOut.getMessage();
            // Get the WSDLDefenition for the input message
            com.sun.jbi.workflow.model.WSDLDefinition wsdlDef = (com.sun.jbi.workflow.model.WSDLDefinition) mapOfTNSToWsdlDef
                    .get(taskOpnInMsg.getQName().getNamespaceURI());

            File WSDLFileFromURI = null;
            try {
                URI wsdlURI = new URI(wsdlDef.getDocumentBaseURI());
                WSDLFileFromURI = new File(wsdlURI);
            } catch (Exception e1) {
                throw new RuntimeException("Invalid  WSDL Location " + wsdlDef.getDocumentBaseURI());
            }

            SchemaUnit schemaUnitIn = getSchemaUnit(wsdlDef, taskOpnInMsg, WSDLFileFromURI,
                    buildDir, projectSourceDir);
             SchemaUnit schemaUnitOut = getSchemaUnit(wsdlDef, taskOpnOutMsg, WSDLFileFromURI,
                    buildDir, projectSourceDir);
 
            return writeXform(schemaUnitIn.getSchemaFile(), schemaUnitIn.getElementName(),
                    schemaUnitOut.getSchemaFile(), schemaUnitOut.getElementName(),
                    projectSourceDir, xhtml, taskName);
        } catch (Exception e) {
            mLogger.log(Level.SEVERE, "Error in creating Xform", e);
            throw e;

        }

    }

    private static boolean writeXform(File inSchemaFile, QName inElementName, File outSchemaFile,
            QName outElementName, File projectSourceDir, File xhtml, String taskName)
            throws Exception {
        // create input, output xml instance
    try {	
    
        XmlOptions compileOptions = new XmlOptions();
        compileOptions.setCompileDownloadUrls();
        XmlObject[] schemas;
        URL[] urls;

        ArrayList errorList = new ArrayList();
        compileOptions.setErrorListener(errorList);
        SchemaTypeSystem sts = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        try {
            if (inSchemaFile.getAbsolutePath().equals(outSchemaFile.getAbsolutePath())) {
                urls = new URL[1];
                urls[0] = inSchemaFile.getParentFile().toURL();
             } else {
                urls = new URL[2];
                urls[0] = inSchemaFile.getParentFile().toURL();
                urls[1] = outSchemaFile.getParentFile().toURL();
            }            
            URLClassLoader cl = new URLClassLoader(urls, oldCl);
            thread.setContextClassLoader(cl);
            if (inSchemaFile.getAbsolutePath().equals(outSchemaFile.getAbsolutePath())) {
                schemas = new XmlObject[1];
                schemas[0] = SchemaDocument.Factory.parse(inSchemaFile, (new XmlOptions())
                        .setLoadLineNumbers().setLoadMessageDigest());
            } else {
                schemas = new XmlObject[2];
                schemas[0] = SchemaDocument.Factory.parse(inSchemaFile, (new XmlOptions())
                        .setLoadLineNumbers().setLoadMessageDigest());
                schemas[1] = XmlObject.Factory.parse(outSchemaFile, (new XmlOptions())
                        .setLoadLineNumbers().setLoadMessageDigest());
            } 
            try {
                sts = XmlBeans.compileXsd(schemas, XmlBeans.getBuiltinTypeSystem(), compileOptions);
            } catch (XmlException e) {
                // TODO Auto-generated catch block
                for (int i = 0; i < errorList.size(); i++) {
                    XmlError error = (XmlError) errorList.get(i);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("\n");
                    buffer.append("Message: " + error.getMessage() + "\n");
                    buffer.append("Location of invalid XML: " + error.getCursorLocation().xmlText()
                            + "\n");
                    throw new RuntimeException(buffer.toString(), e);
                }
                throw e;
            }

        } catch (Exception e) {
            throw e;
        } finally {
            thread.setContextClassLoader(oldCl);
        }

        SchemaType[] globalElems = sts.documentTypes();
        SchemaType inElem = null;
        SchemaType outElem = null;
        for (int i = 0; i < globalElems.length; i++) {
            if (inElementName.equals(globalElems[i].getDocumentElementName())) {
                inElem = globalElems[i];
            }
            if (outElementName.equals(globalElems[i].getDocumentElementName())) {
                outElem = globalElems[i];
            }
            if (inElem != null && outElem != null) {
                break;
            }
        }
        if (inElem != null) {
            String xmlString = SampleXmlUtil.createSampleForType(inElem);
            writeFile(new File(xhtml.getParentFile(), taskName + "InputInstance.xml")
                    .getAbsolutePath(), xmlString, false);
        }
        if (outElem != null) {
            String xmlString = SampleXmlUtil.createSampleForType(outElem);
            writeFile(new File(xhtml.getParentFile(), taskName + "OutputInstance.xml")
                    .getAbsolutePath(), xmlString, false);
        }
        URL urlIn = inSchemaFile.toURL();
        URL urlOut = outSchemaFile.toURL();

        Map defaultValue = new HashMap();

        org.xml.sax.XMLReader reader = makeXMLReader();
        reader.setContentHandler(new Sink(defaultValue));

        File mappingFile = new File(projectSourceDir, "mappings.xml");
        if (mappingFile.exists()) {
        	FileReader fileReader = new FileReader(mappingFile);
        	if (mappingFile.exists()) {
        		reader.parse(new org.xml.sax.InputSource(fileReader));
        		fileReader.close();
        	}
        }

        BaseSchemaFormBuilder builderIn = new BaseSchemaFormBuilder(inElementName.getLocalPart());
        BaseSchemaFormBuilder builderOut = new BaseSchemaFormBuilder(outElementName.getLocalPart(),
                true, defaultValue);
        Document formIn = builderIn.buildForm(urlIn.getPath());
        Document formOut = builderOut.buildForm(urlOut.getPath());

        InputStream urlInXSLT = Util.class.getResourceAsStream("resources/inputtransform.xsl");
        InputStream urlOutXSLT = Util.class.getResourceAsStream("resources/outputtransform.xsl");

        Node intransformed = XmlUtil.transformToDoc(new DOMSource(formIn), new StreamSource(
                urlInXSLT));
        Node outtransformed = XmlUtil.transformToDoc(new DOMSource(formOut), new StreamSource(
                urlOutXSLT));

        Element root = ((Document) intransformed).createElementNS("http://www.w3.org/1999/xhtml", "xhtml:html");
        root.setAttributeNS(XMLNS_NAMESPACE_URI,
                "xmlns:xforms",
                XFORMS_NS);
        root.setAttributeNS(XMLNS_NAMESPACE_URI,
                "xmlns:xf",
                XFORMS_NS);        
        root.setAttributeNS(XMLNS_NAMESPACE_URI,
                "xmlns:xlink",
                XLINK_NS);
        root.setAttributeNS(XMLNS_NAMESPACE_URI,
                "xmlns:ev",
                XMLEVENTS_NS);
        root.setAttributeNS(XMLNS_NAMESPACE_URI,
                "xmlns:xxforms",
                XXFORMS);  
        
        Element head = ((Document) intransformed).createElementNS("http://www.w3.org/1999/xhtml", "xhtml:head");
        
        root.appendChild(head);
        Element style  = ((Document) intransformed).createElementNS("http://www.w3.org/1999/xhtml", "xhtml:style");
        style.appendChild(((Document) intransformed).createTextNode("body { background:#eee }"));
        head.appendChild(style);
        

        Element title  = ((Document) intransformed).createElementNS("http://www.w3.org/1999/xhtml", "xhtml:title");
        title.appendChild(((Document) intransformed).createTextNode("Task Details"));
        head.appendChild(title);
        
        
        Element body = ((Document) intransformed).createElementNS("http://www.w3.org/1999/xhtml", "xhtml:body");
        
        root.appendChild(body);
        
        body.appendChild(((Document) intransformed).getDocumentElement());
        body.appendChild(((Document) intransformed).importNode(((Document) outtransformed)
                .getDocumentElement(), true));

        String xmlString = XmlUtil.toXml(root, "UTF-8", true);

        writeFile(xhtml.getAbsolutePath(), xmlString, false);
    }catch (Exception e) {
    	throw e;
    }
    
        return true;

    }

    public static void addOperationInfo(File workFlowFile, ArrayList listOfOperations,
            WSDLModel clientWSDLModel, File buildDir, File projectSourceDir) {
        Tasks tasks = null;
        try {
            tasks = ModelFactory.getInstance().getTasksModel(workFlowFile.getAbsolutePath());
        } catch (Exception me) {
            mLogger.severe("Error creating WorkFlowModel " + workFlowFile.getAbsolutePath()
                    + " Reason " + me.toString());
            return;
        }
        String targetNameSpaceForWorkFile = tasks.getTargetNamespace();
        QName partnerLinkQName = null;
        QName portTypeQName = null;

        List<com.sun.jbi.workflow.model.WSDLDefinition> listOfWSDLDefs = null;
        try {
            listOfWSDLDefs = tasks.getImportWSDLs();
        } catch (Exception ex) {
            throw new RuntimeException(
                    "Error encountered while retrieving the imported WSDL in workfile "
                            + workFlowFile.getAbsolutePath());
        }
        HashMap mapOfTNSToWsdlDef = new HashMap();

        for (com.sun.jbi.workflow.model.WSDLDefinition impWsdls : listOfWSDLDefs) {
            String wsdlTNS = impWsdls.getTargetNamespace();
            mapOfTNSToWsdlDef.put(impWsdls.getTargetNamespace(), impWsdls);
        }
        Object taObj = null;
        for (int index = 0; index < tasks.getTasks().size(); index++) {
            try {
                taObj = tasks.getTasks().get(index);
            } catch (Exception ex) {

            }

            Task task = (Task) tasks.getTasks().get(index);
            javax.wsdl.PortType taskPT = null;
            javax.wsdl.Operation taskOpn = null;
            try {
                if (task == null) {
                    System.out.println(" task is null");
                }
                if (task.getWSDLOperation() == null) {
                    System.out.println("WSDL opn is null");
                }

                taskOpn = task.getWSDLOperation();
                taskPT = task.getPortType();
            } catch (Exception ex) {
                throw new RuntimeException(
                        "Error encountered while retreiving WSDL operation  in workfile "
                                + workFlowFile.getAbsolutePath());
            }

            // Populate WSDLOperation
            WSDLOperation wsdlOpn = new WSDLOperation();
            wsdlOpn.setOperationName(taskOpn.getName());
            wsdlOpn.setTaskName(task.getName());
            wsdlOpn.setPortTypeName(taskPT.getQName());
            listOfOperations.add(wsdlOpn);

            WSDLMessage wsdlInMsg = new WSDLMessage();
            WSDLMessage wsdlOutMsg = new WSDLMessage();
            wsdlOpn.setInputWSDLMessage(wsdlInMsg);
            wsdlOpn.setOutputWSDLMessage(wsdlOutMsg);

            // Process Input Message

            Input taskOpnInp = taskOpn.getInput();
            // Get the input message
            Message taskOpnInMsg = taskOpnInp.getMessage();

            // Get the WSDLDefenition for the input message
            com.sun.jbi.workflow.model.WSDLDefinition wsdlDef = (com.sun.jbi.workflow.model.WSDLDefinition) mapOfTNSToWsdlDef
                    .get(taskOpnInMsg.getQName().getNamespaceURI());
            // Get the physical locaton of the WSDL in file system.
            String wsdlPath = null;
            File WSDLFileFromURI = null;
            try {
                URI wsdlURI = new URI(wsdlDef.getDocumentBaseURI());
                WSDLFileFromURI = new File(wsdlURI);
                wsdlPath = WSDLFileFromURI.getAbsolutePath();
            } catch (Exception e1) {
                throw new RuntimeException("Invalid  WSDL Location " + wsdlDef.getDocumentBaseURI());
            }

            populateWSDLOperation(wsdlDef, wsdlInMsg, taskOpnInMsg, WSDLFileFromURI, buildDir,
                    projectSourceDir, clientWSDLModel);
            javax.wsdl.Output taskOpnOut = taskOpn.getOutput();
            // Get the output message
            Message taskOpnOutMsg = taskOpnOut.getMessage();
            populateWSDLOperation(wsdlDef, wsdlOutMsg, taskOpnOutMsg, WSDLFileFromURI, buildDir,
                    projectSourceDir, clientWSDLModel);
        }
    }

    /**
     * Get the schema unit related to the wsdl Message, returns the
     * 
     * @param wsdlDef
     * @param taskOpnInMsg
     * @param WSDLFileFromURI
     * @param buildDir
     * @param projectSourceDir
     * @return
     */

    public static SchemaUnit getSchemaUnit(com.sun.jbi.workflow.model.WSDLDefinition wsdlDef,
            Message taskOpnInMsg, File WSDLFileFromURI, File buildDir, File projectSourceDir) {
        // Get the list of parts defined in the message
        SchemaUnit result = null;
        List<Part> listOfParts = taskOpnInMsg.getOrderedParts(null);
        ArrayList listOfSchemaLocation = new ArrayList();
        Set<WSDL4JUtil.SchemaLocation> setOfSchemaLoc = null;//
        for (Part taskPart : listOfParts) {
            QName taskPartTypeType = taskPart.getTypeName();
            QName taskPartElementType = taskPart.getElementName(); // taskPart.getTypeName();
            setOfSchemaLoc = new HashSet();
            WSDL4JUtil wsdlUtil = WSDL4JUtil.getInstance();
            QName typeOrElementQName = (taskPartElementType != null) ? taskPartElementType
                    : taskPartTypeType;
            wsdlUtil.getSchemaLocations(wsdlDef, typeOrElementQName.getNamespaceURI(),
                    WSDLFileFromURI, buildDir, projectSourceDir, setOfSchemaLoc);
            Iterator<WSDL4JUtil.SchemaLocation> schmLocItr = setOfSchemaLoc.iterator();
            while  (schmLocItr.hasNext()) {
                WSDL4JUtil.SchemaLocation wsdlUtilSchLoc = schmLocItr.next();
                if (!wsdlUtilSchLoc.isSimpleType()) {
                    if (setOfSchemaLoc.size() == 1) {
                        result = new SchemaUnit(wsdlUtilSchLoc.getFileLocation(),
                                typeOrElementQName);
                        return result;
                    } else {
                        File schemaFile = wsdlUtilSchLoc.getFileLocation();
                        XSModel model = null;
                        try {
                            model = loadSchema(schemaFile.toURL().getPath());
                        } catch (MalformedURLException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (ClassNotFoundException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (InstantiationException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (IllegalAccessException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                        if (model != null) {
                            if (hasElement(model, typeOrElementQName)) {
                                result = new SchemaUnit(wsdlUtilSchLoc.getFileLocation(),
                                        typeOrElementQName);
                                return result;
                            }
                        }

                    }
                }
            }

        }
        return result;
    }

    private static void populateWSDLOperation(com.sun.jbi.workflow.model.WSDLDefinition wsdlDef,
            WSDLMessage wsdlInMsg, Message taskOpnInMsg, File WSDLFileFromURI, File buildDir,
            File projectSourceDir, WSDLModel clientWSDLModel) {

        // Get the list of parts defined in the message
        List<Part> listOfParts = taskOpnInMsg.getOrderedParts(null);
        ArrayList listOfSchemaLocation = new ArrayList();
        Set<WSDL4JUtil.SchemaLocation> setOfSchemaLoc = null;//
        // Iterate each part
        for (Part taskPart : listOfParts) {
            // Create WSDLPart for each part
            WSDLPart wsdlPart = new WSDLPart();
            wsdlPart.setPartName(taskPart.getName());
            wsdlInMsg.addPart(wsdlPart);
            // Get the type name ( QName)
            QName taskPartTypeType = taskPart.getTypeName();
            QName taskPartElementType = taskPart.getElementName(); // taskPart.getTypeName();
            setOfSchemaLoc = new HashSet();
            WSDL4JUtil wsdlUtil = WSDL4JUtil.getInstance();
            QName typeOrElementQName = (taskPartElementType != null) ? taskPartElementType
                    : taskPartTypeType;
            wsdlUtil.getSchemaLocations(wsdlDef, typeOrElementQName.getNamespaceURI(),
                    WSDLFileFromURI, buildDir, projectSourceDir, setOfSchemaLoc);

            Iterator<WSDL4JUtil.SchemaLocation> schmLocItr = setOfSchemaLoc.iterator();

            if (schmLocItr.hasNext()) {
                WSDL4JUtil.SchemaLocation wsdlUtilSchLoc = schmLocItr.next();
                if (wsdlUtilSchLoc.isSimpleType()) {
                    wsdlPart.setQueueName(taskPartTypeType);
                } else {
                    String relativeLocation = wsdlUtilSchLoc.getRelativeLocation();
                    String schLocURI = wsdlUtilSchLoc.getLocationURI();
                    String schemaLocation = null;
                    if (relativeLocation != null) {
                        // Relative Location
                        listOfSchemaLocation.add(relativeLocation);
                        schemaLocation = relativeLocation;
                    } else if (schLocURI != null) {
                        // All other location that are not relative.
                        listOfSchemaLocation.add(schLocURI);
                        schemaLocation = schLocURI;
                    }
                    Schema schema = null;
                    if ((schema = wsdlUtil.getImportedSchema(clientWSDLModel, wsdlUtilSchLoc)) == null) {
                        // Add schema to Client WSDL
                        Types wsdlTypes = clientWSDLModel.getDefinitions().getTypes();
                        WSDLSchema wsdlSchema = clientWSDLModel.getFactory().createWSDLSchema();
                        SchemaModel schemaModel = wsdlSchema.getSchemaModel();
                        schema = schemaModel.getSchema();
                        schema.setTargetNamespace(clientWSDLModel.getDefinitions()
                                .getTargetNamespace());
                        org.netbeans.modules.xml.schema.model.Import schemaImp = schemaModel
                                .getFactory().createImport();
                        schemaImp.setSchemaLocation(schemaLocation);
                        schemaImp.setNamespace(wsdlUtilSchLoc.getNamespaceURI());

                        schema.addExternalReference(schemaImp);
                        if (wsdlSchema != null) {
                            wsdlTypes.addExtensibilityElement(wsdlSchema);
                        }
                    }

                    if (wsdlUtilSchLoc.isSimpleType()) {
                        wsdlPart.setStandardXMLSchemaSimpleType(true);
                    } else if (wsdlUtilSchLoc.getFileLocation() != null) {
                        SchemaModel schModOfImportedSchema = SchemaManager.getInstance()
                                .getSchemaModel(wsdlUtilSchLoc.getFileLocation());
                        if (taskPartElementType != null) {
                            Collection<GlobalElement> globElementColl = schModOfImportedSchema
                                    .getSchema().getElements();
                            GlobalElement partElement = findSchemaElement(globElementColl,
                                    taskPartElementType);
                            wsdlPart.setElement(partElement);
                        } else {
                            Collection<GlobalSimpleType> gst = schModOfImportedSchema.getSchema()
                                    .getSimpleTypes();
                            GlobalType gt = findSimpleType(gst, taskPartTypeType);
                            if (gt != null) {
                                wsdlPart.setType(gt);
                            } else {
                                Collection<GlobalComplexType> gct = schModOfImportedSchema
                                        .getSchema().getComplexTypes();
                                gt = findComplexTypes(gct, taskPartTypeType);
                                if (gt != null) {
                                    wsdlPart.setType(gt);
                                }
                            }

                        }
                    }

                    wsdlPart.setSchema(schema);

                }
            }
        }
    }

    public static GlobalElement findSchemaElement(Collection<GlobalElement> globElementColl,
            QName taskPartType) {
        for (GlobalElement gelem : globElementColl) {
            if (taskPartType.getLocalPart().equals(gelem.getName())) {
                return gelem;
            }

        }
        return null;
    }

    /*
     * private static QName findMatchingQName(String namespace, Map<Attribute> mapOfAttrNames) {
     * Iterator<Map.Entry> attrEntryMapItr = mapOfAttrNames.entrySet().iterator(); while
     * (attrEntryMapItr.hasNext()) { Attribute attr = attrEntryMapItr.next(); attr. if (attr.get
     * .getLocalPart().equals(namespace)) { return tempQName; } } return null; }
     */

    private static GlobalType findSimpleType(Collection<GlobalSimpleType> colSimpTypes,
            QName schemaType) {
        Iterator<GlobalSimpleType> gstItr = colSimpTypes.iterator();
        while (gstItr.hasNext()) {
            GlobalSimpleType gst = gstItr.next();
            if (gst.getName().equals(schemaType.getLocalPart())) {
                return gst;
            }
        }
        return null;
    }

    private static GlobalType findComplexTypes(Collection<GlobalComplexType> colCmplxTypes,
            QName schemaType) {
        Iterator<GlobalComplexType> gstItr = colCmplxTypes.iterator();
        while (gstItr.hasNext()) {
            GlobalComplexType gst = gstItr.next();
            if (gst.getName().equals(schemaType.getLocalPart())) {
                return gst;
            }
        }
        return null;
    }

    private static class SchemaUnit {
        private File schemaFile;

        private QName elementName;

        public SchemaUnit(File schemaFile, QName elementName) {
            this.schemaFile = schemaFile;
            this.elementName = elementName;
        }

        public QName getElementName() {
            return elementName;
        }

        public void setElementName(QName elementName) {
            this.elementName = elementName;
        }

        public File getSchemaFile() {
            return schemaFile;
        }

        public void setSchemaFile(File schemaFile) {
            this.schemaFile = schemaFile;
        }

    }

    private static XSModel loadSchema(String inputURI) throws java.lang.ClassNotFoundException,
            java.lang.InstantiationException, java.lang.IllegalAccessException {

        XSModel schema = null;
        // Get DOM Implementation using DOM Registry
        System.setProperty(DOMImplementationRegistry.PROPERTY,
                "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        Object o = registry.getDOMImplementation("XS-Loader");
        if (o instanceof XSImplementation) {
            com.sun.org.apache.xerces.internal.xs.XSImplementation impl = (com.sun.org.apache.xerces.internal.xs.XSImplementation) o;
            com.sun.org.apache.xerces.internal.xs.XSLoader schemaLoader = impl.createXSLoader(null);
            schema = schemaLoader.loadURI(inputURI);
        }
        return schema;
    }

    public static boolean hasElement(XSModel schema, QName elementName) {
        if (schema.getElementDeclaration(elementName.getNamespaceURI(), elementName
                .getLocalPart()) != null)
        	return true;
        return (schema.getElementDeclaration( elementName
                .getLocalPart(), elementName.getNamespaceURI()) != null);
    }

    public static org.xml.sax.XMLReader makeXMLReader() throws Exception {
        final javax.xml.parsers.SAXParserFactory saxParserFactory = javax.xml.parsers.SAXParserFactory
                .newInstance();
        final javax.xml.parsers.SAXParser saxParser = saxParserFactory.newSAXParser();
        final org.xml.sax.XMLReader parser = saxParser.getXMLReader();
        return parser;
    }

    private static class Sink extends org.xml.sax.helpers.DefaultHandler implements
            org.xml.sax.ContentHandler {
        private Map mMap = null;

        public Sink(Map map) {
            super();
            mMap = map;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes)
                throws SAXException {
            // TODO Auto-generated method stub
            if (qName.equals("mp:mapping")) {
                String path = "";
                String value = "";
                for (int i = 0; i < attributes.getLength(); i++) {
                    String attName = attributes.getQName(i);
                    if (attName.equals("path")) {
                        path = attributes.getValue(i);
                    } else if (attName.equals("value")) {
                        value = attributes.getValue(i);
                    }
                }
                mMap.put(path, value);
            }
            super.startElement(uri, localName, qName, attributes);
        }
    }

    public static void writeFile(String filename, String output, boolean append) throws IOException {

        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
                filename, append), "UTF-8"));

        out.write(output);
        out.close();
    }

    public static void main(String[] args) {
        File workFlowFile = new File(
                "C:/Alaska/jbicomps/wlmweb/orbeon/sample/purchaseOrderReview/PurchaseOrderWorkflowApp/src/ApprovePurchase.wf");
        File buildDir = new File(
                "C:/Alaska/jbicomps/wlmweb/orbeon/sample/purchaseOrderReview/PurchaseOrderWorkflowApp/build");
        File projectSourceDir = new File(
                "C:/Alaska/jbicomps/wlmweb/orbeon/sample/purchaseOrderReview/PurchaseOrderWorkflowApp/src");
        try {
            generateXForm(workFlowFile, buildDir, projectSourceDir, true);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    
    private static void loadProps() {
        mProps = new Properties();
        URL propUrl = Util.class.getResource(PROP_FILE);
        InputStream inputStream = null;
        try {
            inputStream = Util.class.getResourceAsStream(PROP_FILE);
            mProps.load(inputStream);
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            throw new RuntimeException(NbBundle.getMessage(GenerateAsaArtifacts.class,
                    "EX_FILE_NOT_FOUND", propUrl.toString()), e);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            throw new RuntimeException(NbBundle.getMessage(GenerateAsaArtifacts.class,
                    "EX_IOException", propUrl.toString()), e);
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }

    }
    
    
    public static Properties getCommonProperties() {
    	if(mProps == null) {
    		loadProps();
    	}
    	
    	return mProps;
    }
    
    public static String getTaskSpecificClientPortTypeName(String taskName) {
    	Properties prop = getCommonProperties();
    	String portTypeName = taskName
        + mProps.getProperty(TASK_CLIENT_INTERFACE_SUFFIX);
    	
    	return portTypeName;
    }
    
    public static String getTaskSpecificClientEndpointName(String projectName) {
    	Properties prop = getCommonProperties();
    	
    	String endpointName = prop.getProperty(TASK_CLIENT_END_POINT_PREFIX) + projectName
        + mProps.getProperty(TASK_CLIENT_END_POINT_SUFFIX);
    	
    	return endpointName;
    }
    
    public static String getTaskSpecificClientServiceName() {
    	Properties prop = getCommonProperties();
    	String serviceName = prop.getProperty(TASK_SERVICE_NAME);
    	
    	return serviceName;
    }
    
}
