/*
 * TaskDefinitionPanel.java
 *
 * Created on May 24, 2007, 3:21 PM
 */

package org.netbeans.modules.worklist.editor.multiview.overview;

import javax.swing.JComponent;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.spi.OperationReference;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.view.WSDLOperationPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;


/**
 *
 * @author  radval
 */
public class TaskPanel extends SectionInnerPanel {
    
    private WorklistDataObject dObj;
    
    private TTask task;
    
    
     /** Creates new form AssignmentPanel */
    public TaskPanel(SectionView sectionView, WorklistDataObject dObj, TTask task) {
        super(sectionView);
        this.dObj=dObj;
        this.task = task;
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        partnerLinkTypeTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        partnerLinkTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        roleTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        operationTextField = new javax.swing.JTextField();
        showOperationDlgButton = new javax.swing.JButton();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.jLabel1.text")); // NOI18N

        nameTextField.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.nameTextField.text")); // NOI18N
        nameTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nameTextFieldActionPerformed(evt);
            }
        });
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                nameTextFieldFocusLost(evt);
            }
        });

        jLabel2.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.jLabel2.text")); // NOI18N

        partnerLinkTypeTextField.setEditable(false);
        partnerLinkTypeTextField.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.partnerLinkTypeTextField.text")); // NOI18N

        jLabel3.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.jLabel3.text")); // NOI18N

        partnerLinkTextField.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.partnerLinkTextField.text")); // NOI18N
        partnerLinkTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                partnerLinkTextFieldActionPerformed(evt);
            }
        });
        partnerLinkTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                partnerLinkTextFieldFocusLost(evt);
            }
        });

        jLabel4.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.jLabel4.text")); // NOI18N

        roleTextField.setEditable(false);
        roleTextField.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.roleTextField.text")); // NOI18N

        jLabel5.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.jLabel5.text")); // NOI18N

        operationTextField.setEditable(false);
        operationTextField.setText(org.openide.util.NbBundle.getMessage(TaskPanel.class, "TaskPanel.operationTextField.text")); // NOI18N

        showOperationDlgButton.setText("jButton1");
        showOperationDlgButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showOperationDlgButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .add(55, 55, 55)
                        .add(nameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                        .add(42, 42, 42))
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .add(28, 28, 28)
                        .add(partnerLinkTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                        .add(42, 42, 42))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(jLabel5)
                        .add(34, 34, 34)
                        .add(operationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(showOperationDlgButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel3)
                            .add(jLabel4))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(roleTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                            .add(partnerLinkTypeTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
                        .add(42, 42, 42))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(nameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(partnerLinkTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(showOperationDlgButton)
                    .add(operationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(partnerLinkTypeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(roleTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(19, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void showOperationDlgButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showOperationDlgButtonActionPerformed
    WSDLOperationPanel wsdlOperations = new WSDLOperationPanel(this.dObj);
    DialogDescriptor  dd = new DialogDescriptor(wsdlOperations, "select operation");
    dd.setValid(false);
    ExplorerPropertyChangeListener listener = new ExplorerPropertyChangeListener(dd);
    wsdlOperations.getExplorerManager().addPropertyChangeListener(listener);
    DialogDisplayer dDis = DialogDisplayer.getDefault();
    dDis.notify(dd);
    
    if (dd.getValue() == DialogDescriptor.OK_OPTION ) {
        Operation selectedOperation = listener.getSelectedOperation();
        if(selectedOperation != null) {
            OperationReference ref = task.createOperationReference(selectedOperation);
            dObj.getModel().startTransaction();
            task.setOperation(ref);
            dObj.getModel().endTransaction();
            refreshGUI();
        }
    }
}//GEN-LAST:event_showOperationDlgButtonActionPerformed

private void partnerLinkTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_partnerLinkTextFieldActionPerformed
    setPartnerLink();
}//GEN-LAST:event_partnerLinkTextFieldActionPerformed

private void nameTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameTextFieldActionPerformed
    setName();
}//GEN-LAST:event_nameTextFieldActionPerformed

private void partnerLinkTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_partnerLinkTextFieldFocusLost
   setPartnerLink();
}//GEN-LAST:event_partnerLinkTextFieldFocusLost

private void nameTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nameTextFieldFocusLost
   setName();
}//GEN-LAST:event_nameTextFieldFocusLost
    
    public void linkButtonPressed(Object ddBean, String property) {
    }
    
    public javax.swing.JComponent getErrorComponent(String name) {
        return null;
    }
    
    public void setValue(JComponent source, Object value)  {
        
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    private void initGUI() {
        refreshGUI();
    } 
    
    private void refreshGUI() {
        nameTextField.setText(task.getName());
        partnerLinkTypeTextField.setText(task.getPartnerLinkTypeAsString());
        roleTextField.setText(task.getRoleAsString());
        partnerLinkTextField.setText(task.getPartnerLink());
        operationTextField.setText(task.getOperationAsString());
    }
    
    private void setName() {
         WLMModel model = dObj.getModel();
        if(model != null) {
            model.startTransaction();
            task.setName(nameTextField.getText());
            model.endTransaction();

        }
    }
    
    private void setPartnerLink() {
         WLMModel model = dObj.getModel();
        if(model != null) {
            model.startTransaction();
            task.setPartnerLink(partnerLinkTextField.getText()); 
            model.endTransaction();

        }
    }
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JTextField operationTextField;
    private javax.swing.JTextField partnerLinkTextField;
    private javax.swing.JTextField partnerLinkTypeTextField;
    private javax.swing.JTextField roleTextField;
    private javax.swing.JButton showOperationDlgButton;
    // End of variables declaration//GEN-END:variables
    
    
    
}
