/*
 * ImportPanel.java
 *
 * Created on June 1, 2007, 4:42 PM
 */

package org.netbeans.modules.worklist.editor.multiview.overview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.util.UIUtilities;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/**
 *
 * @author  radval
 */
public class ImportPanel extends SectionInnerPanel {
    
    /** Creates new form ImportPanel */
   private WorklistDataObject dObj;
    
      private ImportsTableModel importsTableModel;
  
    
     /** Creates new form AssignmentPanel */
    public ImportPanel(SectionView sectionView, WorklistDataObject dObj) {
        super(sectionView);
        this.dObj=dObj;
        initComponents();
        initGUI();
    }
    
     public void linkButtonPressed(Object ddBean, String property) {
    }
    
    public javax.swing.JComponent getErrorComponent(String name) {
        return null;
    }
    
    public void setValue(JComponent source, Object value)  {
        
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
     private void initGUI() {
        refreshGUI();
        importsTable.getSelectionModel().addListSelectionListener(new ImportsTableListSelectionListener());
        removeButton.setEnabled(false);
    }
    
    private void refreshGUI() {
        importsTableModel = new ImportsTableModel();
        importsTable.setModel(importsTableModel);
        
        
            WLMModel model = dObj.getModel();
            if(model != null) {
                TTasks tasks = model.getTasks();
                if(tasks != null) {
                    Collection<TImport> imports =  tasks.getImports();
                    Iterator<TImport> it = imports.iterator();
                    
                    while(it.hasNext()) {
                        TImport imp = it.next();
                         importsTableModel.addNewImportRow(imp);
                    }
                }
            }
       
    } 
    
      
    class ImportsTableListSelectionListener implements ListSelectionListener {

        public void valueChanged(ListSelectionEvent e) {
             int selectedRows = importsTable.getSelectedRowCount();
             boolean rowSelected = selectedRows != 0 ? true : false;
             
             removeButton.setEnabled(rowSelected);
        }
        
    }
    class ImportsTableModel extends AbstractTableModel {

        private List<NamespaceAndLocation> users = new ArrayList<NamespaceAndLocation>();
        
        
        public int getRowCount() {
            return users.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
             NamespaceAndLocation row = users.get(rowIndex);
             if(row != null) {
                 if(columnIndex == 0) {
                    return row.getNamespace();
                } else {
                    return row.getLocation();
                }
             } else {
                 return "No data at index "+ rowIndex;
             }
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            NamespaceAndLocation row = users.get(rowIndex);
            if(row != null) {
                if(columnIndex == 0) {
                    row.setNamespace(aValue.toString());
                } else {
                    row.setLocation(aValue.toString());
                }
                
                fireTableDataChanged();
            }
            
        }
         
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
        
         public String getColumnName(int column) {
            if(column == 0) {
                return "Namespace";
            } else {
                return "Location";
            }
         }
         
        public void addNewImportRow(TImport imp) {
            if(imp != null) {
                NamespaceAndLocation row = new NamespaceAndLocation(imp);
                users.add(row);
                fireTableDataChanged();
            }
        }
        
        public void addNewRow() {
            NamespaceAndLocation newRow = new NamespaceAndLocation("", "");
            users.add(newRow);
            fireTableDataChanged();
        }
        
        public void removeRow(int row) {
            if(users.size() > row)  {
                NamespaceAndLocation importRow = users.get(row);
                if(importRow != null) {
                    users.remove(row);
                    TImport imp = importRow.getImport();
                    if(imp != null) {
                        dObj.getModel().startTransaction();
                        dObj.getModel().getTasks().removeImport(imp);
                        dObj.getModel().endTransaction();
                        
                    }
                    fireTableDataChanged();
                }
                
            }
            
        }
    }
    
    class NamespaceAndLocation {
        TImport imp;
        
        NamespaceAndLocation(TImport imp) {
            this.imp = imp;
        }
        
        NamespaceAndLocation(String namespace, String location) {
            WLMModel model = dObj.getModel();
            WLMComponentFactory fac = model.getFactory();
            this.imp = fac.createImport(model);
            this.imp.setNamespace(namespace);
            this.imp.setLocation(location);
            model.startTransaction();
            model.getTasks().addImport(this.imp);
            model.endTransaction();
        }
        
        public String getNamespace() {
            return this.imp.getNamespace();
        }
        
        public void setNamespace(String namespace) {
            dObj.getModel().startTransaction();
            this.imp.setNamespace(namespace);
            dObj.getModel().endTransaction();
        }
        
        public String getLocation() {
            return this.imp.getLocation();
        }
        
        public void setLocation(String location) {
            dObj.getModel().startTransaction();
            this.imp.setLocation(location);
            dObj.getModel().endTransaction();
        } 
        
        public TImport getImport() {
            return this.imp;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        importsTable = new javax.swing.JTable();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();

        importsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(importsTable);

        addButton.setLabel(org.openide.util.NbBundle.getMessage(ImportPanel.class, "ImportPanel.addButton.label")); // NOI18N
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        removeButton.setLabel(org.openide.util.NbBundle.getMessage(ImportPanel.class, "ImportPanel.removeButton.label")); // NOI18N
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 613, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(addButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 102, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(addButton)
                    .add(removeButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
    int[] selectedRows = importsTable.getSelectedRows();
    if(selectedRows.length != 0) {
        importsTableModel.removeRow(selectedRows[0]);
    }
             
}//GEN-LAST:event_removeButtonActionPerformed

private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
    // Create the new import with empty attributes.
        WLMModel model =  dObj.getModel();
        TTasks tasks = model.getTasks();
        model.startTransaction();

        // Create the new import(s).
        // Note this happens during the transaction, which is unforunate
        // but supposedly unavoidable.
        ImportWSDLCreator customizer = new ImportWSDLCreator(tasks);
        DialogDescriptor descriptor = UIUtilities.getCreatorDialog(
                customizer, NbBundle.getMessage(ImportPanel.class,
                "LBL_NewType_ImportCustomizer"), true);
        descriptor.setValid(false);
        Object result = DialogDisplayer.getDefault().notify(descriptor);

        // Creator will have created the import(s) by now.
        // In either case, end the transaction.
        model.endTransaction();
        refreshGUI();
}//GEN-LAST:event_addButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JTable importsTable;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton removeButton;
    // End of variables declaration//GEN-END:variables
    
}
