package com.sun.jbi.sapbc.sapwsdlgenerator.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

/**
 * First Wizard panel for the SAP BC Wizard.
 * Handles connection parameters.
 *
 * @author Noel Ang (noel.ang@sun.com)
 */
public final class bapiwizardVisualPanel1
        extends JPanel
        implements DocumentListener {
    
    /**
     * Creates an instance of bapiwizardVisualPanel1.
     */
    public bapiwizardVisualPanel1() {
        initComponents();
        initFieldChangeTracking();
    }
    
    public String getName() {
        return NbBundle.getMessage(getClass(), "bapiwizardWizardPanel1.step_name");
    }
    
    /**
     * Decides if the panel contains the necessary input to be sufficiently
     * usable.
     */
    boolean ready() {
        boolean isValid = true;
        
        String sysId = textfieldSystemId.getText();
        String sysNum = textfieldSystemNumber.getText();
        String serverName = textfieldServerName.getText();
        String clientNum = textfieldClientNumber.getText();
        String userName = textfieldUserName.getText();
        char[] password = textfieldPassword.getPassword();
        
        // router string is not part of the decision
        // because it is optional
        isValid = isValid && !"".equals(sysId) && sysId != null;
        isValid = isValid && !"".equals(sysNum) && sysNum != null;
        isValid = isValid && !"".equals(serverName) && serverName != null;
        isValid = isValid && !"".equals(clientNum) && clientNum != null;
        isValid = isValid && !"".equals(userName) && userName != null;
        isValid = isValid && !"".equals(password) && password != null;
        return isValid;
    }

    public void insertUpdate(DocumentEvent e) {
        changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        changedUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        Document document = e.getDocument();
        Boolean pastBlankState = documentMap.get(document);
        
        Boolean presentBlankState = Boolean.valueOf(document.getLength() == 0);
        if (!presentBlankState.equals(pastBlankState)) {
            documentMap.put(document, presentBlankState);
            firePropertyChange(PROPERTY_INPUT_UPDATE, null, null);
        }
    }
    
    private void initFieldChangeTracking() {
        documentMap.clear();
        
        // Text field document models mapped initially to 'is blank' = TRUE.
        documentMap.put(textfieldClientNumber.getDocument(), Boolean.TRUE);
        documentMap.put(textfieldServerName.getDocument(), Boolean.TRUE);
        documentMap.put(textfieldSystemId.getDocument(), Boolean.TRUE);
        documentMap.put(textfieldSystemNumber.getDocument(), Boolean.TRUE);
        documentMap.put(textfieldUserName.getDocument(), Boolean.TRUE);
        documentMap.put(textfieldPassword.getDocument(), Boolean.TRUE);
    }

    /**
     * Additional component initializations are done here.  This method is
     * meant to be called after initComponents is called.  The latter method
     * is hands-off code block generated by NetBeans, so this method provides
     * a way to consolidate manual initializations
     * (e.g., resource localizations) without losing them whenever NetBeans
     * recreates its hands-off code blocks.
     */
    private void initMoreComponents() {
        
        // Language combobox localization
        initLanguageComboBox();
    }
    
    private void initLanguageComboBox() {
        final String defaultLanguage =
                NbBundle.getMessage(getClass(),
                "bapiwizardVisualPanel1.sap_r/3_default_language");
        
        final String languages =
                NbBundle.getMessage(getClass(),
                "bapiwizardVisualPanel1.sap_r/3_languages");
        
        if (languages != null) {
            StringTokenizer tokenizer = new StringTokenizer(languages, " ");
            Collection<String> languageSet = new LinkedList<String>();
            while (tokenizer.hasMoreTokens()) {
                languageSet.add(tokenizer.nextToken());
            }
            comboboxLanguages.setModel(new DefaultComboBoxModel(languageSet.toArray()));
            
            if (defaultLanguage != null) {
                comboboxLanguages.setSelectedIndex(-1);
                comboboxLanguages.setSelectedItem(defaultLanguage);
                if (comboboxLanguages.getSelectedIndex() == -1
                        && comboboxLanguages.getItemCount() > 0) {
                    comboboxLanguages.setSelectedIndex(0);
                }
            }
        }
    }
    
    void loadSettings(final WizardDescriptor desc) {
        // Because we are populating UI components, ensure it is done
        // via the Swing dispatch thread.
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        loadSettings(desc);
                    }
                });
            } catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            } catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        
        // Text fields
        textfieldUserName.setText((String) desc.getProperty(PROPERTY_USERNAME));
        textfieldSystemId.setText((String) desc.getProperty(PROPERTY_SYSTEMID));
        textfieldSystemNumber.setText((String) desc.getProperty(PROPERTY_SYSTEMNUM));
        textfieldServerName.setText((String) desc.getProperty(PROPERTY_SERVERNAME));
        textfieldSapRouterString.setText((String) desc.getProperty(PROPERTY_ROUTERSTRING));
        textfieldClientNumber.setText((String) desc.getProperty(PROPERTY_CLIENTNUM));
        textfieldPassword.setText((String) desc.getProperty(PROPERTY_PASSWORD));
        
        // Object Type radio buttons
        Boolean selected = (Boolean) desc.getProperty(PROPERTY_OBJECTTYPE_BAPI);
        radiobuttonObjTypeBapi.setSelected(selected != null ? selected : false);
        selected = (Boolean) desc.getProperty(PROPERTY_OBJECTTYPE_RFC);
        radiobuttonObjTypeRfc.setSelected(selected != null ? selected : false);

        // Trace checkbox
        final Boolean traceRfc = (Boolean) desc.getProperty(PROPERTY_TRACERFC);
        checkboxRfcTraceFile.setSelected(traceRfc != null && traceRfc.booleanValue());
        
        // Language combobox
        final Object language = desc.getProperty(PROPERTY_LANGUAGE);
        if (language != null) {
            comboboxLanguages.setSelectedItem(language);
        }
        if (comboboxLanguages.getSelectedIndex() == -1) {
            comboboxLanguages.setSelectedIndex(
                comboboxLanguages.getItemCount() == 0 ? -1 : 0);
        }
        
        // Notify wizard panel that its visual panel is now loaded with new values.
        firePropertyChange(PROPERTY_INPUT_UPDATE, null, null);
    }

    void storeSettings(final WizardDescriptor desc) {
        // Text fields
        desc.putProperty(PROPERTY_USERNAME, textfieldUserName.getText());
        desc.putProperty(PROPERTY_PASSWORD, textfieldPassword.getPassword());
        desc.putProperty(PROPERTY_SYSTEMID, textfieldSystemId.getText());
        desc.putProperty(PROPERTY_SYSTEMNUM, textfieldSystemNumber.getText());
        desc.putProperty(PROPERTY_SERVERNAME, textfieldServerName.getText());
        desc.putProperty(PROPERTY_ROUTERSTRING, textfieldSapRouterString.getText());
        desc.putProperty(PROPERTY_CLIENTNUM, textfieldClientNumber.getText());
        
        // Object Type radio buttons
        desc.putProperty(PROPERTY_OBJECTTYPE_BAPI,
                Boolean.valueOf(radiobuttonObjTypeBapi.isSelected()));
        desc.putProperty(PROPERTY_OBJECTTYPE_RFC,
                Boolean.valueOf(radiobuttonObjTypeRfc.isSelected()));
        
        // Trace checkbox
        desc.putProperty(PROPERTY_TRACERFC, Boolean.valueOf(checkboxRfcTraceFile.isSelected()));
        
        // Language combobox
        desc.putProperty(PROPERTY_LANGUAGE, comboboxLanguages.getSelectedItem());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttongroupObjectType = new javax.swing.ButtonGroup();
        panelConnectData = new javax.swing.JPanel();
        labelSystemParams = new javax.swing.JLabel();
        labelSystemId = new javax.swing.JLabel();
        labelServerName = new javax.swing.JLabel();
        labelSystemNumber = new javax.swing.JLabel();
        labelSapRouterString = new javax.swing.JLabel();
        labelLanguage = new javax.swing.JLabel();
        textfieldSystemId = new javax.swing.JTextField();
        textfieldServerName = new javax.swing.JTextField();
        textfieldSystemNumber = new javax.swing.JTextField();
        textfieldSapRouterString = new javax.swing.JTextField();
        comboboxLanguages = new javax.swing.JComboBox();
        labelLogonParams = new javax.swing.JLabel();
        labelClientNumber = new javax.swing.JLabel();
        labelUserName = new javax.swing.JLabel();
        labelPassword = new javax.swing.JLabel();
        textfieldClientNumber = new javax.swing.JTextField();
        textfieldUserName = new javax.swing.JTextField();
        textfieldPassword = new javax.swing.JPasswordField();
        labelFootnoteOptionalFields = new javax.swing.JLabel();
        panelOptions = new javax.swing.JPanel();
        labelObjType = new javax.swing.JLabel();
        radiobuttonObjTypeBapi = new javax.swing.JRadioButton();
        radiobuttonObjTypeRfc = new javax.swing.JRadioButton();
        labelDiagnostics = new javax.swing.JLabel();
        checkboxRfcTraceFile = new javax.swing.JCheckBox();

        panelConnectData.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Connection", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 12)));
        labelSystemParams.setFont(new java.awt.Font("Tahoma", 1, 11));
        labelSystemParams.setText("SAP R/3 System Parameters:");

        labelSystemId.setDisplayedMnemonic('i');
        labelSystemId.setLabelFor(textfieldSystemId);
        labelSystemId.setText("System ID:");

        labelServerName.setDisplayedMnemonic('a');
        labelServerName.setLabelFor(textfieldServerName);
        labelServerName.setText("Application Server:");

        labelSystemNumber.setDisplayedMnemonic('y');
        labelSystemNumber.setLabelFor(textfieldServerName);
        labelSystemNumber.setText("System Number:");

        labelSapRouterString.setDisplayedMnemonic('r');
        labelSapRouterString.setLabelFor(textfieldSapRouterString);
        labelSapRouterString.setText("*SAP Router String:");

        labelLanguage.setDisplayedMnemonic('l');
        labelLanguage.setLabelFor(comboboxLanguages);
        labelLanguage.setText("Language:");

        textfieldSystemId.getDocument().addDocumentListener(this);
        textfieldSystemId.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        textfieldServerName.getDocument().addDocumentListener(this);
        textfieldServerName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        textfieldSystemNumber.getDocument().addDocumentListener(this);
        textfieldSystemNumber.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        textfieldSapRouterString.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        comboboxLanguages.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "EN", "JA", "DE", "KO" }));

        labelLogonParams.setFont(new java.awt.Font("Tahoma", 1, 11));
        labelLogonParams.setText("SAP R/3 Logon Parameters:");

        labelClientNumber.setDisplayedMnemonic('m');
        labelClientNumber.setLabelFor(textfieldClientNumber);
        labelClientNumber.setText("Client Number:");

        labelUserName.setDisplayedMnemonic('u');
        labelUserName.setLabelFor(textfieldUserName);
        labelUserName.setText("User Name:");

        labelPassword.setDisplayedMnemonic('w');
        labelPassword.setLabelFor(textfieldPassword);
        labelPassword.setText("Password:");

        textfieldClientNumber.getDocument().addDocumentListener(this);
        textfieldClientNumber.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        textfieldUserName.getDocument().addDocumentListener(this);
        textfieldUserName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });
        
        textfieldPassword.getDocument().addDocumentListener(this);
        textfieldPassword.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                textFieldFocusGained(evt);
            }
        });

        labelFootnoteOptionalFields.setText("*Optional Fields");

        org.jdesktop.layout.GroupLayout panelConnectDataLayout = new org.jdesktop.layout.GroupLayout(panelConnectData);
        panelConnectData.setLayout(panelConnectDataLayout);
        panelConnectDataLayout.setHorizontalGroup(
            panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelConnectDataLayout.createSequentialGroup()
                .add(10, 10, 10)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, panelConnectDataLayout.createSequentialGroup()
                        .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelUserName)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelPassword)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelClientNumber)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelLanguage)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelSapRouterString)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelSystemNumber)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelServerName)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, labelSystemId))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, textfieldClientNumber, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, comboboxLanguages, 0, 258, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, textfieldSystemNumber, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(textfieldServerName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(textfieldSystemId, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(textfieldSapRouterString, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, textfieldUserName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)
                            .add(textfieldPassword, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)))
                    .add(labelLogonParams)
                    .add(labelSystemParams)
                    .add(panelConnectDataLayout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(labelFootnoteOptionalFields)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 282, Short.MAX_VALUE)))
                .addContainerGap())
        );
        panelConnectDataLayout.setVerticalGroup(
            panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelConnectDataLayout.createSequentialGroup()
                .add(labelSystemParams)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelSystemId)
                    .add(textfieldSystemId, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelServerName)
                    .add(textfieldServerName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelSystemNumber)
                    .add(textfieldSystemNumber, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelSapRouterString)
                    .add(textfieldSapRouterString, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelLanguage)
                    .add(comboboxLanguages, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(labelLogonParams)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(labelClientNumber)
                    .add(textfieldClientNumber, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(textfieldUserName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(labelUserName))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(panelConnectDataLayout.createSequentialGroup()
                        .add(panelConnectDataLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(textfieldPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(labelPassword))
                        .addContainerGap(24, Short.MAX_VALUE))
                    .add(panelConnectDataLayout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 32, Short.MAX_VALUE)
                        .add(labelFootnoteOptionalFields))))
        );

        panelConnectDataLayout.linkSize(new java.awt.Component[] {comboboxLanguages, textfieldClientNumber, textfieldPassword, textfieldSapRouterString, textfieldServerName, textfieldSystemId, textfieldSystemNumber, textfieldUserName}, org.jdesktop.layout.GroupLayout.VERTICAL);

        panelOptions.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Options", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 12)));
        labelObjType.setText("Object Type:");

        buttongroupObjectType.add(radiobuttonObjTypeBapi);
        radiobuttonObjTypeBapi.setMnemonic('p');
        radiobuttonObjTypeBapi.setSelected(true);
        radiobuttonObjTypeBapi.setText("BAPI");
        radiobuttonObjTypeBapi.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        radiobuttonObjTypeBapi.setMargin(new java.awt.Insets(0, 0, 0, 0));
        radiobuttonObjTypeBapi.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radiobuttonObjTypeBapiActionPerformed(evt);
            }
        });

        buttongroupObjectType.add(radiobuttonObjTypeRfc);
        radiobuttonObjTypeRfc.setMnemonic('f');
        radiobuttonObjTypeRfc.setText("RFC");
        radiobuttonObjTypeRfc.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        radiobuttonObjTypeRfc.setMargin(new java.awt.Insets(0, 0, 0, 0));
        radiobuttonObjTypeRfc.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radiobuttonObjTypeRfcActionPerformed(evt);
            }
        });

        labelDiagnostics.setText("Diagnostics:");

        checkboxRfcTraceFile.setMnemonic('t');
        checkboxRfcTraceFile.setText("Generate RFC Trace (file)");
        checkboxRfcTraceFile.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        checkboxRfcTraceFile.setEnabled(false);
        checkboxRfcTraceFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        checkboxRfcTraceFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkboxRfcTraceFileActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout panelOptionsLayout = new org.jdesktop.layout.GroupLayout(panelOptions);
        panelOptions.setLayout(panelOptionsLayout);
        panelOptionsLayout.setHorizontalGroup(
            panelOptionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelOptionsLayout.createSequentialGroup()
                .addContainerGap()
                .add(panelOptionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(panelOptionsLayout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(checkboxRfcTraceFile))
                    .add(labelObjType)
                    .add(panelOptionsLayout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(panelOptionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(radiobuttonObjTypeRfc)
                            .add(radiobuttonObjTypeBapi)))
                    .add(labelDiagnostics))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        panelOptionsLayout.setVerticalGroup(
            panelOptionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(panelOptionsLayout.createSequentialGroup()
                .add(labelObjType)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(radiobuttonObjTypeBapi)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(radiobuttonObjTypeRfc)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(labelDiagnostics)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(checkboxRfcTraceFile)
                .addContainerGap(185, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(panelConnectData, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelOptions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, panelOptions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, panelConnectData, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void checkboxRfcTraceFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkboxRfcTraceFileActionPerformed
        firePropertyChange(PROPERTY_TRACERFC,
                null,
                Boolean.valueOf(checkboxRfcTraceFile.isSelected()));
    }//GEN-LAST:event_checkboxRfcTraceFileActionPerformed

    private void radiobuttonObjTypeBapiActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radiobuttonObjTypeBapiActionPerformed
        checkboxRfcTraceFile.setEnabled(false);
        firePropertyChange(PROPERTY_OBJECTTYPE_BAPI, null, null);
    }//GEN-LAST:event_radiobuttonObjTypeBapiActionPerformed

    private void radiobuttonObjTypeRfcActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radiobuttonObjTypeRfcActionPerformed
        checkboxRfcTraceFile.setEnabled(true);
        firePropertyChange(PROPERTY_OBJECTTYPE_RFC, null, null);
    }//GEN-LAST:event_radiobuttonObjTypeRfcActionPerformed

    private void textFieldFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_textFieldFocusGained
        if (!evt.isTemporary()) {
            // Highlight the whole content of the field that just gained focus.
            Object source = evt.getSource();
            if (source instanceof JTextField) {
                JTextField tf = (JTextField) source;
                tf.setCaretPosition(0);
                tf.moveCaretPosition(tf.getText().length());
            }
        }
    }//GEN-LAST:event_textFieldFocusGained

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttongroupObjectType;
    private javax.swing.JCheckBox checkboxRfcTraceFile;
    private javax.swing.JComboBox comboboxLanguages;
    private javax.swing.JLabel labelClientNumber;
    private javax.swing.JLabel labelDiagnostics;
    private javax.swing.JLabel labelFootnoteOptionalFields;
    private javax.swing.JLabel labelLanguage;
    private javax.swing.JLabel labelLogonParams;
    private javax.swing.JLabel labelObjType;
    private javax.swing.JLabel labelPassword;
    private javax.swing.JLabel labelSapRouterString;
    private javax.swing.JLabel labelServerName;
    private javax.swing.JLabel labelSystemId;
    private javax.swing.JLabel labelSystemNumber;
    private javax.swing.JLabel labelSystemParams;
    private javax.swing.JLabel labelUserName;
    private javax.swing.JPanel panelConnectData;
    private javax.swing.JPanel panelOptions;
    private javax.swing.JRadioButton radiobuttonObjTypeBapi;
    private javax.swing.JRadioButton radiobuttonObjTypeRfc;
    private javax.swing.JTextField textfieldClientNumber;
    private javax.swing.JPasswordField textfieldPassword;
    private javax.swing.JTextField textfieldSapRouterString;
    private javax.swing.JTextField textfieldServerName;
    private javax.swing.JTextField textfieldSystemId;
    private javax.swing.JTextField textfieldSystemNumber;
    private javax.swing.JTextField textfieldUserName;
    // End of variables declaration//GEN-END:variables

    /**
     * Mapping between Document objects of various text fields, to their
     * 'is blank' state.  This map is used to decide whether or not to inform
     * change listeners when changes to a field's document model occurs.
     */
    private final Map<Document, Boolean> documentMap = new HashMap<Document, Boolean>();

    /**
     * Property indicating that user input in this visual panel has been changed.
     */
    static final String PROPERTY_INPUT_UPDATE =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.input.update";

    /**
     * Name of property for the value in the User Name field.
     */
    static final String PROPERTY_USERNAME =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.username";

    /**
     * Name of property for the value in the Password field.
     */
    static final String PROPERTY_PASSWORD =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.password";

    /**
     * Name of property for the value in the Client Number field.
     */
    static final String PROPERTY_CLIENTNUM =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.clientnum";

    /**
     * Name of property for the value in the System ID field.
     */
    static final String PROPERTY_SYSTEMID =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.systemid";

    /**
     * Name of property for the value in the System Number field.
     */
    static final String PROPERTY_SYSTEMNUM =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.systemnum";

    /**
     * Name of property for the value in the Server Name field.
     */
    static final String PROPERTY_SERVERNAME =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.servername";

    /**
     * Name of property for the value in the SAP Router String field.
     */
    static final String PROPERTY_ROUTERSTRING =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.routerstring";
    
    /**
     * Name of property for the set/unset state of the BAPI Object Type radio button.
     */
    static final String PROPERTY_OBJECTTYPE_BAPI =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.objecttype.bapi";

    /**
     * Name of property for the set/unset state of the RFC Object Type radio button.
     */
    static final String PROPERTY_OBJECTTYPE_RFC =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.objecttype.rfc";

    /**
     * Name of property for the set/unset state of the RFC Trace File checkbox.
     */
    static final String PROPERTY_TRACERFC =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.trace.rfc";
    
    /**
     * Name of property for the selected value in the Language combobox.
     */
    static final String PROPERTY_LANGUAGE =
            "com.sun.jbi.sapbapibc.wizard.bapiwizardVisualPanel1.language";
}
