/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.encoder.custom.aip;

import com.sun.encoder.custom.appinfo.Delimiter;
import com.sun.encoder.custom.appinfo.DelimiterBytes;
import com.sun.encoder.custom.appinfo.DelimiterLevel;
import com.sun.encoder.custom.appinfo.DelimiterSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeSelectionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/**
 * The view of the delimiter set property editor
 *
 * @author  Jun Xu
 */
public class DelimiterSetForm extends javax.swing.JPanel
        implements ExplorerManager.Provider, Lookup.Provider, ActionListener {
    
    private final DelimiterSet mDelimiterSet ;
    private final DelimiterSetChangeListener mDelimiterSetChangeListener =
            new DelimiterSetChangeListener() {
        public void propertyChange(PropertyChangeEvent evt) {
            if (validate(mDelimiterSet)) {
                firePropertyChange("valid", null, Boolean.TRUE); //NOI18N
            } else {
                firePropertyChange("valid", null, Boolean.FALSE); //NOI18N
            }
        }
    };
    
    private ExplorerManager mManager;
    private Lookup mLookup;
    
    /**
     * Creates new form DelimiterSetForm
     */
    public DelimiterSetForm(DelimiterSet delimSet) {
        initComponents();
        initialize(delimSet);
        mDelimiterSet = delimSet;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        addLevelButton = new javax.swing.JButton();
        addDelimiterButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        delimiterTreeTableView = new org.netbeans.modules.encoder.custom.aip.DelimiterTreeTableView();
        removeAllButton = new javax.swing.JButton();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/encoder/custom/aip/Bundle"); // NOI18N
        addLevelButton.setText(bundle.getString("delim_set_form.lbl.add_level")); // NOI18N
        addLevelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addLevelButtonActionPerformed(evt);
            }
        });

        addDelimiterButton.setText(bundle.getString("delim_set_form.lbl.add_delim")); // NOI18N
        addDelimiterButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addDelimiterButtonActionPerformed(evt);
            }
        });

        removeButton.setText(bundle.getString("delim_set_form.lbl.remove")); // NOI18N
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        delimiterTreeTableView.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        delimiterTreeTableView.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        delimiterTreeTableView.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        delimiterTreeTableView.setDefaultActionAllowed(false);
        delimiterTreeTableView.setTreePreferredWidth(100);

        removeAllButton.setText(bundle.getString("delim_set_form.lbl.remove_all")); // NOI18N
        removeAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeAllButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(delimiterTreeTableView, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 624, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(removeAllButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(removeButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(addLevelButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 87, Short.MAX_VALUE)
                    .add(addDelimiterButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(delimiterTreeTableView, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 342, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(addLevelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(addDelimiterButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeAllButton)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void removeAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeAllButtonActionPerformed
        Node root = mManager.getRootContext();
        Node[] childNodes = root.getChildren().getNodes();
        DelimiterSet delimSet = (DelimiterSet) root.getLookup().lookup(DelimiterSet.class);
        delimSet.setLevelArray(new DelimiterLevel[0]);
        root.getChildren().remove(childNodes);
        try {
            mManager.setSelectedNodes(new Node[0]);
        } catch (PropertyVetoException ex) {
        }
    }//GEN-LAST:event_removeAllButtonActionPerformed

    private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        Node[] selectedNodes = mManager.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length == 0) {
            return;
        }
        //Check it is delimiter level or delimiter
        DelimiterLevel level;
        level = (DelimiterLevel) selectedNodes[0].getLookup().lookup(DelimiterLevel.class);
        if (level == null) {
            //Must be a delimiter node
            Node levelNode = selectedNodes[0].getParentNode();
            level = (DelimiterLevel) levelNode.getLookup().lookup(DelimiterLevel.class);
            Node[] childNodes = levelNode.getChildren().getNodes();
            int index = -1;
            for (int i = 0; i < childNodes.length; i++) {
                if (childNodes[i] == selectedNodes[0]) {
                    index = i;
                    break;
                }
            }
            if (index != -1) {
                level.removeDelimiter(index);
                levelNode.getChildren().remove(new Node[]{selectedNodes[0]});
            }
        } else {
            //Must be a delimiter level node
            Node root = mManager.getRootContext();
            DelimiterSet delimSet = (DelimiterSet) root.getLookup().lookup(DelimiterSet.class);
            Node[] childNodes = root.getChildren().getNodes();
            int index = -1;
            for (int i = 0; i < childNodes.length; i++) {
                if (childNodes[i] == selectedNodes[0]) {
                    index = i;
                    break;
                }
            }
            if (index != -1) {
                delimSet.removeLevel(index);
                root.getChildren().remove(new Node[]{selectedNodes[0]});
            }
        }
    }//GEN-LAST:event_removeButtonActionPerformed

    private void addDelimiterButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addDelimiterButtonActionPerformed
        Node root = mManager.getRootContext();
        DelimiterSet delimSet = (DelimiterSet) root.getLookup().lookup(DelimiterSet.class);
        Node[] selectedNodes = mManager.getSelectedNodes();
        DelimiterLevel level;
        Node levelNode;
        if (selectedNodes == null || selectedNodes.length == 0) {
            if (delimSet.sizeOfLevelArray() == 0) {
                level = delimSet.addNewLevel();
                final Node newLevelNode =
                        new DelimTreeLevelNode(
                                level,
                                new DelimTreeLevelNodeChildren(level),
                                Lookups.singleton(level));
                root.getChildren().add(new Node[]{newLevelNode});
                levelNode = newLevelNode;
            } else {
                levelNode = root.getChildren().getNodes()[root.getChildren().getNodesCount() - 1];
                level = (DelimiterLevel) levelNode.getLookup().lookup(DelimiterLevel.class);
            }
        } else {
            //Since single selection mode is used, must only one node is returned
            //Check to see if it is a delimiter level node
            level = (DelimiterLevel) selectedNodes[0].getLookup().lookup(DelimiterLevel.class);
            if (level == null) {
                //It is not a delimiter level node, then must be a delimiter node
                levelNode = selectedNodes[0].getParentNode();
                level = (DelimiterLevel) levelNode.getLookup().lookup(DelimiterLevel.class);
            } else {
                levelNode = selectedNodes[0];
            }
        }
        Delimiter newDelim = level.addNewDelimiter();
        newDelim.setKind(Delimiter.Kind.NORMAL);
        newDelim.setPrecedence((short) 10);
        newDelim.setOptionalMode(Delimiter.OptionalMode.NEVER);
        newDelim.setTerminatorMode(Delimiter.TerminatorMode.NEVER);
        newDelim.addNewBytes();
        newDelim.getBytes().setConstant(""); //NOI18N
        final Node newDelimNode =
                new DelimTreeDelimiterNode(
                        newDelim,
                        Lookups.singleton(newDelim));
        levelNode.getChildren().add(new Node[]{newDelimNode});
        Runnable doExpandAll = new Runnable() {
            public void run() {
                delimiterTreeTableView.expandAll();
            }
        };
        SwingUtilities.invokeLater(doExpandAll);
    }//GEN-LAST:event_addDelimiterButtonActionPerformed

    private void addLevelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addLevelButtonActionPerformed
        Node root = mManager.getRootContext();
        DelimiterSet delimSet = (DelimiterSet) root.getLookup().lookup(DelimiterSet.class);
        DelimiterLevel level = delimSet.addNewLevel();
        final Node newLevelNode =
                new DelimTreeLevelNode(
                        level,
                        new DelimTreeLevelNodeChildren(level),
                        Lookups.singleton(level));
        root.getChildren().add(new Node[]{newLevelNode});
        Runnable doExpandNode = new Runnable() {
            public void run() {
                delimiterTreeTableView.expandNode(newLevelNode);
            }
        };
        SwingUtilities.invokeLater(doExpandNode);
    }//GEN-LAST:event_addLevelButtonActionPerformed

    public ExplorerManager getExplorerManager() {
        return mManager;
    }
    
    public Lookup getLookup() {
        return mLookup;
    }
    
    public void addNotify() {
        super.addNotify();
        ExplorerUtils.activateActions(mManager, true);
    }
    public void removeNotify() {
        ExplorerUtils.activateActions(mManager, false);
        super.removeNotify();
    }
    
    public void actionPerformed(ActionEvent e) {
        
    }

    private void initialize(DelimiterSet delimSet) {
        mManager = new ExplorerManager();
        ActionMap map = getActionMap();
        mLookup = ExplorerUtils.createLookup (mManager, map);
        DelimTreeRootNodeChildren children = new DelimTreeRootNodeChildren(delimSet);
        children.addDelimiterSetChangeListener(mDelimiterSetChangeListener);
        DelimTreeRootNode root =
                new DelimTreeRootNode(delimSet, children, Lookups.singleton(delimSet));
        root.addDelimiterSetChangeListener(mDelimiterSetChangeListener);
        mManager.setRootContext(root);
        delimiterTreeTableView.setRootVisible(false);
        delimiterTreeTableView.setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        float ratio = delimiterTreeTableView.getFont().getSize2D() / 12;
        delimiterTreeTableView.setTreePreferredWidth((int) (ratio * 120));
        delimiterTreeTableView.setTableAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        Runnable doExpandAll = new Runnable() {
            public void run() {
                delimiterTreeTableView.expandAll();
            }
        };
        SwingUtilities.invokeLater(doExpandAll);
    }
    
    private boolean validate(DelimiterSet delimSet) {
        if (delimSet == null || delimSet.sizeOfLevelArray() == 0) {
            return true;
        }
        if (!delimSet.validate()) {
            return false;
        }
        DelimiterLevel levels[] = delimSet.getLevelArray();
        Delimiter[] delims;
        DelimiterBytes delimBytes;
        for (int i = 0; i < levels.length; i++) {
            delims = levels[i].getDelimiterArray();
            for (int j = 0; j < delims.length; j++) {
                delimBytes = delims[j].getBytes();
                if (delimBytes == null) {
                    return false;
                }
                if (delimBytes.isSetConstant()) {
                    if (delimBytes.getConstant() == null
                            || delimBytes.getConstant().length() == 0) {
                        return false;
                    }
                } else if (delimBytes.isSetEmbedded()) {
                    if (delimBytes.getEmbedded() == null
                            || delimBytes.getEmbedded().getLength() == 0) {
                        return false;
                    }
                }
            }
        }
        return true;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addDelimiterButton;
    private javax.swing.JButton addLevelButton;
    private org.netbeans.modules.encoder.custom.aip.DelimiterTreeTableView delimiterTreeTableView;
    private javax.swing.JButton removeAllButton;
    private javax.swing.JButton removeButton;
    // End of variables declaration//GEN-END:variables
}
