/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.encoder.coco.ui.wizard;

import javax.swing.JComboBox;
import javax.swing.JPanel;

public final class GenerateXSDVisualPanel1 extends JPanel {
    
    /** Creates new form GenerateXSDVisualPanel1 */
    public GenerateXSDVisualPanel1() {
        initComponents();
        jComboBoxCopybookCodePage.setModel(new javax.swing.DefaultComboBoxModel());
        jComboBoxDISPLAY1CodePage.setModel(new javax.swing.DefaultComboBoxModel());
        jComboBoxDISPLAYCodePage.setModel(new javax.swing.DefaultComboBoxModel());
        jComboBoxPostencodeCoding.setModel(new javax.swing.DefaultComboBoxModel());
        jComboBoxPredecodeCoding.setModel(new javax.swing.DefaultComboBoxModel());
    }
    
    public String getName() {
        return "Specify Encoder Options";
    }
    
    public void setCopybookCodePageList(String[] list) {
        setComboBoxList(jComboBoxCopybookCodePage, list);
    }
    
    public void setCopybookCodePage(String cp) {
        jComboBoxCopybookCodePage.getEditor().setItem(cp);
    }
    
    public String getCopybookCodePage() {
        return jComboBoxCopybookCodePage.getEditor().getItem().toString();
    }
    
    public void setDisplayCodePageList(String[] list) {
        setComboBoxList(jComboBoxDISPLAYCodePage, list);
    }
    
    public void setDisplayCodePage(String cp) {
        jComboBoxDISPLAYCodePage.getEditor().setItem(cp);
    }
    
    public String getDisplayCodePage() {
        return jComboBoxDISPLAYCodePage.getEditor().getItem().toString();
    }
    
    public void setDisplay1CodePageList(String[] list) {
        setComboBoxList(jComboBoxDISPLAY1CodePage, list);
    }
    
    public void setDisplay1CodePage(String cp) {
        jComboBoxDISPLAY1CodePage.getEditor().setItem(cp);
    }
    
    public String getDisplay1CodePage() {
        return jComboBoxDISPLAY1CodePage.getEditor().getItem().toString();
    }
    
    public void setPredecodeCodingList(String[] list) {
        setComboBoxList(jComboBoxPredecodeCoding, list);
    }
    
    public void setPredecodeCoding(String cp) {
        jComboBoxPredecodeCoding.getEditor().setItem(cp);
    }
    
    public String getPredecodeCoding() {
        return jComboBoxPredecodeCoding.getEditor().getItem().toString();
    }
    
    public void setPostencodeCodingList(String[] list) {
        setComboBoxList(jComboBoxPostencodeCoding, list);
    }
    
    public void setPostencodeCoding(String cp) {
        jComboBoxPostencodeCoding.getEditor().setItem(cp);
    }
    
    public String getPostencodeCoding() {
        return jComboBoxPostencodeCoding.getEditor().getItem().toString();
    }
    
    public void setIgnore72ColBeyond(boolean val) {
        jCheckBoxIgnore72ColBeyond.setSelected(val);
    }
    
    public boolean getIgnore72ColBeyond() {
        return jCheckBoxIgnore72ColBeyond.isSelected();
    }
    
    public void setOverwriteExisting(boolean val) {
        jCheckBoxOverwriteExisting.setSelected(val);
    }
    
    public boolean getOverwriteExisting() {
        return jCheckBoxOverwriteExisting.isSelected();
    }
    
    public void setCheckReservedWords(boolean val) {
        jCheckBoxCheckReservedWords.setSelected(val);
    }
    
    public boolean getCheckReservedWords() {
        return jCheckBoxCheckReservedWords.isSelected();
    }
    
    public void setTargetNamespace(String val) {
        jTextFieldTargetNamespace.setText(val);
    }
    
    public String getTargetNamespace() {
        return jTextFieldTargetNamespace.getText();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelCopybookCodePage = new javax.swing.JLabel();
        jComboBoxCopybookCodePage = new javax.swing.JComboBox();
        jLabelDISPLAYCodePage = new javax.swing.JLabel();
        jComboBoxPredecodeCoding = new javax.swing.JComboBox();
        jLabelDISPLAY1CodePage = new javax.swing.JLabel();
        jComboBoxDISPLAYCodePage = new javax.swing.JComboBox();
        jLabelPredecodeCoding = new javax.swing.JLabel();
        jComboBoxDISPLAY1CodePage = new javax.swing.JComboBox();
        jLabelPostencodeCoding = new javax.swing.JLabel();
        jComboBoxPostencodeCoding = new javax.swing.JComboBox();
        jCheckBoxIgnore72ColBeyond = new javax.swing.JCheckBox();
        jCheckBoxCheckReservedWords = new javax.swing.JCheckBox();
        jCheckBoxOverwriteExisting = new javax.swing.JCheckBox();
        jLabelTargetNamespace = new javax.swing.JLabel();
        jTextFieldTargetNamespace = new javax.swing.JTextField();

        org.openide.awt.Mnemonics.setLocalizedText(jLabelCopybookCodePage, "Copybook Code Page:");

        jComboBoxCopybookCodePage.setEditable(true);
        jComboBoxCopybookCodePage.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBoxCopybookCodePage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxCopybookCodePageActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jLabelDISPLAYCodePage, "DISPLAY Code Page:");

        jComboBoxPredecodeCoding.setEditable(true);
        jComboBoxPredecodeCoding.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelDISPLAY1CodePage, "DISPLAY1 Code Page:");

        jComboBoxDISPLAYCodePage.setEditable(true);
        jComboBoxDISPLAYCodePage.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelPredecodeCoding, "Pre-decoding Char. Coding:");
        jLabelPredecodeCoding.setToolTipText("The coding tells the encoder how to convert input for decoding from the data nature that cannot be accepted by the encoder to the data nature that is acceptable by the encoder.");

        jComboBoxDISPLAY1CodePage.setEditable(true);
        jComboBoxDISPLAY1CodePage.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelPostencodeCoding, "Post-encoding Char. Coding:");
        jLabelPostencodeCoding.setToolTipText("The coding tells the encoder how to convert output for encoding from the data nature that is used by the encoder to the data nature that is required by the method signature.");

        jComboBoxPostencodeCoding.setEditable(true);
        jComboBoxPostencodeCoding.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxIgnore72ColBeyond, "Ignore content beyond 72 column");
        jCheckBoxIgnore72ColBeyond.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxIgnore72ColBeyond.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxCheckReservedWords, "Check names for reserved words");
        jCheckBoxCheckReservedWords.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCheckReservedWords.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxOverwriteExisting, "Overwrite existing files with same name");
        jCheckBoxOverwriteExisting.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxOverwriteExisting.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.openide.awt.Mnemonics.setLocalizedText(jLabelTargetNamespace, "Target Namespace:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jCheckBoxIgnore72ColBeyond)
                    .add(jCheckBoxCheckReservedWords)
                    .add(jCheckBoxOverwriteExisting)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabelCopybookCodePage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 111, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabelDISPLAYCodePage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabelDISPLAY1CodePage)
                            .add(jLabelPredecodeCoding, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 138, Short.MAX_VALUE)
                            .add(jLabelPostencodeCoding, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(jLabelTargetNamespace, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jComboBoxCopybookCodePage, 0, 287, Short.MAX_VALUE)
                            .add(jComboBoxDISPLAYCodePage, 0, 287, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jComboBoxDISPLAY1CodePage, 0, 287, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jComboBoxPredecodeCoding, 0, 287, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jComboBoxPostencodeCoding, 0, 287, Short.MAX_VALUE)
                            .add(jTextFieldTargetNamespace, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 287, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(27, 27, 27)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabelCopybookCodePage)
                    .add(jComboBoxCopybookCodePage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(9, 9, 9)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBoxDISPLAYCodePage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDISPLAYCodePage))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBoxDISPLAY1CodePage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelDISPLAY1CodePage))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBoxPredecodeCoding, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelPredecodeCoding))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBoxPostencodeCoding, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelPostencodeCoding))
                .add(15, 15, 15)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabelTargetNamespace)
                    .add(jTextFieldTargetNamespace, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(16, 16, 16)
                .add(jCheckBoxIgnore72ColBeyond)
                .add(18, 18, 18)
                .add(jCheckBoxCheckReservedWords)
                .add(18, 18, 18)
                .add(jCheckBoxOverwriteExisting)
                .addContainerGap(26, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxCopybookCodePageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxCopybookCodePageActionPerformed
    // TODO add your handling code here:
}//GEN-LAST:event_jComboBoxCopybookCodePageActionPerformed

    private void setComboBoxList(JComboBox comboBox, String[] list) {
        comboBox.removeAllItems();
        for (int i = 0; i < list.length; i++) {
            comboBox.addItem(list[i]);
        }
        comboBox.setSelectedIndex(-1);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jCheckBoxCheckReservedWords;
    private javax.swing.JCheckBox jCheckBoxIgnore72ColBeyond;
    private javax.swing.JCheckBox jCheckBoxOverwriteExisting;
    private javax.swing.JComboBox jComboBoxCopybookCodePage;
    private javax.swing.JComboBox jComboBoxDISPLAY1CodePage;
    private javax.swing.JComboBox jComboBoxDISPLAYCodePage;
    private javax.swing.JComboBox jComboBoxPostencodeCoding;
    private javax.swing.JComboBox jComboBoxPredecodeCoding;
    private javax.swing.JLabel jLabelCopybookCodePage;
    private javax.swing.JLabel jLabelDISPLAY1CodePage;
    private javax.swing.JLabel jLabelDISPLAYCodePage;
    private javax.swing.JLabel jLabelPostencodeCoding;
    private javax.swing.JLabel jLabelPredecodeCoding;
    private javax.swing.JLabel jLabelTargetNamespace;
    private javax.swing.JTextField jTextFieldTargetNamespace;
    // End of variables declaration//GEN-END:variables
    
}

