/*
 *  Copyright (c) 2005, 2006 Imola Informatica.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the LGPL License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/lgpl.html
 */


package it.imolinfo.jbi4corba.netbeansplugin.idl2wsdlwizard;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class IDLDataLoader extends UniFileLoader {

    public static final String REQUIRED_MIME = "text/idl";

    private static final long serialVersionUID = 1L;

    public IDLDataLoader() {
        super(IDLDataObject.class.getName());
    }

    protected String defaultDisplayName() {                     // Overridden
        return NbBundle.getMessage(IDLDataLoader.class, "LBL_IDL_loader_name");
    }

    protected void initialize() {                               // Overridden
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected MultiDataObject createMultiObject(final FileObject primaryFile)
            throws IOException {
        return new IDLDataObject(primaryFile, this);
    }

    protected String actionsContext() {                         // Overridden
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
}
