/*
 *  Copyright (c) 2005, 2006 Imola Informatica.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the LGPL License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/lgpl.html
 */


package it.imolinfo.jbi4cics.netbeansplugin.cpy2wsdlwizard;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class CPYDataLoader extends UniFileLoader {

    public static final String REQUIRED_MIME = "text/cpy";

    private static final long serialVersionUID = 1L;

    public CPYDataLoader() {
        super(CPYDataObject.class.getName());
    }

    @Override
    protected String defaultDisplayName() {                     // Overridden
        return NbBundle.getMessage(CPYDataLoader.class, "LBL_CPY_loader_name");
    }

    @Override
    protected void initialize() {                               // Overridden
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected MultiDataObject createMultiObject(final FileObject primaryFile)
            throws IOException {
        return new CPYDataObject(primaryFile, this);
    }

    @Override
    protected String actionsContext() {                         // Overridden
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
}
