/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

/**
 * This class represents output model.
 * @author karthikeyan s
 */
public class Output extends ServiceDescription {
    
    private String serviceName;
    
    private String portName;
    
    private String partnerLink;
    
    private String roleName;
    
    private String id;
    
    /** Creates a new instance of Output */
    public Output(String serviceName, String portName, String partnerLink, String roleName, String portType,
            String operation, String messageType, String id) {
        super(operation, portType, messageType);
        this.serviceName = serviceName;
        this.portName = portName;
        this.partnerLink = partnerLink;
        this.roleName = roleName;
        this.id = id;
    }
    
    public void setPartnerLink(String partnerLink) {
        this.partnerLink = partnerLink;
    }
    
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }
    
    public String getPartnerLink() {
        return this.partnerLink;
    }
    
    public String getRoleName() {
        return this.roleName;
    }
    
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
    
    public void setPortName(String portName) {
        this.portName = portName;
    }
    
    public void setId(String id) {
        this.id = id;
    }
    
    public String getServiceName() {
        return this.serviceName;
    }
    
    public String getPortName() {
        return this.portName;
    }
    
    public String getId() {
        return this.id;
    }
    
    public String toXmlString() {
        StringBuffer xmlString = new StringBuffer();
        //if(partnerLink != null && roleName != null && !partnerLink.equals("") && !roleName.equals("")) {
            xmlString.append("\t<" + AspectMap.OUTPUT_ELEMENT + " \n\t" + AspectMap.PARTNERLINK_ATTR + "=\""
                    + getPartnerLink() + "\" \n\t" + AspectMap.ROLE_NAME_ATTR + "=\"" +
                    getRoleName() + "\" \n\t" + AspectMap.PORTTYPE_ATTR + "=\"" + getPortType() + "\" \n\t" +
                    AspectMap.OPERATION_ATTR + "=\"" + getOperation() +"\" \n\t" + AspectMap.MESSAGE_TYPE_ATTR +
                    "=\"" + getMessageType() + "\" \n\t"+ AspectMap.ID_ATTR +"=\""+ getId() + "\" />");
//        } else {
//            xmlString.append("<" + AspectMap.OUTPUT_ELEMENT + " " + AspectMap.SERVICE_NAME_ATTR + "=\""
//                    + getServiceName() + "\" " + AspectMap.PORT_NAME_ATTR + "=\"" +
//                    getPortName() + "\" " + AspectMap.PORTTYPE_ATTR + "=\"" + getPortType() + "\" " +
//                    AspectMap.OPERATION_ATTR + "=\"" + getOperation() +"\" " + AspectMap.MESSAGE_TYPE_ATTR +
//                    "=\"" + getMessageType() + "\" "+ AspectMap.ID_ATTR +"=\""+ getId() + "\" />");
//        }
        return xmlString.toString();
    }
}