/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * This class abstracts the config tag and provides an object for the same.
 * 
 * @author karthikeyan s
 */
public class Config {

	private Map<String, String> properties = new HashMap<String, String>();

	/**
     * Creates a new instance of Config
     */
	public Config() {
	}

	public Map<String, String> getProperties() {
		return properties;
	}

	public void setProperties(String key, String value) {
		properties.put(key, value);
	}
        
        public void removeProperty(String key) {
            properties.remove(key);
        }

	public String toXMLString() {
		StringBuffer xmlString = new StringBuffer();
		if (properties.isEmpty()) {
			xmlString.append("\t<" + AspectConstants.CONFIG_TAG + "/>");
			return xmlString.toString();
		}
		xmlString.append("\t<" + AspectConstants.CONFIG_TAG + ">\n");
		Iterator it = properties.keySet().iterator();
		while (it.hasNext()) {
			String name = (String) it.next();
			String value = (String) properties.get(name);
			value = (value == null ? "" : value);
			xmlString.append("<" + AspectConstants.PROPERTY_TAG + " "
					+ AspectConstants.PROPERTY_ATTR_NAME + "=\"" + name + "\" "
					+ AspectConstants.PROPERTY_ATTR_VALUE + "=\"" + value
					+ "\"/>\n");
		}
		xmlString.append("\t</" + AspectConstants.CONFIG_TAG + ">");
		return xmlString.toString();
	}
}