/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph.panels;

//import org.netbeans.modules.aspect.editor.model.Input;
//import org.netbeans.modules.aspect.editor.model.Output;
import org.netbeans.modules.aspect.editor.jaxbmodel.InputType;
import org.netbeans.modules.aspect.editor.jaxbmodel.OutputType;
//import org.netbeans.modules.aspect.editor.model.ServiceDescription;

/**
 *
 * @author  karthikeyan s
 */
public class EditIOPropertiesPanel extends javax.swing.JPanel {
    
    /**
     * Creates new form EditIOPropertiesPanel
     */
    public EditIOPropertiesPanel() {
        initComponents();
    }
    
    public String getPartnerLink() {
        return partnerLink.getText().trim();
    }
    
    public String getRoleName() {
        return roleName.getText().trim();
    }
    
    public String getPortType() {
        return portType.getText().trim();
    }
    
    public String getMessageType() {
        return messageType.getText().trim();
    }
    
    public String getOperation() {
        return operation.getText().trim();
    }
    /* JAXB
    public void setProperties(ServiceDescription servDesc) {
        if(servDesc instanceof Input) {
            Input input = (Input)servDesc;
            partnerLink.setText(input.getPartnerLink());
            roleName.setText(input.getRoleName());
            messageType.setText(input.getMessageType());
            operation.setText(input.getOperation());
            portType.setText(input.getPortType());
        } else if(servDesc instanceof Output){
            Output output = (Output)servDesc;
            partnerLink.setText(output.getPartnerLink());
            roleName.setText(output.getRoleName());
            messageType.setText(output.getMessageType());
            operation.setText(output.getOperation());
            portType.setText(output.getPortType());            
        }
    }
    */

    public void setProperties(InputType input)
    {
            partnerLink.setText(input.getPartnerLink());
            roleName.setText(input.getRoleName());
            messageType.setText(input.getMessageType());
            operation.setText(input.getOperation());
            portType.setText(input.getPortType());        
    }

    public void setProperties(OutputType output)
    {
            partnerLink.setText(output.getServiceName());
            //roleName.setText(output.getRoleName());
            messageType.setText(output.getRequest().getMessageType());
            operation.setText(output.getOperation());
            portType.setText(output.getPortType());        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        partnerLink = new javax.swing.JTextField();
        roleName = new javax.swing.JTextField();
        portType = new javax.swing.JTextField();
        operation = new javax.swing.JTextField();
        messageType = new javax.swing.JTextField();

        jLabel2.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.jLabel2.text")); // NOI18N

        jLabel4.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.jLabel4.text")); // NOI18N

        jLabel5.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.jLabel5.text")); // NOI18N

        jLabel3.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.jLabel3.text")); // NOI18N

        jLabel1.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.jLabel1.text")); // NOI18N

        partnerLink.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.partnerLink.text")); // NOI18N

        roleName.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.roleName.text")); // NOI18N

        portType.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.portType.text")); // NOI18N

        operation.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.operation.text")); // NOI18N

        messageType.setText(org.openide.util.NbBundle.getMessage(EditIOPropertiesPanel.class, "EditIOPropertiesPanel.messageType.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel3)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel4)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel2)))
                .add(10, 10, 10)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(roleName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)
                    .add(partnerLink, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)
                    .add(portType, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)
                    .add(operation, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)
                    .add(messageType, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(partnerLink, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(roleName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(portType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(operation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(messageType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JLabel jLabel1;
    javax.swing.JLabel jLabel2;
    javax.swing.JLabel jLabel3;
    javax.swing.JLabel jLabel4;
    javax.swing.JLabel jLabel5;
    javax.swing.JTextField messageType;
    javax.swing.JTextField operation;
    javax.swing.JTextField partnerLink;
    javax.swing.JTextField portType;
    javax.swing.JTextField roleName;
    // End of variables declaration//GEN-END:variables
    
}
