/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html
 
 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */
package org.netbeans.modules.aspect.editor.graph;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import org.netbeans.modules.aspect.editor.graph.panels.ChooseOutputPanel;
import org.netbeans.modules.aspect.editor.graph.panels.ConfigureEndpointFromWSDLPanel;
import org.netbeans.modules.aspect.editor.graph.panels.EditIOPropertiesPanel;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.jaxbmodel.OutputType;
import org.netbeans.modules.aspect.editor.jaxbutils.Utiltools;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.model.Aspect;
import org.netbeans.modules.aspect.editor.model.Output;
import org.netbeans.modules.aspect.editor.model.Util;
/**
 *
 * @author karthikeyan s
 */
public class OutputPopupProvider implements PopupMenuProvider {
    
    private AspectEditorPane owner;
    /** Creates a new instance of OutputPopupProvider */
    public OutputPopupProvider(AspectEditorPane pane) {
        owner = pane;
    }
    
    public JPopupMenu getPopupMenu(final Widget widget, Point point) {
        JPopupMenu popupMenu = new JPopupMenu("OutputPopup");
        JMenuItem choose = new JMenuItem("Choose Output");
        choose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ChooseOutputPanel panel = new ChooseOutputPanel();
                //Aspect aspect = owner.getCurrentAspect(); JAXB
                AspectType aspect = owner.getCurrentAspect();
                //panel.populateOutputs(aspect); JAXB
                DialogDescriptor dd = new DialogDescriptor(panel, "Choose Output");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    //Output out = panel.getSelectedOutput(); JAXB
                    OutputType out = panel.getSelectedOutput();
                    //if(!out.getId().equals("1")) { JAXB
                    if(!out.getID().equals("1")) {
                        //Iterator it = Util.getSortedOutputList(owner.getCurrentAspect().getOutputs()).iterator(); //JAXB
                        Iterator it = Utiltools.getSortedOutputList(AspectMapBuilder.getAspectMapBuilder().getOutputList(owner.getCurrentAspect())).iterator();
                        while(it.hasNext()) {
                            //Output output = (Output)it.next(); JAXB
                            OutputType output = (OutputType)it.next();
                            output.setID(out.getID());
                            break;
                        }
                        //out.setId("1"); JAXB
                        out.setID("1");
                    }
                    owner.setCurrentAspect(aspect);
                }
            }
        });
        popupMenu.add(choose);
        
        JMenuItem edit = new JMenuItem("Edit Output Properties");
        edit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditIOPropertiesPanel panel = new EditIOPropertiesPanel();
                //Output out = (Output)owner.getModelForWidget(widget); JAXB
                OutputType out = (OutputType)owner.getModelForWidget(widget);
                panel.setProperties(out);
                DialogDescriptor dd = new DialogDescriptor(panel, "Edit Output");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    out.setServiceName(panel.getPartnerLink());
                    // out.setRoleName(panel.getRoleName()); JAXB
                    out.setPortType(panel.getPortType());
                    //out.setMessageType(panel.getMessageType()); JAXB
                        out.getRequest().setMessageType(panel.getMessageType());
                        out.getResponse().setMessageType(panel.getMessageType());
                    out.setOperation(panel.getOperation());
                    //owner.getCurrentAspect().addOutput(out); JAXB
                    //AspectMapBuilder.getAspectMapBuilder().addOutput(owner.getCurrentAspect(), out);
                    owner.setCurrentAspect(owner.getCurrentAspect());
                }
            }
        });
        popupMenu.add(edit);
        
        
        JMenuItem inputWsdl = new JMenuItem("Configure from WSDL");
        inputWsdl.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                boolean error = true;
                //Aspect aspect = null; JAXB
                AspectType aspect = null;
                ConfigureEndpointFromWSDLPanel panel = new ConfigureEndpointFromWSDLPanel(owner.getDataObject().getPrimaryFile().getPath());
                DialogDescriptor dd = new DialogDescriptor(panel, "Configure from WSDL");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    File file = panel.getSelectedFile();
                    try {
                        if(file == null) throw new Exception("No file received");
                        //String dir = owner.getDataObject().getPrimaryFile().getParent().getPath();
                        //File newFile = new File(dir, file.getName());
                        if(!file.exists()) {
                            throw new Exception("No such file exist: " + file.getAbsolutePath());
                            
                        }
                        
                        
                        aspect = setOutput(owner.getCurrentAspect(), file);
                        error = false;
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if(error) {
                        DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                                "Failed to import wsdl", NotifyDescriptor.INFORMATION_MESSAGE));
                    } else {
                        owner.setCurrentAspect(aspect);
                    }
                }
            }
        });
        
        popupMenu.add(inputWsdl);
        
        
        
        return popupMenu;
    }
    
    
    
    //private Aspect setOutput(Aspect aspect, File file) { JAXB
    private AspectType setOutput(AspectType aspect, File file) {
        try {
            URL u = null;
            try {
                u = new URL("file://" + file.getAbsolutePath());
            } catch (MalformedURLException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            
            
            
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            Definition defn = reader.readWSDL(u.getFile());
            
            //get the first message Type.
            Iterator it = defn.getMessages().keySet().iterator();
            String messageType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                messageType = ((Message) defn.getMessages().get(qName)).getQName().toString();
                break;
            }
            
            // get the first portType
            it = defn.getPortTypes().keySet().iterator();
            String portType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                portType = ((PortType) defn.getPortTypes().get(qName)).getQName().toString();
                break;
            }
            
            // get the first operation
            it = defn.getBindings().keySet().iterator();
            String operation = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                Binding binding = ((Binding) defn.getBindings().get(qName));
                operation = ((BindingOperation)binding.getBindingOperations().get(0)).
                        getOperation().getName();
                break;
            }
            
            String nmspace = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";
            String nm = null;
            it = defn.getNamespaces().keySet().iterator();
            while(it.hasNext()) {
                String key = (String)it.next();
                if(defn.getNamespace(key).equals(nmspace)) {
                    nm = key;
                    break;
                }
            }
            // get the first service name
            String serviceName = "";
            String roleName = "";
            it = defn.getExtensibilityElements().iterator();
            while(it.hasNext()) {
                UnknownExtensibilityElement extnElem = (UnknownExtensibilityElement)it.next();
                if(extnElem.getElement().getNodeName().equalsIgnoreCase(nm +
                        ":partnerLinkType")) {
                    serviceName = "{"+defn.getTargetNamespace()+"}"+ extnElem.getElement().getAttribute("name");
                    NodeList roleNames = extnElem.getElement().getElementsByTagName("*");
                    for(int i = 0; i < roleNames.getLength(); i++) {
                        if(roleNames.item(i).getNodeType() == Element.ELEMENT_NODE) {
                            Element roleNameElem = (Element) roleNames.item(i);
                            if(roleNameElem.getNodeName().equals( nm + ":role")) {
                                roleName = roleNameElem.getAttribute("name");
                                break;
                            }
                        }
                    }
                }
            }
            
            //Output co = aspect.getCurrentOutput(); JAXB
            OutputType co = AspectMapBuilder.getAspectMapBuilder().getCurrentOutput(aspect);
                        
            //Output o = new Output(null,null, serviceName, roleName, portType, operation, messageType,co.getId()); JAXB
            OutputType o = AspectMapBuilder.getAspectMapBuilder().createOutput(aspect, serviceName, roleName, portType, operation, messageType, co.getID());
            
            //aspect.setCurrentOutput(o); JAXB
            AspectMapBuilder.getAspectMapBuilder().setCurrentOutput(aspect, o);
        } catch (WSDLException ex) {
            ex.printStackTrace();
        }
        return aspect;
    }
    
}