/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import org.netbeans.modules.sql.framework.ui.JTabbedPaneWithCloseIcons;


/**
 * @author Ritesh Adval
 * @version $Revision: 1.2 $
 */
public class SQLOutputView extends JPanel {
        
    private class IFrameAdapter extends InternalFrameAdapter {
        public void internalFrameClosing(InternalFrameEvent e) {
            sqlView.hideSplitPaneView();
        }
    }

    private JDesktopPane deskTop;
    private JInternalFrame internalFrame;
    private IOutputViewContainer sqlView;
    private JTabbedPaneWithCloseIcons tabPane;

    /** Creates a new instance of SQLOutputView */
    public SQLOutputView(IOutputViewContainer view) {
        this.sqlView = view;
        deskTop = new JDesktopPane();
        this.setLayout(new BorderLayout());
        this.add(deskTop, BorderLayout.CENTER);

        tabPane = new JTabbedPaneWithCloseIcons();        
    }

    public void showIFrame() {
        try {
            URL frameImgUrl = SQLOutputView.class.getResource("/org/netbeans/modules/sql/framework/ui/resources/images/showOutput.png");

            internalFrame = new JInternalFrame("Output", true, true, false);
            internalFrame.setFrameIcon(new ImageIcon(frameImgUrl));

            IFrameAdapter adapter = new IFrameAdapter();
            internalFrame.addInternalFrameListener(adapter);
            internalFrame.getContentPane().add(tabPane);
            deskTop.add(internalFrame);

            internalFrame.pack();
            internalFrame.setMaximum(true);
            internalFrame.setVisible(true); //necessary as of 1.3
        } catch (java.beans.PropertyVetoException e) {
            e.printStackTrace();
        }

    }

    public void showView(Component c) {
        showIFrame();
        // we always show the iframe but if component is null
        // then we can not select it
        if (c == null) {
            return;
        }

        int tabIndex = tabPane.indexOfComponent(c); 
        if ( tabIndex == -1) {
            addView(c);
        }else{
        	tabPane.setTitleAt(tabIndex, c.getName());
        }

        tabPane.setSelectedComponent(c);        
    }

    private void addView(Component c) {
        tabPane.add(c.getName(), c);
    }  
}

