/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import java.util.LinkedList;
import javax.swing.JComponent;

import org.netbeans.modules.etl.codegen.DBConnectionDefinitionTemplate;
import org.netbeans.modules.jdbc.builder.DBMetaData;
import org.netbeans.modules.model.database.DBConnectionDefinition;
import org.netbeans.modules.sql.framework.common.jdbc.SQLDBConnectionDefinition;
import org.netbeans.modules.sql.framework.common.jdbc.SQLUtils;
import org.netbeans.modules.sql.framework.common.utils.DBExplorerConnectionUtil;
import org.netbeans.modules.sql.framework.common.utils.MonitorUtil;
import org.netbeans.modules.sql.framework.evaluators.database.DB;
import org.netbeans.modules.sql.framework.evaluators.database.DBFactory;
import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.evaluators.database.Statements;
import org.netbeans.modules.sql.framework.evaluators.database.axion.AxionDB;
import org.netbeans.modules.sql.framework.evaluators.database.axion.AxionPipelineStatements;
import org.netbeans.modules.sql.framework.evaluators.database.postgreSQL.PostgreSQLDB;
import org.netbeans.modules.sql.framework.evaluators.database.base.BaseStatements;
import org.netbeans.modules.sql.framework.evaluators.database.sybase.SybaseDB;
import org.netbeans.modules.sql.framework.model.RuntimeDatabaseModel;
import org.netbeans.modules.sql.framework.model.RuntimeInput;
import org.netbeans.modules.sql.framework.model.SQLConstants;
import org.netbeans.modules.sql.framework.model.SQLDBModel;
import org.netbeans.modules.sql.framework.model.SQLDBTable;
import org.netbeans.modules.sql.framework.model.SQLDefinition;
import org.netbeans.modules.sql.framework.model.SQLJoinOperator;
import org.netbeans.modules.sql.framework.model.SQLJoinView;
import org.netbeans.modules.sql.framework.model.SQLModelObjectFactory;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.model.SourceTable;
import org.netbeans.modules.sql.framework.model.TargetTable;
import org.netbeans.modules.sql.framework.ui.SwingWorker;
import org.netbeans.modules.sql.framework.ui.utils.AxionExternalConnectionProvider;
import org.netbeans.modules.sql.framework.ui.utils.UIUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.Message;
import org.openide.util.NbBundle;

import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.DBConstants;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.exception.DBSQLException;
import com.sun.sql.framework.utils.Logger;
import org.axiondb.ExternalConnectionProvider;

/**
 * TopComponent hosting display of design-level SQL test output.
 *
 * @author Ritesh Adval
 * @version $Revision: 1.6 $
 */
public abstract class DataOutputPanel extends JPanel {
    
    public static final String LOG_CATEGORY = DataOutputPanel.class.getName();
    
    public static final String ETL_MONITOR_DB_NAME = "MonitorDB";
    
    private String tbl;
    
    private Properties dbProps;
    
    private String schema;
    
    private String catalog;
    
    class QueryViewWorkerThread extends SwingWorker {
        DBConnectionFactory factory = DBConnectionFactory.getInstance();
        private SQLObject aTable;
        private Connection conn;
        private ResultSet cntRs;
        private Throwable ex;
        private PreparedStatement pstmt;
        private ResultSet rs;
        private Statement stmt;
        private boolean disableNavigation = false;
        
        public QueryViewWorkerThread(SQLObject table) {
            this.aTable = table;
        }
        
        public Object construct() {
            Boolean oldAutoCommitMode = null;
            if(aTable instanceof SQLDBTable) {
                try {
                    SQLDBTable outTable = (SQLDBTable) aTable;
                    tbl = outTable.getName();
                    schema = outTable.getSchema();
                    catalog = outTable.getCatalog();
                    SQLDBConnectionDefinition connDef = ((SQLDBModel) outTable.getParentObject()).getETLDBConnectionDefinition();
                    
                    Properties connProp = connDef.getConnectionProperties();
                    int srcType = factory.getDatabaseVersion(connProp);
                    DB db = DBFactory.getInstance().getDatabase(srcType);
                    
                    dbProps = connProp;
                    conn = DBExplorerConnectionUtil.createConnection(connProp);
                    if (db instanceof SybaseDB) {
                        oldAutoCommitMode = Boolean.valueOf(conn.getAutoCommit());
                        factory.setAutoCommit(conn, false);
                    }
                    
                    String resetFetchSizeSQL = null;
                    String dbName = outTable.getParent().getConnectionDefinition().getDBType();
                    if (SQLUtils.getSupportedDBType(dbName) == DBConstants.SYBASE) {
                        stmt = conn.createStatement();
                        stmt.execute("SET ROWCOUNT " + recordToRefresh);
                        resetFetchSizeSQL = "SET ROWCOUNT 0";
                    }
                    
                    // generate the select query
                    StatementContext context = new StatementContext();
                    
                    if (db instanceof AxionDB) {
                        String select = "Select * from "+((SQLDBTable)table).getName();
                        stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
                                ResultSet.CONCUR_READ_ONLY);
                        this.rs = stmt.executeQuery(select);
                        queryView.setEditable(false);
                        queryView.setResultSet(rs, recordToRefresh);
                        queryView.setSql(select);
                        queryView.setTableName(tbl);
                        queryView.setSchema(schema);
                        queryView.setCatalog(catalog);
                        this.rs.close();
                        stmt.close();
                    } else {
                        Object limit = (recordToRefresh == 0) ? "" : recordToRefresh;
                        context.putClientProperty("limit", limit);
                        
                        Statements stmts = db.getStatements();
                        
                        String sql = null;
                        if (outTable.getObjectType() == SQLConstants.SOURCE_TABLE) {
                            SQLPart sqlPart = stmts.getSelectStatement((SourceTable) outTable, context);
                            sql = sqlPart.getSQL();
                        } else {
                            SQLPart sqlPart = stmts.getSelectStatement((TargetTable) outTable, context);
                            sql = sqlPart.getSQL();
                        }
                        
                        // execute select and get result set
                        List paramList = new ArrayList();
                        Map attribMap = new HashMap();
                        RuntimeDatabaseModel runtimeModel = def.getRuntimeDbModel();
                        if (runtimeModel != null) {
                            RuntimeInput inputTable = runtimeModel.getRuntimeInput();
                            if (inputTable != null) {
                                attribMap = inputTable.getRuntimeAttributeMap();
                            }
                        }
                        
                        String psSql = SQLUtils.createPreparedStatement(sql, attribMap, paramList);
                        conn.setAutoCommit(false);
						if (dbName.equals("PostgreSQL")) {
                             pstmt = conn.prepareStatement(psSql, ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
                        }
                        else {
                        pstmt = conn.prepareStatement(psSql, ResultSet.TYPE_SCROLL_INSENSITIVE,
                                ResultSet.CONCUR_UPDATABLE, ResultSet.HOLD_CURSORS_OVER_COMMIT);
                        }                        
                        SQLUtils.populatePreparedStatement(pstmt, attribMap, paramList);
                        
                        Logger.print(Logger.DEBUG, DataOutputPanel.class.getName(), "Select statement used for show data:" + NL + sql);
                        
                        this.rs = pstmt.executeQuery();
                        queryView.setEditable(true);
                        queryView.setResultSet(rs, dbProps, maxRows, nowCount);
                        queryView.setSql(psSql);
                        queryView.setTableName(tbl);
                        queryView.setSchema(schema);
                        queryView.setCatalog(catalog);
                        this.rs.close();
                        pstmt.close();
                    }
                    //get the count of all rows
                    context.putClientProperty("limit", "");
                    SQLPart sqlPart = db.getStatements().getRowCountStatement(outTable, context);
                    String countSql = db.getStatements().normalizeSQLForExecution(sqlPart).getSQL();
                    Logger.print(Logger.DEBUG, DataOutputPanel.class.getName(), "Select count(*) statement used for total rows:" + NL + countSql);
                    
                    List paramList = new ArrayList();
                    Map attribMap = new HashMap();
                    RuntimeDatabaseModel runtimeModel = def.getRuntimeDbModel();
                    if (runtimeModel != null) {
                        RuntimeInput inputTable = runtimeModel.getRuntimeInput();
                        if (inputTable != null) {
                            attribMap = inputTable.getRuntimeAttributeMap();
                        }
                    }
                    paramList.clear();
                    String psSql = SQLUtils.createPreparedStatement(countSql, attribMap, paramList);
                    pstmt = conn.prepareStatement(psSql);
                    SQLUtils.populatePreparedStatement(pstmt, attribMap, paramList);
                    cntRs = pstmt.executeQuery();
                    
                    //set the count
                    setTotalCount(this.cntRs);
                    cntRs.close();
                    if (resetFetchSizeSQL != null) {
                        stmt.execute(resetFetchSizeSQL);
                    }
                } catch (Exception e) {
                    this.ex = e;
                    Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Can't get contents for table "
                            + ((aTable != null) ? aTable.getDisplayName() : ""), e);
                    queryView.clearView();
                    totalRowsLabel.setText("0");
                } finally {
                    if (null != oldAutoCommitMode && conn != null) {
                        try {
                            conn.setAutoCommit(oldAutoCommitMode.booleanValue());
                        } catch (SQLException ignore) {
                            // Ignore.
                        }
                    }
                }
            } else if(aTable instanceof SQLJoinView) {
                try {
                    // handle join data query here.
                    SQLJoinView joinView = (SQLJoinView) aTable;
                    Iterator it = joinView.getSourceTables().iterator();
                    
                    // check if source tables belong to the same database.
                    DBConnectionDefinition connDef = null;
                    DBConnectionDefinition tempDef = null;
                    boolean isSameDB = true;
                    while(it.hasNext()) {
                        SourceTable tbl = (SourceTable)it.next();
                        connDef = tbl.getParent().getConnectionDefinition();
                        if(tempDef == null) {
                            tempDef = connDef;
                        }
                        if(!connDef.getConnectionURL().equals(tempDef.getConnectionURL())) {
                            isSameDB = false;
                            break;
                        }
                    }
                    
                    String joinSql = "";
                    StringBuilder buf = null;
                    if(isSameDB) {
                        conn = DBExplorerConnectionUtil.createConnection(connDef.getDriverClass(),
                                connDef.getConnectionURL(), connDef.getUserName(), connDef.getPassword());
                        
                        // get the join data directly as join tables are from same db.
                        StatementContext context = new StatementContext();
                        DB db = DBFactory.getInstance().getDatabase(SQLUtils.getSupportedDBType(
                                connDef.getDBType()));
                        context.setUseSourceTableAliasName(true);
                        buf = new StringBuilder(db.getStatements().getSelectStatement(joinView, context).getSQL());
                        joinSql = joinSql + db.getEvaluatorFactory().evaluate(joinView.getRootJoin(), context);
                    } else {
                        // create dblinks to the source tables used in join and get join data.
                        try {
                            Thread.currentThread().getContextClassLoader().loadClass(AxionExternalConnectionProvider.class.getName());
                            System.setProperty(ExternalConnectionProvider.EXTERNAL_CONNECTION_PROVIDER_PROPERTY_NAME,
                                    AxionExternalConnectionProvider.class.getName());
                        } catch (ClassNotFoundException ex) {
                            //ignore
                        }
                        conn = DBExplorerConnectionUtil.createConnection("org.axiondb.jdbc.AxionDriver",
                                "jdbc:axiondb:joinview", "sa", "sa");
                        stmt = conn.createStatement();
                        it = joinView.getSourceTables().iterator();
                        
                        StatementContext joinContext = new StatementContext();
                        while(it.hasNext()) {
                            SourceTable table = (SourceTable)it.next();
                            AxionDB db = (AxionDB) DBFactory.getInstance().getDatabase(DBConstants.AXION);
                            DBConnectionDefinition connDefn = table.getParent().getConnectionDefinition();
                            
                            // create dblink to the database.
                            AxionPipelineStatements stmts = db.getAxionPipelineStatements();
                            String linkName = StringUtil.createSQLIdentifier(connDefn.getName());
                            String dbLinkSql = stmts.getCreateDBLinkStatement(connDefn, linkName).getSQL();
                            String dropDBLinkSql = stmts.getDropDBLinkStatement(linkName).getSQL();
                            
                            // create a fresh dblink. Drop old link if exists.
                            try {
                                stmt.execute(dropDBLinkSql);
                            } catch(SQLException ex) {
                                // link doesn't exist. Ignore
                            }
                            stmt.execute(dbLinkSql);
                            
                            // create remote table in axion.
                            StatementContext context = new StatementContext();
                            context.setUsingUniqueTableName(table, true);
                            context.setUsingFullyQualifiedTablePrefix(false);
                            String localName = db.getUnescapedName(db.getEvaluatorFactory().evaluate(table, context));
                            String remoteTableSql = stmts.getCreateRemoteTableStatement(table, localName,
                                    linkName).getSQL();
                            try {
                                stmt.execute(remoteTableSql);                            
                            } catch (SQLException ex) {
                                //table/view might exist. So ignore this.
                            }                            
                            
                            // add table properties to statementcontext.
                            joinContext.setUsingFullyQualifiedTablePrefix(false);
                            joinContext.setUsingUniqueTableName(table, true);
                        }
                        
                        // now construct the sql statement to get join data.
                        DB db = DBFactory.getInstance().getDatabase(DBConstants.AXION);
                        
                        joinContext.setUsingUniqueTableName(true);
                        buf = new StringBuilder(db.getStatements().getSelectStatement(
                                joinView, joinContext).getSQL());
                        joinSql = joinSql + db.getEvaluatorFactory().evaluate(joinView.getRootJoin(), joinContext);
                    }
                    
                    stmt = conn.createStatement();
                    this.rs = stmt.executeQuery(buf.toString().trim());
                    queryView.setEditable(false);
                    queryView.setResultSet(rs, recordToRefresh);
                    queryView.setSql(buf.toString().trim());
                    queryView.setTableName(joinView.getDisplayName());
                    queryView.setSchema("");
                    queryView.setCatalog("");                    
                    this.rs.close();
                    stmt.close();
                    try {                        
                        // set total count
                        this.cntRs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + joinSql.trim());
                        setTotalCount(this.cntRs);
                        cntRs.close();                    
                    } catch (SQLException ex) {
                        //ignore
                        // The above statement works only the first time. From next time onwards,
                        // it fails. But ignoring this for the time being as we already have the total count. 
                    }                    
                } catch (Exception ex) {
                    Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Can't get contents for table "
                            + ((aTable != null) ? aTable.getDisplayName() : ""), ex);
                    queryView.clearView();
                    totalRowsLabel.setText("0");
                }  finally {
                    if(conn != null) {
                        try {
                            conn.close();
                        } catch(SQLException e) {
                            Logger.print(Logger.ERROR, LOG_CATEGORY, null, ex);
                        }
                    }
                }
            } else if(aTable instanceof SQLJoinOperator) {
                try {
                    // handle join data query here.
                    SQLJoinOperator joinOperator = (SQLJoinOperator) aTable;
                    Iterator it = joinOperator.getAllSourceTables().iterator();
                    
                    // check if source tables belong to the same database.
                    DBConnectionDefinition connDef = null;
                    DBConnectionDefinition tempDef = null;
                    boolean isSameDB = true;
                    while(it.hasNext()) {
                        SourceTable tbl = (SourceTable)it.next();
                        connDef = tbl.getParent().getConnectionDefinition();
                        if(tempDef == null) {
                            tempDef = connDef;
                        }
                        if(!connDef.getConnectionURL().equals(tempDef.getConnectionURL())) {
                            isSameDB = false;
                            break;
                        }
                    }
                    
                    String joinSql = "";
                    StringBuilder buf = null;
                    if(isSameDB) {
                        conn = DBExplorerConnectionUtil.createConnection(connDef.getDriverClass(),
                                connDef.getConnectionURL(), connDef.getUserName(), connDef.getPassword());
                        
                        // get the join data directly as join tables are from same db.
                        StatementContext context = new StatementContext();
                        DB db = DBFactory.getInstance().getDatabase(SQLUtils.getSupportedDBType(
                                connDef.getDBType()));
                        context.setUseSourceTableAliasName(true);
                        buf = new StringBuilder(db.getStatements().getSelectStatement(
                                joinOperator, context).getSQL());
                        joinSql = joinSql + db.getEvaluatorFactory().evaluate(joinOperator, context);
                    } else {
                        // create dblinks to the source tables used in join and get join data.
                        try {
                            Thread.currentThread().getContextClassLoader().loadClass(AxionExternalConnectionProvider.class.getName());
                            System.setProperty(ExternalConnectionProvider.EXTERNAL_CONNECTION_PROVIDER_PROPERTY_NAME,
                                    AxionExternalConnectionProvider.class.getName());
                        } catch (ClassNotFoundException ex) {
                            //ignore
                        }
                        conn = DBExplorerConnectionUtil.createConnection("org.axiondb.jdbc.AxionDriver",
                                "jdbc:axiondb:joinview", "sa", "sa");
                        stmt = conn.createStatement();
                        it = joinOperator.getAllSourceTables().iterator();
                        
                        StatementContext joinContext = new StatementContext();
                        while(it.hasNext()) {
                            SourceTable table = (SourceTable)it.next();
                            AxionDB db = (AxionDB) DBFactory.getInstance().getDatabase(DBConstants.AXION);
                            DBConnectionDefinition connDefn = table.getParent().getConnectionDefinition();
                            
                            // create dblink to the database.
                            AxionPipelineStatements stmts = db.getAxionPipelineStatements();
                            String linkName = StringUtil.createSQLIdentifier(connDefn.getName());
                            String dbLinkSql = stmts.getCreateDBLinkStatement(connDefn, linkName).getSQL();
                            String dropDBLinkSql = stmts.getDropDBLinkStatement(linkName).getSQL();
                            
                            // create a fresh dblink. Drop old link if exists.
                            try {
                                stmt.execute(dropDBLinkSql);
                            } catch(SQLException ex) {
                                // link doesn't exist. Ignore
                            }
                            stmt.execute(dbLinkSql);
                            
                            // create remote table in axion.
                            StatementContext context = new StatementContext();
                            context.setUsingUniqueTableName(table, true);
                            context.setUsingFullyQualifiedTablePrefix(false);
                            String localName = db.getUnescapedName(db.getEvaluatorFactory().evaluate(table, context));
                            String remoteTableSql = stmts.getCreateRemoteTableStatement(table, localName,
                                    linkName).getSQL();
                            try {
                                stmt.execute(remoteTableSql);                            
                            } catch (SQLException ex) {
                                //table/view might exist. So ignore this.
                            }                            
                            
                            // add table properties to statementcontext.
                            joinContext.setUsingFullyQualifiedTablePrefix(false);
                            joinContext.setUsingUniqueTableName(table, true);
                        }
                        
                        // now construct the sql statement to get join data.
                        DB db = DBFactory.getInstance().getDatabase(DBConstants.AXION);
                        
                        joinContext.setUsingUniqueTableName(true);
                        buf = new StringBuilder(db.getStatements().getSelectStatement(
                                joinOperator, joinContext).getSQL());
                        joinSql = joinSql + db.getEvaluatorFactory().evaluate(joinOperator, joinContext);
                    }
                    
                    stmt = conn.createStatement();
                    this.rs = stmt.executeQuery(buf.toString().trim());
                    queryView.setEditable(false);
                    queryView.setResultSet(rs, recordToRefresh);
                    queryView.setSql(buf.toString().trim());
                    queryView.setTableName(joinOperator.getDisplayName());
                    queryView.setSchema("");
                    queryView.setCatalog("");                    
                    this.rs.close();
                    stmt.close();
                    try {                        
                        // set total count
                        this.cntRs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + joinSql.trim());
                        setTotalCount(this.cntRs);
                        cntRs.close();                    
                    } catch (SQLException ex) {
                        //ignore
                        // The above statement works only the first time. From next time onwards,
                        // it fails. But ignoring this for the time being as we already have the total count. 
                    }                    
                } catch (Exception ex) {
                    Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Can't get contents for table "
                            + ((aTable != null) ? aTable.getDisplayName() : ""), ex);
                    queryView.clearView();
                    totalRowsLabel.setText("0");
                }  finally {
                    if(conn != null) {
                        try {
                            conn.close();
                        } catch(SQLException e) {
                            Logger.print(Logger.ERROR, LOG_CATEGORY, null, ex);
                        }
                    }
                }
            }
            return "";
        }
        
        //Runs on the event-dispatching thread.
        public void finished() {
            try {
                if (this.ex != null) {
                    String errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_error_fetch_failed", aTable.getDisplayName(),
                            this.ex.getMessage());
                    DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.ERROR_MESSAGE));
                }
                UIUtil.stopProgressDialog();
                if (truncateButton != null) {
                    truncateButton.setEnabled(true);
                }
                refreshButton.setEnabled(true);
                refreshField.setEnabled(true);
                if(this.aTable instanceof SQLDBTable) {
                    if(!(((SQLDBTable)this.aTable).getParent().getConnectionDefinition()
                    .getDBType().equals(DBMetaData.AXION))) {
                        if(((nowCount - maxRows) > 0) && (totalCount != 0)) {
                            first.setEnabled(true);
                            previous.setEnabled(true);
                        }
                        if (((nowCount + maxRows) <= totalCount) && (totalCount != 0)) {
                            next.setEnabled(true);
                            last.setEnabled(true);
                        }
                        if ((nowCount - maxRows) <= 0) {
                            first.setEnabled(false);
                            previous.setEnabled(false);
                        }
                        if ((nowCount + maxRows) > totalCount) {
                            next.setEnabled(false);
                            last.setEnabled(false);
                        }
                        if(maxRows > totalCount) {
                            maxRows = totalCount;
                            refreshField.setText(String.valueOf(maxRows));
                        }
                        if(totalCount != 0 && maxRows != 0) {
                            deleteRow.setEnabled(true);
                        } else {
                            deleteRow.setEnabled(false);
                        }
                        insert.setEnabled(true);
                    } else {
                        // getRow() in axion result is not working.
                        // Exception thrown when trying to set startFrom param.
                        // So disable traversal buttons.
                        first.setEnabled(false);
                        next.setEnabled(false);
                        last.setEnabled(false);
                        previous.setEnabled(false);
                        commit.setEnabled(false);
                        deleteRow.setEnabled(false);
                        insert.setEnabled(false);
                    }
                } else {
                    first.setEnabled(false);
                    next.setEnabled(false);
                    last.setEnabled(false);
                    previous.setEnabled(false);
                    commit.setEnabled(false);
                    deleteRow.setEnabled(false);
                    insert.setEnabled(false);
                }
                int endCount = nowCount + maxRows - 1;
                if((nowCount + maxRows - 1) > totalCount) {
                    endCount = totalCount;
                }
                if(totalCount == 0) {
                    nowCount = 0;
                    endCount = 0;
                }
                refreshField.setText("" + maxRows);
                queryView.revalidate();
                queryView.repaint();
            } finally {
                factory.closeDBResources(null, stmt, null);
                if(conn != null) {
                    try {
                        conn.close();
                    } catch(SQLException ex) {
                        //ignore
                    }
                }
            }
        }
    }
    
    static class RejectedRows extends DataOutputPanel {
        public RejectedRows(SQLObject etlObject, SQLDefinition sqlDefinition) {
            super(etlObject, sqlDefinition, false);
        }
        
        public void generateResult() {
            generateResult(this.table);
        }
        
        public void generateResult(SQLObject aTable) {
            this.table = aTable;
            this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_rejected_data", table.getDisplayName()));
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_LoadData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_LoadProgress");
            UIUtil.startProgressDialog(title, msg);
            generateRejectionTableData();
        }
        
        //  select all columns and rows and show to the user
        private void generateRejectionTableData() {
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            
            RejectionViewWorkerThread rejectionQueryThread = new RejectionViewWorkerThread(table);
            rejectionQueryThread.start();
        }
    }
    
    class RejectionViewWorkerThread extends SwingWorker {
        DBConnectionFactory factory = DBConnectionFactory.getInstance();
        private SQLObject aTable;
        private Connection conn;
        private Throwable ex;
        private PreparedStatement pstmt;
        private ResultSet rs;
        private Statement stmt;
        
        public RejectionViewWorkerThread(SQLObject table) {
            this.aTable = table;
        }
        
        public Object construct() {
            try {
                SQLDBConnectionDefinition conDef;
                
                TargetTable outTable = (TargetTable) aTable;
                TargetTable clone = SQLModelObjectFactory.getInstance().createTargetTable(outTable);
                clone.setTablePrefix(MonitorUtil.LOG_DETAILS_TABLE_PREFIX);
                
                DBConnectionDefinitionTemplate connTemplate = new DBConnectionDefinitionTemplate();
                conDef = connTemplate.getDBConnectionDefinition("AXIONMEMORYDB");
                
                Map connParams = new HashMap();
                connParams.put(DBConnectionDefinitionTemplate.KEY_DATABASE_NAME, ETL_MONITOR_DB_NAME);
                conDef.setConnectionURL(StringUtil.replace(conDef.getConnectionURL(), connParams));
                DB db = DBFactory.getInstance().getDatabase(DB.AXIONDB);
                
                Properties connProps = conDef.getConnectionProperties();
                conn = factory.getConnection(connProps);
                stmt = conn.createStatement();
                
                StatementContext context = new StatementContext();
                context.setUsingFullyQualifiedTablePrefix(false);
                context.setUsingUniqueTableName(true);
                Object limit = (recordToRefresh == 0) ? "" : Integer.toString(recordToRefresh);
                context.putClientProperty("limit", limit);
                
                SQLPart sqlPart = db.getStatements().getSelectStatement(clone, context);
                String sql = sqlPart.getSQL();
                
                // execute select and get result set
                List paramList = new ArrayList();
                Map attribMap = new HashMap();
                RuntimeDatabaseModel runtimeModel = def.getRuntimeDbModel();
                if (runtimeModel != null) {
                    RuntimeInput inputTable = runtimeModel.getRuntimeInput();
                    if (inputTable != null) {
                        attribMap = inputTable.getRuntimeAttributeMap();
                    }
                }
                
                String psSql = SQLUtils.createPreparedStatement(sql, attribMap, paramList);
                pstmt = conn.prepareStatement(psSql);
                SQLUtils.populatePreparedStatement(pstmt, attribMap, paramList);
                
                Logger.print(Logger.DEBUG, DataOutputPanel.class.getName(), "Select statement used for show data:" + NL + sql);
                this.rs = pstmt.executeQuery();
                queryView.setResultSet(rs, maxRows);
                pstmt.close();
                queryView.setEditable(false);
                //get the count of all rows
                sqlPart = db.getStatements().getRowCountStatement(clone, context);
                String countSql = db.getStatements().normalizeSQLForExecution(sqlPart).getSQL();
                Logger.print(Logger.DEBUG, DataOutputPanel.class.getName(), "Select count(*) statement used for total rows:" + NL + countSql);
                
                paramList.clear();
                psSql = SQLUtils.createPreparedStatement(countSql, attribMap, paramList);
                pstmt = conn.prepareStatement(psSql);
                SQLUtils.populatePreparedStatement(pstmt, attribMap, paramList);
                ResultSet cntRs = pstmt.executeQuery();
                
                //set the count
                setTotalCount(cntRs);
                cntRs.close();
            } catch (Exception e) {
                this.ex = e;
                Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Can't get contents for table "
                        + ((aTable != null) ? aTable.getDisplayName() : ""), e);
                queryView.clearView();
                totalRowsLabel.setText("0");
            }
            
            return "";
        }
        
        //Runs on the event-dispatching thread.
        public void finished() {
            if (this.ex != null) {
                String errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_error_fetch_failed", aTable.getDisplayName(), ex.getMessage());
                
                // If rejection table does not exist, show a brief user-friendly message
                // that doesn't include a stack trace.
                if (ex instanceof SQLException && "42704".equals(((SQLException) ex).getSQLState())) {
                    errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_no_rejection_data", aTable.getDisplayName());
                }
                
                DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
            }
            
            if (truncateButton != null) {
                truncateButton.setEnabled(true);
            }
            refreshButton.setEnabled(true);
            refreshField.setEnabled(true);
            if((nowCount - maxRows) > 0) {
                first.setEnabled(true);
                previous.setEnabled(true);
            }
            if ((nowCount + maxRows) <= totalCount) {
                next.setEnabled(true);
                last.setEnabled(true);
            }
            if ((nowCount - maxRows) <= 0) {
                first.setEnabled(false);
                previous.setEnabled(false);
            }
            if ((nowCount + maxRows) > totalCount) {
                next.setEnabled(false);
                last.setEnabled(false);
            }
            insert.setEnabled(false);
            deleteRow.setEnabled(false);
            commit.setEnabled(false);
            int endCount = nowCount + maxRows - 1;
            if((nowCount + maxRows - 1) > totalCount) {
                endCount = totalCount;
            }
            if(totalCount == 0) {
                nowCount = 0;
                endCount = 0;
            }
            refreshField.setText("" + maxRows);
            commit.setEnabled(false);
            queryView.repaint();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                
                if (stmt != null) {
                    stmt.close();
                }
            } catch (SQLException sqle) {
                Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null,
                        "Could not close statement after retrieving aTable contents.", sqle);
            } finally {
                if (conn != null) {
                    factory.closeConnection(conn);
                    conn = null;
                    UIUtil.stopProgressDialog();
                }
            }
        }
    }
    
    public static class SourceQuery extends DataOutputPanel {
        public SourceQuery(SourceTable etlObject, SQLDefinition sqlDefinition) {
            super(etlObject, sqlDefinition, false);
        }
        
        public void generateResult() {
            generateResult(this.table);
        }
        
        public void generateResult(SQLObject aTable) {
            this.table = aTable;
            this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_data", table.getDisplayName()));
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_LoadData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_LoadProgress");
            UIUtil.startProgressDialog(title, msg);
            generateSelectAllTableData();
        }
        
        //select all columns and rows and show to the user
        private void generateSelectAllTableData() {
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            QueryViewWorkerThread queryThread = new QueryViewWorkerThread(table);
            queryThread.start();
        }
    }
    
    public static class TargetQuery extends DataOutputPanel {
        public TargetQuery(TargetTable etlObject, SQLDefinition sqlDefinition) {
            super(etlObject, sqlDefinition, true);
        }
        
        public void generateResult() {
            generateResult(this.table);
        }
        
        public void generateResult(SQLObject aTable) {
            this.table = aTable;
            this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_result", table.getDisplayName()));
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_LoadData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_LoadProgress");
            UIUtil.startProgressDialog(title, msg);
            generateTargetTableData();
        }
        
        private void generateTargetTableData() {
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            QueryViewWorkerThread queryThread = new QueryViewWorkerThread(table);
            queryThread.start();
        }
    }
    
    public static class JoinViewQuery extends DataOutputPanel {
        public JoinViewQuery(SQLJoinView etlObject, SQLDefinition sqlDefinition) {
            super(etlObject, sqlDefinition, false);
        }
        
        public void generateResult() {
            generateResult(this.table);
        }
        
        public void generateResult(SQLObject aTable) {
            this.table = aTable;
            this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_data", table.getDisplayName()));
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_LoadData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_LoadProgress");
            UIUtil.startProgressDialog(title, msg);
            generateSelectAllTableData();
        }
        
        //select all columns and rows and show to the user
        private void generateSelectAllTableData() {
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            QueryViewWorkerThread queryThread = new QueryViewWorkerThread(table);
            queryThread.start();
        }
    }
    
    public static class JoinOperatorQuery extends DataOutputPanel {
        public JoinOperatorQuery(SQLJoinOperator etlObject, SQLDefinition sqlDefinition) {
            super(etlObject, sqlDefinition, false);
        }
        
        public void generateResult() {
            generateResult(this.table);
        }
        
        public void generateResult(SQLObject aTable) {
            this.table = aTable;
            this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_data", table.getDisplayName()));
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_LoadData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_LoadProgress");
            UIUtil.startProgressDialog(title, msg);
            generateSelectAllTableData();
        }
        
        //select all columns and rows and show to the user
        private void generateSelectAllTableData() {
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            QueryViewWorkerThread queryThread = new QueryViewWorkerThread(table);
            queryThread.start();
        }
    }    
    
    private class TruncateAction extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            String confirmMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_confirm_truncate_table", table.getDisplayName());
            NotifyDescriptor nd = new NotifyDescriptor.Confirmation(confirmMsg, NotifyDescriptor.OK_CANCEL_OPTION, NotifyDescriptor.WARNING_MESSAGE);
            
            if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
            
            String title = NbBundle.getMessage(BasicTopView.class, "MSG_TruncateData");
            String msg = NbBundle.getMessage(BasicTopView.class, "MSG_TruncateProgress");
            UIUtil.startProgressDialog(title, msg);
            
            if (truncateButton != null) {
                truncateButton.setEnabled(false);
            }
            
            refreshButton.setEnabled(false);
            refreshField.setEnabled(false);
            TruncateTargetTableWorkerThread tThread = new TruncateTargetTableWorkerThread(table);
            tThread.start();
        }
    }
    
    private class TruncateTargetTableWorkerThread extends SwingWorker {
        private ResultSet cntRs;
        private SQLPart defragStmtPart;
        private Throwable ex;
        private DBConnectionFactory factory = DBConnectionFactory.getInstance();
        private Statement stmtCount;
        private SQLObject tTable;
        private Connection conn;
        
        public TruncateTargetTableWorkerThread(SQLObject table) {
            this.tTable = table;
        }
        
        public Object construct() {
            SQLDBTable aTable = (SQLDBTable) tTable;
            try {
                SQLDBConnectionDefinition connDef = ((SQLDBModel) aTable.getParentObject()).getETLDBConnectionDefinition();
                
                Properties connProps = connDef.getConnectionProperties();
                conn = factory.getConnection(connProps);
                conn.setAutoCommit(true);
                Statement stmt = conn.createStatement();
                
                // Generate the truncate command
                DB db = DBFactory.getInstance().getDatabase(factory.getDatabaseVersion(connProps));
                if(db instanceof AxionDB) {
                    insert.setEnabled(false);
                } else {
                    insert.setEnabled(true);
                }
                Statements stmts = db.getStatements();
                StatementContext context = new StatementContext();
                TargetTable tt = (TargetTable) aTable;
                
                //SQLPart sqlPart = stmts.getTruncateStatement(tt, context);
                SQLPart sqlPart = stmts.getTruncateStatement(aTable, context);
                String sqlList = sqlPart.getSQL();
                
                Iterator stmtIter = StringUtil.createStringListFrom(sqlList, SQLPart.STATEMENT_SEPARATOR).iterator();
                
                while (stmtIter.hasNext()) {
                    String sql = (String) stmtIter.next();
                    stmt.executeUpdate(sql);
                }
                stmt.close();
                
                // Get the count of all rows
                stmtCount = conn.createStatement();
                SQLPart cntSqlPart = db.getStatements().getRowCountStatement(tt, context);
                String countSql = cntSqlPart.getSQL();
                this.cntRs = stmtCount.executeQuery(countSql);
            } catch (Exception t) {
                this.ex = t;
                com.sun.sql.framework.utils.Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null,
                        "Could not truncate output for target aTable.", t);
            }
            
            return "";
        }
        
        //Runs on the event-dispatching thread.
        public void finished() {
            UIUtil.stopProgressDialog();
            if (this.ex != null) {
                String errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_error_truncate_failed", tTable.getDisplayName(), ex.getMessage());
                DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.ERROR_MESSAGE));
            } else {
                String informMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_inform_table_truncated", tTable.getDisplayName());
                DialogDisplayer.getDefault().notify(new Message(informMsg, NotifyDescriptor.INFORMATION_MESSAGE));
            }
            
            if (truncateButton != null) {
                truncateButton.setEnabled(true);
            }
            refreshButton.setEnabled(true);
            refreshField.setEnabled(true);
            //set the count
            setTotalCount(this.cntRs);
            first.setEnabled(false);
            previous.setEnabled(false);
            next.setEnabled(false);
            last.setEnabled(false);
            deleteRow.setEnabled(false);
            commit.setEnabled(false);
            if (queryView != null) {
                queryView.clearView();
            }
            
            if (conn != null) {
                try {
                    if (cntRs != null) {
                        cntRs.close();
                    }
                    
                    if (stmtCount != null) {
                        stmtCount.close();
                    }
                    
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    
                    if (defragStmtPart != null) {
                        factory.shutdown(conn, true, defragStmtPart.getSQL());
                    } else {
                        factory.shutdown(conn, false, null);
                    }
                } catch (Exception t) {
                    Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null,
                            "Could not commit truncate action for target aTable...", t);
                } finally {                    
                    queryView.revalidate();
                    queryView.repaint();
                    //RIT do not close connection which is now db explorer connection
//                    factory.closeConnection(conn);
                }
            }
        }
    }
    
    private static final String NL = System.getProperty("line.separator", "\n");
    
    protected SQLDefinition def;
    protected JButton refreshButton;
    protected JLabel countField;
    // We need this member only when refresh button is pressed.
    protected SQLObject table;
    protected JButton truncateButton;
    private JButton next;
    private JButton last;
    private JButton previous;
    private JButton first;
    protected JButton commit;
    private JButton deleteRow;
    private JButton insert;
    private JButton add;
    private JLabel limitRow;
    protected JTextField refreshField;
    
    private ResultSetTablePanel queryView;
    
    private int recordToRefresh = 10;
    
    private int maxRows = 10;
    
    private JToolBar toolbar;
    
    private JLabel totalRowsLabel;
    
    private JLabel errorMsg;
    
    private int totalCount;
    
    private int nowCount = 1;
    
    /**
     * Creates a new instance of DataOutputPanel with the associated instance of
     * SQLDefinition.
     *
     * @param etlDefinition SQLDefinition instance to associate
     */
    protected DataOutputPanel(SQLObject etlObject, SQLDefinition sqlDefinition, boolean showTruncate) {
        this.table = etlObject;
        this.def = sqlDefinition;
        
        //do not show tab view if there is only one tab
        putClientProperty("TabPolicy", "HideWhenAlone"); //NOI18N
        putClientProperty("PersistenceType", "Never"); //NOI18N
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage(DataOutputPanel.class, "LBL_tab_output", sqlDefinition.getDisplayName()));
        
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gl);
        
        //toolbar panel
        toolbar = new JToolBar();
        toolbar.setFloatable(false);
        
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = GridBagConstraints.NONE;
        c.gridwidth = GridBagConstraints.RELATIVE;
        c.anchor = GridBagConstraints.FIRST_LINE_START;
        panel.add(toolbar, c);
        
        URL url = null;
        
        if (showTruncate) {
            //create truncate button
            TruncateAction truncAction = new TruncateAction();
            truncAction.putValue(Action.SHORT_DESCRIPTION, NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_truncate"));
            url = getClass().getResource("/org/netbeans/modules/sql/framework/ui/resources/images/table_truncate.png");
            truncAction.putValue(Action.SMALL_ICON, new ImageIcon(url));
            //add truncate button
            truncateButton = new JButton(truncAction);
            toolbar.add(truncateButton);
            toolbar.addSeparator(new Dimension(10, 10));
        }
        
        
        ActionListener aListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src.equals(refreshButton)) {
                    refreshActionPerformed();
                } else if(src.equals(first)) {
                    firstActionPerformed();
                } else if(src.equals(last)) {
                    lastActionPerformed();
                } else if(src.equals(next)) {
                    nextActionPerformed();
                } else if(src.equals(previous)) {
                    previousActionPerformed();
                } else if(src.equals(refreshField)) {
                    setMaxActionPerformed();
                } else if(src.equals(commit)) {
                    commitActionPerformed();
                } else if(src.equals(deleteRow)) {
                    deleteRecordActionPerformed();
                } else if(src.equals(insert)) {
                    insertActionPerformed();
                }
            }
        };
        
        //add refresh button
        url = getClass().getResource("/org/netbeans/modules/sql/framework/ui/resources/images/refresh16.png");
        refreshButton = new JButton(new ImageIcon(url));
        refreshButton.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_refresh"));
        refreshButton.addActionListener(aListener);
        toolbar.add(refreshButton);
        toolbar.addSeparator(new Dimension(10, 10));
        
        //add limit row label
        limitRow = new JLabel(NbBundle.getMessage(DataOutputPanel.class, "LBL_max_rows"));
        limitRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add(limitRow);
        
        //add refresh text field
        refreshField = new JTextField();
        refreshField.setText("" + recordToRefresh);
        refreshField.setPreferredSize(new Dimension(30, refreshField.getHeight()));
        refreshField.setSize(30, refreshField.getHeight());
        refreshField.addKeyListener(new KeyAdapter() {
            public void keyTyped(KeyEvent evt) {
                if (refreshField.getText().length() >= 3)
                    evt.consume();
            }
        });
        refreshField.addActionListener(aListener);
        toolbar.add(refreshField);
        
        JLabel totalRowsNameLabel = new JLabel(NbBundle.getMessage(DataOutputPanel.class, "LBL_total_rows"));
        totalRowsNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add(totalRowsNameLabel);
        totalRowsLabel = new JLabel();
        //totalRowsLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add(totalRowsLabel);
        toolbar.addSeparator(new Dimension(10, 10));
        
        // add navigation buttons
        first = new JButton("<< FIRST");
        first.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_first"));
        first.addActionListener(aListener);
        first.setEnabled(false);
        toolbar.add(first);
        toolbar.addSeparator(new Dimension(10, 10));
        
        previous = new JButton("< PREVIOUS");
        previous.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_previous"));
        previous.addActionListener(aListener);
        previous.setEnabled(false);
        toolbar.add(previous);
        toolbar.addSeparator(new Dimension(10, 10));
        
        next = new JButton("NEXT >");
        next.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_next"));
        next.addActionListener(aListener);
        next.setEnabled(false);
        toolbar.add(next);
        toolbar.addSeparator(new Dimension(10, 10));
        
        last = new JButton("LAST >>");
        last.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_last"));
        last.addActionListener(aListener);
        last.setEnabled(false);
        toolbar.add(last);
        toolbar.addSeparator(new Dimension(10, 10));
        
        insert = new JButton("INSERT");
        insert.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_insert"));
        insert.addActionListener(aListener);
        insert.setEnabled(false);
        toolbar.add(insert);
        toolbar.addSeparator(new Dimension(10, 10));
        
        deleteRow = new JButton("DELETE");
        deleteRow.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_deleterow"));
        deleteRow.addActionListener(aListener);
        deleteRow.setEnabled(false);
        toolbar.add(deleteRow);
        toolbar.addSeparator(new Dimension(10, 10));
        
        commit = new JButton("COMMIT");
        commit.setToolTipText(NbBundle.getMessage(DataOutputPanel.class, "TOOLTIP_commit"));
        commit.addActionListener(aListener);
        commit.setEnabled(false);
        toolbar.add(commit);
        toolbar.addSeparator(new Dimension(10, 10));
        
        //add panel
        this.add(panel, BorderLayout.NORTH);
        
        //add query view
        queryView = new ResultSetTablePanel(this);
        this.add(queryView, BorderLayout.CENTER);
    }
    
    public abstract void generateResult();
    
    public abstract void generateResult(SQLObject aTable);
    
    protected void refreshActionPerformed() {
        int intVal = totalCount;
        if (intVal <= 0) {
            String errorMsg = NbBundle.getMessage(DataOutputPanel.class, "MSG_error_bad_limit", table.getDisplayName());
            DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
            
            return;
        }
        
        recordToRefresh = intVal;
        
        // Delegate to concrete class implementation.
        generateResult(this.table);
    }
    
    protected void setMaxActionPerformed() {
        try {
            maxRows = Integer.parseInt(refreshField.getText().trim());
        } catch (NumberFormatException ex) {
            if(totalCount < 999) {
                maxRows = totalCount;
            } else {
                maxRows = 999;
            }
        }
        nowCount = 1;
        if(maxRows > totalCount) {
            maxRows = totalCount;
        }
        recordToRefresh = nowCount + maxRows - 1;
        if(recordToRefresh > totalCount) {
            recordToRefresh = totalCount;
        }
        // Delegate to concrete class implementation.
        generateResult(this.table);
    }
    
    protected void firstActionPerformed() {
        boolean doCalculation = true;
        if(commit.isEnabled()) {
            String msg = "You have uncommited Changes in this page. If you continue, you changes will be lost. Do you still want to continue?";
            NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg, "Confirm navigation", NotifyDescriptor.YES_NO_OPTION);
            if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.NO_OPTION) {
                doCalculation = false;
            }
        }
        if(doCalculation) {
            nowCount = 1;
            recordToRefresh = nowCount + maxRows - 1;
            if(recordToRefresh > totalCount) {
                recordToRefresh = totalCount;
            }
            commit.setEnabled(false);
            this.queryView.setDirtyStatus(false);
            // Delegate to concrete class implementation.
            generateResult(this.table);
        }
    }
    
    protected void previousActionPerformed() {
        boolean doCalculation = true;
        if(commit.isEnabled()) {
            String msg = "You have uncommited Changes in this page. If you continue, you changes will be lost. Do you still want to continue?";
            NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg, "Confirm navigation", NotifyDescriptor.YES_NO_OPTION);
            if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.NO_OPTION) {
                doCalculation = false;
            }
        }
        if(doCalculation) {
            nowCount -=maxRows;
            recordToRefresh = nowCount + maxRows - 1;
            commit.setEnabled(false);
            this.queryView.setDirtyStatus(false);
            // Delegate to concrete class implementation.
            generateResult(this.table);
        }
    }
    
    protected void nextActionPerformed() {
        boolean doCalculation = true;
        if(commit.isEnabled()) {
            String msg = "You have uncommited Changes in this page. If you continue, your changes will be lost. Do you still want to continue?";
            NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg, "Confirm navigation", NotifyDescriptor.YES_NO_OPTION);
            if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.NO_OPTION) {
                doCalculation = false;
            }
        }
        if(doCalculation) {
            nowCount +=maxRows;
            recordToRefresh = nowCount + maxRows - 1;
            // Delegate to concrete class implementation.
            commit.setEnabled(false);
            this.queryView.setDirtyStatus(false);
            generateResult(this.table);
        }
    }
    
    protected void lastActionPerformed() {
        boolean doCalculation = true;
        if(commit.isEnabled()) {
            String msg = "You have uncommited Changes in this page. If you continue, your changes will be lost. Do you still want to continue?";
            NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg, "Confirm navigation", NotifyDescriptor.YES_NO_OPTION);
            if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.NO_OPTION) {
                doCalculation = false;
            }
        }
        if(doCalculation) {
            try {
                nowCount = totalCount - maxRows + 1;
            } finally {
            }
            recordToRefresh = totalCount;
            commit.setEnabled(false);
            this.queryView.setDirtyStatus(false);
            // Delegate to concrete class implementation.
            generateResult(this.table);
        }
    }
    
    protected void commitActionPerformed() {
        String errorMsg = "";
        String updateStmt = "";
        String alternateUpdateStmt = "";
        if((((SQLDBTable)this.table).getSchema()) == null ||
                (((SQLDBTable)this.table).getSchema().equals(""))) {
            updateStmt = updateStmt + "UPDATE \"" + tbl + "\"";
            alternateUpdateStmt = alternateUpdateStmt + "UPDATE '" + tbl + "'";
        } else {
            updateStmt = updateStmt + "UPDATE \"" + ((SQLDBTable)this.table).getSchema() + "\".\"" + tbl + "\"";
            alternateUpdateStmt = alternateUpdateStmt + "UPDATE '" + ((SQLDBTable)this.table).getSchema() + "'.'" + tbl + "'";
        }
        String sql = "";
        boolean anyErrors = false;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        if(this.queryView.isDirty()) {
            Properties prop = this.queryView.getConnectionProperties();
            try {
                conn = DBExplorerConnectionUtil.createConnection(prop);
                conn.setAutoCommit(false);
                if(conn != null && !conn.isClosed()) {
                    stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
                            ResultSet.CONCUR_UPDATABLE, ResultSet.HOLD_CURSORS_OVER_COMMIT);
                    Iterator itr = this.queryView.getChanges().entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = (Map.Entry) itr.next();
                        String loc = (String) entry.getKey();
                        int row = Integer.parseInt(loc.substring(0, loc.indexOf(";")));
                        int col = Integer.parseInt(loc.substring(loc.indexOf(";") + 1, loc.length()));
                        String whereClause = (String)entry.getValue();
                        int rowCount = 0;
                        try {
                            rowCount = stmt.executeUpdate(updateStmt + whereClause);
                        } catch (SQLException ex) {
                            try {
                                rowCount = stmt.executeUpdate(alternateUpdateStmt + whereClause);
                            } catch (SQLException e) {
                                sql = updateStmt + whereClause;
                                anyErrors = true;
                                errorMsg = errorMsg + "Update failed at Row:" + row + "Column:" + col + ";";
                            }
                        }
                        if(rowCount == 0) {
                            anyErrors = true;
                            errorMsg = "No rows updates using " + sql + ";";
                        } else if(rowCount > 1) {
                            anyErrors = true;
                            errorMsg = "A Distinct row cannot be updated using " + sql + ";";
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    commit.setEnabled(false);
                    this.queryView.setDirtyStatus(false);
                }
            } catch (Exception ex) {
                anyErrors = true;
                errorMsg = "Connection not valid.";
            } finally {
                try {
                    conn.close();
                } catch (Exception ex) {
                    //ignore null ptr exception also, assuming conn is null.
                }
            }
        }
        if(anyErrors) {
            if(!errorMsg.equals("Connection not valid.")) {
                errorMsg = errorMsg + "Check the data field type, precision and other constraints.";
                commit.setEnabled(false);
                this.queryView.setDirtyStatus(false);
            }
            DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
        }
    }
    
    protected void insertActionPerformed() {
        boolean anyError = false;
        String errorMsg = "";
        SQLDBTable outTable = (SQLDBTable) this.table;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData meta = null;
        SQLDBConnectionDefinition connDef = null;
        String insertSql = "";
        String alternateInsertSql = "";
        String[] data = null;
        String query = this.queryView.getSql();
        StringBuilder values = null;
        try {
            connDef = ((SQLDBModel) outTable.getParentObject()).getETLDBConnectionDefinition();
        } catch (BaseException ex) {
            //ignore
        }
        if((outTable.getSchema() == null) || (outTable.getSchema().equals(""))) {
            insertSql = "Insert into \"" + outTable.getName() +"\" Values(";
            alternateInsertSql = "Insert into '" + outTable.getName() + "' Values(";
        } else {
            insertSql = "Insert into \"" + outTable.getSchema() + "\".\"" +
                    outTable.getName() +"\" Values(";
            alternateInsertSql = "Insert into '" + outTable.getSchema()+ "'.'" +
                    outTable.getName() + "' Values(";
        }
        try {
            conn = DBExplorerConnectionUtil.createConnection(
                    connDef.getConnectionProperties());
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            meta = rs.getMetaData();
            data = getDialogData(meta);
            if(data != null) {
                for(int i = 0; i < data.length; i++) {
                    if(values != null) {
                        values.append(",");
                    } else {
                        values = new StringBuilder();
                    }
                    values.append(data[i]);
                }
                values.append(")");
                try {
                    int rows = stmt.executeUpdate(insertSql + values.toString());
                    if(rows != 1) {
                        anyError = true;
                        errorMsg = "Failed to insert record." +
                                "Check for datatype mismatch and other key constraints.";
                    }
                } catch (SQLException ex) {
                    try {
                        int rows = stmt.executeUpdate(alternateInsertSql + values.toString());
                        if(rows != 1) {
                            anyError = true;
                            errorMsg = "Failed to insert record." +
                                    "Check for datatype mismatch and other key constraints.";
                        }
                    } catch (SQLException e) {
                        anyError = true;
                        errorMsg = "Failed to insert record." +
                                "Check for datatype mismatch and other key constraints.";
                    }
                }
            }
        } catch (Exception ex) {
            anyError = true;
            errorMsg = "Failed to connect to the database.";
        }
        if(data != null) {
            if(anyError) {
                DialogDisplayer.getDefault().notify(new Message(
                        errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
                try {
                    conn.rollback();
                } catch (SQLException ex) {
                    //ignore
                }
            } else {
                String msg = "Commit the INSERT Operation to the database?";
                NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg,
                        "Confirm delete", NotifyDescriptor.YES_NO_OPTION);
                if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.YES_OPTION) {
                    try {
                        conn.commit();
                    } catch (SQLException ex) {
                        anyError = true;
                        errorMsg = "Failure while commiting changes to database.";
                        DialogDisplayer.getDefault().notify(new Message(
                                errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
                    }
                    if(!anyError) {
                        errorMsg = "Record successfully inserted.";
                        DialogDisplayer.getDefault().notify(new Message(
                                errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
                        refreshActionPerformed();
                    }
                } else {
                    errorMsg = "INSERT operation discarded.";
                    DialogDisplayer.getDefault().notify(new Message(
                            errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
                }
            }
        }
        if(conn != null) {
            try {
                conn.close();
            } catch(SQLException ex) {
                //ignore
            }
        }
    }
    
    protected void deleteRecordActionPerformed() {
        SQLDBTable outTable = (SQLDBTable)this.table;
        boolean error = false;
        String errorMsg = null;
        String alternateDeleteSql = "";
        String deleteSql = "";
        Connection conn = null;
        SQLDBConnectionDefinition connDef = null;
        try {
            connDef = ((SQLDBModel) outTable.getParentObject()).getETLDBConnectionDefinition();
        } catch (BaseException ex) {
            //ignore
        }
        if((outTable.getSchema() == null) || (outTable.getSchema().equals(""))) {
            deleteSql = "Delete From \"" + outTable.getName() +"\" Where ";
            alternateDeleteSql = "Delete From '" + outTable.getName() + "' Where ";
        } else {
            deleteSql = "Delete From \"" + outTable.getSchema() + "\".\"" +
                    outTable.getName() +"\" Where ";
            alternateDeleteSql = "Delete From '" + outTable.getSchema()+ "'.'" +
                    outTable.getName() + "' Where ";
        }
        String[] sqls = this.queryView.getDeleteRowsSQL();
        if(sqls.length == 0) {
            String msg = "Please select a row to delete.";
            DialogDisplayer.getDefault().notify(new Message(msg, NotifyDescriptor.INFORMATION_MESSAGE));
        } else {
            try {
                conn = DBExplorerConnectionUtil.createConnection(
                        connDef.getConnectionProperties());
                for(int i = 0; i < sqls.length; i++) {
                    try {
                        int rowsAffected = conn.createStatement().executeUpdate(deleteSql + sqls[i]);
                        if(rowsAffected == 0) {
                            error = true;
                            errorMsg = errorMsg + "No rows deleted for " + deleteSql + sqls[i] + ".";
                        } else if(rowsAffected > 1) {
                            error = true;
                            errorMsg = errorMsg + deleteSql + sqls[i] +" Statement cannot delete unique row.";
                        }
                    } catch (SQLException ex) {
                        try {
                            int rowsAffected = conn.createStatement().executeUpdate(alternateDeleteSql + sqls[i]);
                            if(rowsAffected == 0) {
                                error = true;
                                errorMsg = errorMsg + "No rows deleted for " + deleteSql + sqls[i] + ".";
                            } else if(rowsAffected > 1) {
                                error = true;
                                errorMsg = errorMsg + deleteSql + sqls[i] +" Statement cannot delete unique row.";
                            }
                        } catch (SQLException e) {
                            error = true;
                            if(errorMsg != null) {
                                errorMsg = errorMsg + " And ";
                            } else {
                                errorMsg = "";
                            }
                            errorMsg = errorMsg + deleteSql + sqls[i] + ".";
                        }
                    }
                }
            } catch (DBSQLException ex) {
                // ignore
            } catch (BaseException ex) {
                // ignore
            } finally {
                if(!error) {
                    try {
                        String msg = "Permanently delete record(s) from the database?";
                        NotifyDescriptor d = new NotifyDescriptor.Confirmation(msg,
                                "Confirm delete", NotifyDescriptor.OK_CANCEL_OPTION);
                        if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.OK_OPTION) {
                            conn.commit();
                        } else {
                            msg = "Discarded the delete operation.";
                            DialogDisplayer.getDefault().notify(new Message(msg, NotifyDescriptor.INFORMATION_MESSAGE));
                            conn.rollback();
                        }
                    } catch (SQLException ex) {
                        error = true;
                        errorMsg = "Commit Failed.";
                    }
                } else {
                    errorMsg = "Delete command failed for " + errorMsg;
                    DialogDisplayer.getDefault().notify(new Message(errorMsg, NotifyDescriptor.INFORMATION_MESSAGE));
                }
                try {
                    conn.close();
                } catch (SQLException ex) {
                    //ignore
                }
                refreshActionPerformed();
            }
        }
    }
    
    private String getJoinSql(SQLJoinOperator op, boolean useSourceTableAlias) {
        String sql = "";
        try {
            DB db = DBFactory.getInstance().getDatabase(DBConstants.ANSI92);
            StatementContext context = new StatementContext();
            context.setUseSourceTableAliasName(useSourceTableAlias);
            if(!useSourceTableAlias) {
                context.setUsingFullyQualifiedTablePrefix(false);
                context.putClientProperty(StatementContext.USE_FULLY_QUALIFIED_TABLE, Boolean.FALSE);
            }
            sql = sql + db.getEvaluatorFactory().evaluate(op, context);
        } catch (BaseException ex) {
            //ignore
        }
        return sql;
    }
    
    private String[] getDialogData(ResultSetMetaData meta) {
        List<JTextField> lst = new ArrayList<JTextField>();
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        Object[] obj = null;
        String[] data = null;
        JPanel panel = null;
        try {
            data = new String[meta.getColumnCount()];
            //Add fields
            panel = new JPanel();
            panel.setBorder(BorderFactory.createEtchedBorder());
            GridBagLayout gl = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            panel.setLayout(gl);
            JLabel label = new JLabel("Field Name");
            label.setForeground(Color.RED);
            c.weightx = 0.35;
            c.gridwidth = GridBagConstraints.RELATIVE;
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(label, c);
            label = new JLabel("Field Value");
            label.setForeground(Color.RED);
            c.weightx = 0.65;
            c.gridwidth = GridBagConstraints.REMAINDER;
            c.fill = GridBagConstraints.HORIZONTAL;
            panel.add(label, c);
            for(int i = 0; i < meta.getColumnCount(); i++) {
                label = new JLabel(meta.getColumnName(i+1));
                JTextField txt = new JTextField(meta.getScale(i+1));
                txt.setToolTipText("Field Type: " + meta.getColumnClassName(i+1));
                txt.setName(meta.getColumnName(i+1));
                label.setLabelFor(txt);
                c.weightx = 0.35;
                c.gridwidth = GridBagConstraints.RELATIVE;
                c.fill = GridBagConstraints.HORIZONTAL;
                panel.add(label, c);
                c.weightx = 0.65;
                c.fill = GridBagConstraints.HORIZONTAL;
                c.gridwidth = GridBagConstraints.REMAINDER;
                panel.add(txt, c);
                lst.add(txt);
            }
        } catch (SQLException ex) {
            //ignore
        }
        DialogDescriptor desc = new DialogDescriptor(panel, "Enter the Values");
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        if(desc.getValue()== NotifyDescriptor.OK_OPTION) {
            String msg = "";
            for(int i = 0; i < lst.size(); i++) {
                JTextField textField = lst.get(i);
                try {
                    for(int j = 1; j <= meta.getColumnCount(); j++) {
                        if(meta.getColumnName(j).equals(textField.getName())) {
                            if(meta.getColumnClassName(j).equals("java.lang.String")) {
                                data[j-1] = "'" + textField.getText() + "'";
                            } else if(meta.getColumnType(j) == java.sql.Types.DATE) {
                                data[j-1]  = "{d'" + textField.getText() + "'}";
                            } else if(meta.getColumnType(j) == java.sql.Types.TIME) {
                                data[j-1]  = "{t'" + textField.getText() +"'}";
                            } else if(meta.getColumnClassName(j).equals("java.math.BigDecimal")){
                                data[j-1] = textField.getText();
                            } else if(meta.getColumnClassName(j).equals("java.math.BigInteger")){
                                data[j-1] = textField.getText();
                            } else {
                                data[j-1] = "'" + textField.getText() + "'";
                            }
                            break;
                        }
                    }
                } catch (SQLException ex) {
                    //ignore
                }
            }
        } else {
            data = null;
        }
        return data;
    }
    
    private void setTotalCount(ResultSet rs) {
        try {
            if (rs == null) {
                totalRowsLabel.setText(NbBundle.getMessage(DataOutputPanel.class, "LBL_not_available"));
            } else {
                if (rs.next()) {
                    int count = rs.getInt(1);
                    totalRowsLabel.setText(String.valueOf(count));
                    totalCount = count;
                }
            }
        } catch (SQLException ex) {
            Logger.printThrowable(Logger.ERROR, DataOutputPanel.class.getName(), null, "Could not get total row count", ex);
        }
    }
}
