/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.edm.editor.graph.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.netbeans.modules.edm.editor.dataobject.MashupDataObject;
import org.netbeans.modules.edm.editor.graph.MashupGraphManager;
import org.netbeans.modules.edm.editor.utils.ImageConstants;
import org.netbeans.modules.edm.editor.utils.MashupGraphUtil;
import org.netbeans.modules.etl.ui.DataObjectProvider;
import org.netbeans.modules.etl.ui.ETLDataObject;
import org.netbeans.modules.etl.ui.ETLEditorSupport;
import org.netbeans.modules.sql.framework.model.SQLDBColumn;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.ui.graph.IGraphView;
import org.netbeans.modules.sql.framework.ui.model.CollabSQLUIModel;
import org.netbeans.modules.sql.framework.model.TargetTable;
import org.netbeans.modules.sql.framework.model.utils.SQLObjectUtil;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.ui.graph.IGraphController;
import org.netbeans.modules.sql.framework.ui.graph.IGraphNode;
import org.netbeans.modules.sql.framework.ui.graph.IGraphPort;
import org.netbeans.modules.sql.framework.ui.view.TableSelectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.netbeans.modules.sql.framework.ui.view.graph.SQLGraphView;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.sql.framework.model.SourceTable;

public class AutoMapAction extends AbstractAction {

    private MashupDataObject mObj;

    private SQLObject obj;

    private MashupGraphManager manager;
    
    private long edgeCounter = 1;
    
    private List<Widget> widgets = new ArrayList<Widget>();

    public AutoMapAction(MashupDataObject dObj, SQLObject obj) {
        super("", new ImageIcon(MashupGraphUtil.getImage(ImageConstants.AUTOMAP)));
        mObj = dObj;
        this.manager = dObj.getGraphManager();
        this.obj = obj;
    }

    public AutoMapAction(MashupDataObject dObj, SQLObject obj, String name) {
        super(name, new ImageIcon(MashupGraphUtil.getImage(ImageConstants.AUTOMAP)));
        mObj = dObj;
        this.manager = dObj.getGraphManager();
        this.obj = obj;
    }

    public void actionPerformed(ActionEvent e) {
        /*try {
        mObj.getGraphManager().showOutput(obj, mObj.getModel().getSQLDefinition());
        } catch (Exception ex) {
        mObj.getGraphManager().setLog("Failed to generate output");
        }*/
       
        IGraphView gView = mObj.getEditorView().getGraphView();
        CollabSQLUIModel sqlModel = (CollabSQLUIModel) gView.getGraphModel();

        if (sqlModel != null) {
            List tTables = sqlModel.getSQLDefinition().getTargetTables();
            //if there is only one target table
            if (tTables.size() == 1) {
                createLinksToTarget((TargetTable) tTables.get(0));
                //handleLink();
                return;
            }

            TargetTable tt = SQLObjectUtil.getMappedTargetTable(obj, tTables);
            if (tt != null) {
                createLinksToTarget(tt);
                return;
            }

            //otherwise we have multiple target tables so need to ask user to select a
            // target
            //table
            TableSelectionPanel tableSelectionPanel = new TableSelectionPanel(tTables);
            tableSelectionPanel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
            tableSelectionPanel.setPreferredSize(new Dimension(200, 160));

            DialogDescriptor dd = new DialogDescriptor(tableSelectionPanel, "Select Target Table to Auto Map", true, NotifyDescriptor.OK_CANCEL_OPTION, null, null);

            if (DialogDisplayer.getDefault().notify(dd) == NotifyDescriptor.OK_OPTION) {
                List selectedTables = tableSelectionPanel.getSelectedTables();
                if (selectedTables.size() == 1) {
                    createLinksToTarget((TargetTable) selectedTables.get(0));
                }
            }
        }
        updateActions();
    }

    private void createLinksToTarget(TargetTable tTable) {
        IGraphView gView = mObj.getEditorView().getGraphView();
        if (!(gView instanceof SQLGraphView)) {
            return;
        }
        IGraphController graphController = gView.getGraphController();

        IGraphNode targetNode = gView.findGraphNode(tTable);
        if (targetNode == null) {
            return;
        }
        SourceTable sTable = (SourceTable) obj;
        Iterator it = sTable.getColumnList().iterator();
        IGraphNode sourceNode = gView.findGraphNode(sTable);

        while (it.hasNext()) {
            SQLDBColumn column = (SQLDBColumn) it.next();
            SQLDBColumn tColumn = getColumnIgnoreCase(tTable, column.getName());
            if (tColumn != null && tColumn.getJdbcType() == column.getJdbcType()) {
                //Logger.getLogger(AutoMapAction.class.getName()).info("getDisplayName _________ "+column.getDisplayName()+" getDisplayName in Target "+tColumn.getDisplayName());
                //manager.createGraphEdge(column.getDisplayName(), tColumn.getDisplayName());
                 //mObj.getGraphManager().getScene().
                manager.createPinEdge(column.getDisplayName(), tColumn.getDisplayName());
                IGraphPort from = sourceNode.getOutputGraphPort(column.getName());
                IGraphPort to = targetNode.getInputGraphPort(tColumn.getName());
                if (from != null && to != null) {
                    graphController.handleLinkAdded(from, to);
                }
            }
        }
        updateActions();
    }

    private SQLDBColumn getColumnIgnoreCase(TargetTable tt, String columnName) {
        Iterator it = tt.getColumnList().iterator();

        while (it.hasNext()) {
            SQLDBColumn column = (SQLDBColumn) it.next();
            if (column.getName().equalsIgnoreCase(columnName)) {
                return column;
            }
        }

        return null;
    }

    private void updateActions() {
        try {
            mObj.getEditorView().updateUI();
            ETLDataObject etlDataObject = DataObjectProvider.getProvider().getActiveDataObject();
            ETLEditorSupport editor = etlDataObject.getETLEditorSupport();
            editor.synchDocument();
        } catch (Exception ex) {
            //ignore
        }
    }
}
