/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sun.manager.jbi.management.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Retrieves the list of JBI Shared Assembles and JBI Service Units
 * deployed on the JBI Container
 *
 * @author Graj
 */
public class JBIServiceAssemblyDocument implements Serializable {

    public static final String SERVICE_ASSEMBLY_INFO_LIST_NODE_NAME = "service-assembly-info-list"; // NOI18N
    public static final String SERVICE_ASSEMBLY_INFO_NODE_NAME = "service-assembly-info"; // NOI18N
    public static final String NAME_NODE_NAME = "name"; // NOI18N
    public static final String DESCRIPTION_NODE_NAME = "description"; // NOI18N
    public static final String STATUS_NODE_NAME = "status"; // NOI18N
    public static final String SERVICE_UNIT_INFO_LIST_NODE_NAME = "service-unit-info-list"; // NOI18N
    public static final String SERVICE_UNIT_INFO_NODE_NAME = "service-unit-info"; // NOI18N
    public static final String TARGET_NAME_NODE_NAME = "target-name"; // NOI18N

    List<JBIServiceAssemblyStatus> jbiServiceAssemblyList = new ArrayList<JBIServiceAssemblyStatus>();


    /**
     *
     */
    public JBIServiceAssemblyDocument() {
        super();
        // TODO Auto-generated constructor stub
    }



    /**
     * @return Returns the jbiServiceAssemblyList.
     */
    public List<JBIServiceAssemblyStatus> getJbiServiceAssemblyList() {
        return this.jbiServiceAssemblyList;
    }
    /**
     * @param jbiServiceAssemblyList The jbiServiceAssemblyList to set.
     */
    public void setJbiServiceAssemblyList(List<JBIServiceAssemblyStatus> jbiServiceAssemblyList) {
        this.jbiServiceAssemblyList = jbiServiceAssemblyList;
    }

    public void dump() {
        Iterator<JBIServiceAssemblyStatus> iterator = this.jbiServiceAssemblyList.iterator();
        JBIServiceAssemblyStatus serviceAssemblyStatus = null;
        while((iterator != null) && (iterator.hasNext() == true)) {
            serviceAssemblyStatus = iterator.next();
            if(serviceAssemblyStatus != null) {
                System.out.println("/////////////////////////////////////////////////"); // NOI18N
                System.out.println("//  -- JBI Component --                        //"); // NOI18N
                System.out.println("/////////////////////////////////////////////////"); // NOI18N

                System.out.println("//  name is: "+ serviceAssemblyStatus.serviceAssemblyName); // NOI18N
                System.out.println("//  description is: "+ serviceAssemblyStatus.serviceAssemblyDescription); // NOI18N
                System.out.println("//  state is: "+ serviceAssemblyStatus.status); // NOI18N
                JBIServiceUnitStatus unitStatus = null;
                Iterator<JBIServiceUnitStatus> innerIterator = serviceAssemblyStatus.jbiServiceUnitStatusList.iterator();
                while(innerIterator.hasNext() == true) {
                    unitStatus = innerIterator.next();
                    if(unitStatus != null) {
                        System.out.println("// --------------------------------------"); // NOI18N
                        System.out.println("// ------ Service Unit ------------------"); // NOI18N
                        System.out.println("// --------------------------------------"); // NOI18N
                        System.out.println("//    name is: "+ unitStatus.getServiceUnitName()); // NOI18N
                        System.out.println("//    description is: "+ unitStatus.getServiceUnitDescription()); // NOI18N
                        System.out.println("//    state is: "+ unitStatus.getStatus()); // NOI18N
                        System.out.println("//    Target Name is: "+ unitStatus.getTargetName()); // NOI18N
                    }
                }
                System.out.println("/////////////////////////////////////////////////"); // NOI18N
            }
        }

    }
    public static void main(String[] args) {
    }
}

