/*
 * PortTypeEditorPanel.java
 *
 * Created on August 29, 2007, 2:03 PM
 */

package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.Constants;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.openide.util.NbBundle;

/**
 *
 * @author  rdara
 */
public class PortTypeEditorPanel extends javax.swing.JPanel {
    
    private List<PortType> mPortTypes;
    private PortType mPortType;
        
    Map<PortType, QName> mapPTtoQName = new HashMap<PortType, QName>();

    /** Creates new form PortTypeEditorPanel */
    public PortTypeEditorPanel(List<PortType> portTypes, PortType portType, boolean bCanWrite) {
        initComponents();
        initialize(portTypes, portType, bCanWrite);
    }
    
    private void initialize(List<PortType> portTypes, PortType portType, boolean bCanWrite){
        
        LocalNameLabel.setEditable(false);
        NameSpaceLabel.setEditable(false);
        
        mPortTypes = portTypes;
        mPortType = portType;

        QName qName;
        for(PortType pt : portTypes) {
            if (pt != null) {
                if(CasaWrapperModel.isDummyPortType(pt)) {
                    qName = new QName(Constants.EMPTY_STRING,Constants.EMPTY_STRING); 
                } else {
                    qName = new QName(pt.getModel().getDefinitions().getTargetNamespace(), pt.getName());
                }
                mPortTypesComboBox.addItem(qName);
                mapPTtoQName.put(pt, qName);
            }
        }
        qName = new QName("","");
        if(portType != null) {
             qName = mapPTtoQName.get(portType);
             mPortTypesComboBox.setSelectedItem(qName);
        }
        updateLables(qName);
        mPortTypesComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                QName qName = (QName) mPortTypesComboBox.getSelectedItem();
                mPortTypesComboBox.setToolTipText(qName.toString());
                updateLables(qName);
            }
        });
        mPortTypesComboBox.setEnabled(bCanWrite);
    }
    
    private void updateLables(QName qName){
        String strValue = "";
        if(qName.getLocalPart().length() > 0) {
            strValue = qName.getLocalPart();
        } else {
            strValue = NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel_None");
        }
        LocalNameLabel.setText(strValue);
        LocalNameLabel.setToolTipText(strValue);
        strValue ="";
        
        if(qName.getNamespaceURI().length() > 0) {
            strValue = qName.getNamespaceURI();
        } else {
            strValue = NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel_None");
        }
        NameSpaceLabel.setText(strValue);
        NameSpaceLabel.setToolTipText(strValue);
    }
    public Object getValue() {
        return mPortTypes.get(mPortTypesComboBox.getSelectedIndex());
    }
    public void setValue(Object object) {
        if(object != null) {
            mPortTypesComboBox.setSelectedItem(mapPTtoQName.get(object));
        } else {
            mPortTypesComboBox.setSelectedIndex(0);
        }
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        mPortTypesComboBox = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        LocalNameLabel = new javax.swing.JTextField();
        NameSpaceLabel = new javax.swing.JTextField();

        jLabel1.setLabelFor(mPortTypesComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel.jLabel1.text_1")); // NOI18N

        jLabel2.setLabelFor(LocalNameLabel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel.jLabel2.text")); // NOI18N

        jLabel3.setLabelFor(NameSpaceLabel);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel.jLabel3.text")); // NOI18N

        LocalNameLabel.setText(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel.LocalNameLabel.text")); // NOI18N
        LocalNameLabel.setFocusable(false);

        NameSpaceLabel.setText(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "PortTypeEditorPanel.NameSpaceLabel.text")); // NOI18N
        NameSpaceLabel.setFocusable(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(LocalNameLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 422, Short.MAX_VALUE)
                    .add(NameSpaceLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 422, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, mPortTypesComboBox, 0, 422, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(mPortTypesComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(LocalNameLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(NameSpaceLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(82, Short.MAX_VALUE))
        );

        jLabel1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ACSN_InterfaceName")); // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ASCD_InterfaceName")); // NOI18N
        mPortTypesComboBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ACSN_InterfaceNames")); // NOI18N
        mPortTypesComboBox.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ACSD_InterfaceNameCombo")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ASCN_LocalName")); // NOI18N
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ASCD_LocalName")); // NOI18N
        jLabel3.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ASCN_NameSpace")); // NOI18N
        jLabel3.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(PortTypeEditorPanel.class, "ASCD_NameSpace")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField LocalNameLabel;
    private javax.swing.JTextField NameSpaceLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JComboBox mPortTypesComboBox;
    // End of variables declaration//GEN-END:variables
    
}
