/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.awt.CardLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JPanel;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.DurationExpression;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.view.AbstractBPELElementExpressionView;
import org.netbeans.modules.bpel.xpath.view.BPELElementXPathExpressionBuilder;
import org.netbeans.modules.bpel.xpath.view.DefaultMapperRule;
import org.netbeans.modules.bpel.xpath.view.expression.AbstractBPELMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.AbstractMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BPELDeadlineMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BPELDefaultExpressionView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BPELDurationMapperView;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BpelMapper;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;

/**
 *
 * @author radval
 *
 */
public class ForOrUntilReferenceExpressionView extends AbstractBPELElementExpressionView {
    
    private AbstractMapperView mCurrentView;
    private BPELDefaultExpressionView mDefaultMapperExpressionView;
    private AbstractBPELMapperView mDeadlineMapperExpressionView;
    private AbstractBPELMapperView mDurationMapperExpressionView;
    private BPELElementXPathExpressionBuilder mBuilder;
    
    private JPanel mDurationOrDeadlineViewPanel;
    private CardLayout mDurationOrDeadlineViewLayout;
    
    private static final String DURATION_VIEW =  "DURATION_VIEW";   // NOI18N
    private static final String DEADLINE_VIEW =  "DEADLINE_VIEW";   // NOI18N
    private static final String DEFAULT_VIEW =  "DEFAULT_VIEW";     // NOI18N
    
    
    public ForOrUntilReferenceExpressionView(BpelEntity element) {
        super(element);
        mDefaultMapperExpressionView = new BPELDefaultExpressionView(element.getBpelModel());
        mDeadlineMapperExpressionView = new BPELDeadlineMapperView(element, element.getBpelModel());
        mDurationMapperExpressionView = new BPELDurationMapperView(element, element.getBpelModel());
        
        DefaultMapperRule mapperRule = createMapperRule(mDeadlineMapperExpressionView.getBpelMapper());
        mDeadlineMapperExpressionView.getMapper().getBasicMapper().setMapperRule(mapperRule);
        
        mapperRule = createMapperRule(mDurationMapperExpressionView.getBpelMapper());
        mDurationMapperExpressionView.getMapper().getBasicMapper().setMapperRule(mapperRule);
        
        mDurationOrDeadlineViewPanel = new JPanel();
        mDurationOrDeadlineViewLayout = new CardLayout();
        mDurationOrDeadlineViewPanel.setLayout(mDurationOrDeadlineViewLayout);
        mDurationOrDeadlineViewPanel.add(mDeadlineMapperExpressionView, DEADLINE_VIEW);
        mDurationOrDeadlineViewPanel.add(mDurationMapperExpressionView, DURATION_VIEW);
        mDurationOrDeadlineViewPanel.add(mDefaultMapperExpressionView, DEFAULT_VIEW);
        //by default show default view, this is requred otherwise
        mDurationOrDeadlineViewLayout.show(mDurationOrDeadlineViewPanel, DEFAULT_VIEW);
        
    }
    
    /** @see AbstractExpressionView#getMappers()
     */
    public List<MapperView> getMappers() {
        List<MapperView> rl = new ArrayList<MapperView>();
        rl.add(mDefaultMapperExpressionView.getMapper());
        rl.add(mDeadlineMapperExpressionView.getMapper());
        rl.add(mDurationMapperExpressionView.getMapper());
        return rl;
    }
    
    public MapperView getActiveMapper() {
        return mCurrentView.getMapper();
    }
    
    public JComponent getComponent() {
        return mDurationOrDeadlineViewPanel;
    }
    
    private void render(TimeEvent forOrUntil) {
        mCurrentView = null;
        if (forOrUntil instanceof DurationExpression) {
            DurationExpression durationExp = (DurationExpression) forOrUntil;
            mCurrentView =  mDurationMapperExpressionView;
            ForOrUntilExpressionRenderer renderer = new ForOrUntilExpressionRenderer(mCurrentView.getMapper(), durationExp);
            renderer.draw(durationExp.getContent());
            mDurationOrDeadlineViewLayout.show(mDurationOrDeadlineViewPanel, DURATION_VIEW);
        } else if(forOrUntil instanceof DeadlineExpression) {
            DeadlineExpression deadlineExp = (DeadlineExpression) forOrUntil;
            mCurrentView = mDeadlineMapperExpressionView;
            ForOrUntilExpressionRenderer renderer = new ForOrUntilExpressionRenderer(mCurrentView.getMapper(), deadlineExp);
            renderer.draw(deadlineExp.getContent());
            mDurationOrDeadlineViewLayout.show(mDurationOrDeadlineViewPanel, DEADLINE_VIEW);
        }
    }
    
    public DefaultMapperRule createMapperRule(BpelMapper bpelMapper) {
        mBuilder = new ForOrUntilReferenceXpathExpressionBuilder(
                getBPELElement(),  bpelMapper.getBasicMapper());
        ForOrUntilReferenceXPathExpressionUpdater updater =
                new ForOrUntilReferenceXPathExpressionUpdater(bpelMapper.getBasicMapper(), getBPELElement());
        return new DefaultMapperRule(bpelMapper, mBuilder, updater);
    }
    
    public void initialize(BpelEntity element) {
        super.initialize(element);
        mBuilder.initialize(element, element.getBpelModel());
        mDefaultMapperExpressionView.initialize(element.getBpelModel());
        mDeadlineMapperExpressionView.initialize(element, element.getBpelModel());
        mDurationMapperExpressionView.initialize(element, element.getBpelModel());
    }
    
    public void synchronizeExpressionView(BpelEntity parentOb, Object value) {
        BpelEntity parent = parentOb;
        if (parent instanceof TimeEventHolder) {
            renderTimeEventHolder(parent);
        } else {
            TimeEventHolder teh = findTimeEventHolder(parent);
            if(teh != null) {
                renderTimeEventHolder(teh);
            }
        }
    }
    
    private TimeEventHolder findTimeEventHolder(BpelEntity entity) {
        while(entity != null && !(entity instanceof TimeEventHolder)) {
            entity = entity.getParent();
        }
        return (TimeEventHolder) entity;
    }
    
    private void renderTimeEventHolder(BpelEntity parent) {
        final TimeEventHolder forOrUntilReference = (TimeEventHolder) parent;
        initialize(parent);
        if (
                isInModel(forOrUntilReference) &&
                forOrUntilReference.getTimeEvent() != null) {
            TimeEvent forOrUntil = forOrUntilReference.getTimeEvent();
            render(forOrUntil);
        } else {
            mCurrentView = mDefaultMapperExpressionView;
            mDurationOrDeadlineViewLayout.show(mDurationOrDeadlineViewPanel, DEFAULT_VIEW);
        }
    }
    
    public boolean canFindInSourceTree() {
        return 
                mCurrentView == mDeadlineMapperExpressionView || 
                mCurrentView == mDurationMapperExpressionView;
    }
    
    public boolean canFindInDestinationTree() {
        return false;
    }

    
    class ForOrUntilExpressionRenderer extends ExpressionRenderer {
        
        public ForOrUntilExpressionRenderer(MapperView mapper, BpelEntity holdingEntity) {
            super(mapper, holdingEntity);
        }
        
        protected Object getLinkObject() {
            return getBPELElement();
        }
        
        protected IMapperTreeNode getTargetTreeNode() {
            IMapperTreeView destView = getMapper().getMapperViewManager().getDestView();
            Node targetTreeNode = null;
            RootPlaceHolderNode root = (RootPlaceHolderNode) destView.getTree().getModel().getRoot();
            targetTreeNode = root;
            List children = root.getChildren();
            Iterator it = children.iterator();
            if (it.hasNext()) {
                targetTreeNode = (Node) it.next();
            }
            
            NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
            targetTreeNode.accept(ntpBuilder);
            
            return  destView.getMapperTreeNode(ntpBuilder.getTreePath());
        }
    }
}
