/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeLinkCreatorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.visitor.NodeCreatorVisitor;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public abstract class ExpressionRenderer extends AbstractRenderer {
    //bpel element which holds this expression
    private BpelEntity mHoldingEntity;
    
    
    public ExpressionRenderer(MapperView mapper, BpelEntity holdingEntity) {
        super(mapper);
        this.mHoldingEntity = holdingEntity;
    }
    
    public BpelEntity getBPELElement() {
        return this.mHoldingEntity;
    }
    
    public void draw(Object element) {
        if (!(element instanceof String)) {
            return;
        }
        
        String expression = (String) element;
        if ((expression != null) && (expression.trim().length() > 0)) {
            XPathModel xpImpl = AbstractXPathModelHelper.getInstance().newXPathModel();
            XPathExpression xpExpr = null;

            try {
                xpExpr = xpImpl.parseExpression(expression);
                draw(xpExpr);
            } catch (Exception e) {
// Fix the issue #104950                
//                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                LOGGER.finer(NbBundle.getMessage(ExpressionRenderer.class,
                        "STR_CANNOT_PARSE_EXPRESSION_WILL_INSERT_COPY_FROM_FUNCTIOD")); // NOI18N
            }
        }
    }
                
    public void draw(XPathExpression xpExpr) {
        IMapperNode sourceNode = null;

        NodeCreatorVisitor nVisitor = new NodeCreatorVisitor(
                getMapper(),
                getBpelMapper().getPredicatesManager(),
                this.mHoldingEntity);
        xpExpr.accept(nVisitor);

        Node rootNode = nVisitor.getRootNode();
        if (rootNode != null) {
              sourceNode = rootNode.getMapperNode();
              NodeLinkCreatorVisitor nlCreator = new NodeLinkCreatorVisitor(
                    getBpelMapper(), 
                    getMapper());
              rootNode.accept(nlCreator);
        }
                
        IMapperTreeNode destNode =  getTargetTreeNode();
        
        if (sourceNode != null && destNode != null) {
            Node sNode     = (Node) sourceNode.getNodeObject();
            TreeNode tNode = (TreeNode) destNode.getPath().getLastPathComponent();
            if (sNode != null && tNode != null) {
                tNode.setMapperNode(destNode);
                destNode.setNodeObject(tNode);
                if (sNode instanceof CanvasNode) {
                    ((CanvasNode) sNode).addOutput(tNode);
                }
            }
        }
        
        Object linkObject = getLinkObject();
        if (sourceNode != null) {
            if (sourceNode instanceof IMethoidNode) {
                IMethoidNode methoidNode = (IMethoidNode) sourceNode;
                IFieldNode fieldNode = (IFieldNode) methoidNode.getOutputFieldNodes().get(0);
                addLink(fieldNode, destNode, linkObject);
            } else {
                addLink(sourceNode, destNode, linkObject);
            }
        }
        
        layout();
    }
    
    protected abstract Object getLinkObject();
    
    protected abstract IMapperTreeNode getTargetTreeNode();
}
