/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.FromChild;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import java.util.logging.Level;

import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.xpath.model.node.visitor.XPathGeneratorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.view.AbstractXPathExpressionUpdater;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperUtil;
import org.netbeans.modules.xml.xam.Component;
import org.openide.util.NbBundle;

public class AssignXPathExpressionUpdater extends AbstractXPathExpressionUpdater {
    
    AssignXPathExpressionUpdater(IBasicMapper mapper, BpelEntity holdingEntity) {
        super(mapper, holdingEntity);
    }
    public void handleLinkRemovalFromTargetTreeNode(List links) {
        removeLinkObject(links);
    }
    
    public void handleLinkUpdateToNonTargetTreeNode(List links) {
        updateLinkObject(links);
    }
    
    public void handleNodeUpdateNotConnectedToTargetTreeNode(List links) {
        updateLinkObject(links);
    }
    
    private Literal getLiteral(From from) {
      FromChild child = from.getFromChild();

      if ( !(child instanceof Literal)) {
        return null;
      }
      return (Literal) child;
    }

    private void updateLinkObject(List links) {
        Iterator it = links.iterator();
        while (it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            Copy copy = (Copy) link.getLinkObject();
            IMapperNode operatorNode = link.getStartNode();
            Node opNode = MapperUtil.getMapperNodeObject(operatorNode);
            if (copy != null && copy.getFrom() != null && opNode != null) {
                XPathGeneratorVisitor xGenerator = new XPathGeneratorVisitor(getBPELElement());
                opNode.accept(xGenerator);
                String expression = xGenerator.getXPath();
                From from = copy.getFrom();
                try {                   
                    if (getLiteral(from) != null) {
                        // need to set content of literal instead
                        setContent(getLiteral(from), expression);
                    } else {               
                        from.setContent(expression);
                    }
                    xGenerator.addNewPrefixToProcess();
                } catch (Exception ex) {
                    LOGGER.log(Level.SEVERE,
                            NbBundle.getMessage(AssignXPathExpressionUpdater.class,
                                "STR_FAILED_TO_SET_FROM_CONTENT_TO_X",  // NOI18N
                                expression), ex);
                }
            }
        }
    }
    
    private void removeLinkObject(List links) {
        Iterator it = links.iterator();
        while (it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            Copy copy = (Copy) link.getLinkObject();
            if (copy != null) {
                Component parent = copy.getParent();
                if (parent != null && parent instanceof Assign) {
                    Assign assign = (Assign) parent;
                    List children = assign.getChildren();
                    if (children != null) {
                        int copyIndex  = children.indexOf(copy);
                        if (copyIndex != -1) {
                            assign.removeAssignChild(copyIndex);
                        }
                    }
                }
            }
        }
    }
    
    private void setContent(Literal literal, String content) {
        try {
            if (literal != null) {
                String modContent = removeQuotes(content);
                literal.setContent(modContent);
            }
        } catch (Exception ex) {
            LOGGER.log(Level.SEVERE,
                    NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                        "STR_FAILED_TO_SET_FROM_CONTENT_TO_X", // NOI18N
                        content), ex);
        }        
    }
    
    private String removeQuotes(String expression) {
        String result = expression;
        if (expression != null) {            
            if ((expression.startsWith("'")) && (expression.endsWith("'"))
                    && (expression.length() > 1)) {
                StringBuffer buf = new StringBuffer(expression);
                buf.deleteCharAt(0);
                buf.deleteCharAt(buf.length() - 1);
                result = buf.toString();
            }
        }
        return result;
    }            
}
