/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeLocalVariableTreeExpanderVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.BpelMapper;
import org.netbeans.modules.bpel.xpath.view.model.tree.BusinessProcessTreeModel;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.IMapperViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;

/**
 * @author radval
 *
 *
 */
public abstract class AbstractBPELMapperView extends AbstractMapperView {
    
    private BpelEntity mElement;
    
    
    protected AbstractBPELMapperView(
            BpelEntity element,
            BpelModel document) {
        super(document, element);
        this.mElement = element;
        getBpelMapper().setSelectedElement(element);
    }
    
    public BpelEntity getBPELElement() {
        return this.mElement;
    }
    
    protected void setBPELElement(BpelEntity element) {
        mElement = element;
    }
    
    public BpelMapper getBpelMapper() {
        return (BpelMapper) getMapper();
    }
    
    public void initialize(BpelEntity element, BpelModel document) {
        clear();
        
        mElement = element;
        setBpelModel(document);
        getBpelMapper().setSelectedElement(element);
        
        if (mVariablesRootNode != null) {
            VariablesNode variablesNode = mVariablesRootNode.getVariablesNode();
            if (variablesNode != null) {
                variablesNode.setContextActivity(element);
            }
            updateTreeStructure(getBpelMapper().getMapperViewManager().getSourceView().getTree());
            updateTreeStructure(getBpelMapper().getMapperViewManager().getDestView().getTree());
        }
    }
    
    private void updateTreeStructure(JTree tree) {
        BusinessProcessTreeModel businessProcessTreeModel = (BusinessProcessTreeModel) tree.getModel();
        if (businessProcessTreeModel.getRoot() == mVariablesRootNode) {
            businessProcessTreeModel.fireTreeStructureChanged(new TreePath(mVariablesRootNode));
            VariablesNode variablesNode = mVariablesRootNode.getVariablesNode();
            if (variablesNode != null && variablesNode.hasLocalVariables()) {
                // expand local variables
                NodeLocalVariableTreeExpanderVisitor localVariablesExpander = 
                        new NodeLocalVariableTreeExpanderVisitor(tree);
//              mVariablesRootNode.accept(localVariablesExpander);
            }
            // expand global variables
            tree.expandRow(0);
        }
    }

    private void clear() {
        IMapperViewModel viewModel = this.mMapper.getBasicMapper().getMapperModel().getSelectedViewModel();
        if (viewModel != null) {
            List nodesToRemove = new ArrayList(viewModel.getNodes());
            for (Iterator iter=nodesToRemove.iterator(); iter.hasNext();) {
                IMapperNode node = (IMapperNode) iter.next();
                if (node instanceof IMapperTreeNode) {
                    TreeNode treeNode = (TreeNode) node.getNodeObject();
                    if (treeNode != null) {
                        treeNode.setMapperNode(null);
                    }
                }
                this.mMapper.getBasicMapper().removeNode(node);
            }
        }
    }
}
