/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import java.util.List;
import java.util.logging.Logger;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;

import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.CatchNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ForEachNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ScopeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicateNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicatesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.xml.schema.model.Attribute;

import org.openide.util.Utilities;




/**
 *
 * @author radval
 *
 */
public class NodeIconSelectorVisitor extends AbstractNodeVisitor {
    
    /** The logger. */
    private static final Logger mLogger =
            Logger.getLogger(NodeIconSelectorVisitor.class.getName());
    
    // NOI18N for all image icon strings below
    
    /** The PartnerLink icon. */
    private static Icon mPartnerIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/PartnerLink.gif");
    
    /** The Variable icon. */
    private static Icon mVariableSimpleIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/variableSimpleType.png");
    
    /** The Variable icon. */
    private static Icon mVariableMessageIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/variableMessageType.png");
    
    /** The Variable icon. */
    private static Icon mVariableElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/variableElementType.png");
    
    /** The Variables icon. */
    private static Icon mContainersIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/variablesContainer.png");
    
    /** The Variables icon. */
    private static Icon mPartIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/messagePart.png");
    
    /** The repeat_element icon. */
    private static Icon mRepeatParentElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_repeating.png");
    
    /** The repeat_element icon. */
    private static Icon mRepeatElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_repeating.png");
    
    /** The repeat_element icon. */
    private static Icon mElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element.png");
    
    /** The no repeat element parent icon. */
    private static Icon mElementParentIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element.png");
    
    /** The repeat_element icon. */
    private static Icon mOptionalElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_optional.png");
    
    /** The repeat_element icon. */
    private static Icon mRepeatingOptionalElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_optional_repeating.png");
    
    /** The repeat_element icon. */
    private static Icon mRepeatingOptionalParentElementIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_optional_repeating.png");
    
    private static Icon mAttributeIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/attribute.png");
    
    private static Icon mTheOptionalAttribute =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/attribute_optional.png");
    
    /** The repeat_element icon. */
    private static Icon mOptionalParentIcon =
            loadImageIcon("org/netbeans/modules/bpel/xpath/view/resources/images/element_optional.png");
    
    /** boolean icon */
    private static ImageIcon mResultIcon = new ImageIcon(
            Utilities.loadImage("org/netbeans/modules/bpel/xpath/view/resources/images/result.png"));
    
    private Icon mIcon;
    
    
    public NodeIconSelectorVisitor(){
    }
    
    public Icon getIcon() {
        return this.mIcon;
    }
    
    public void visit(ScopeNode node) {
        this.mIcon = mContainersIcon;
    }
    
    public void visit(ForEachNode node) {
        this.mIcon = mContainersIcon;
    }
    
    public void visit(CatchNode node) {
        this.mIcon = mContainersIcon;
    }
    
    public void visit(VariablesNode node) {
        this.mIcon = mContainersIcon;
    }
    
    public void visit(VariableNode node) {
        VariableDeclaration v = node.getVariableDeclaration();
        if        (v.getType() != null) {
            // Simple type
            this.mIcon = mVariableSimpleIcon;
        } else if (v.getMessageType() != null) {
            // Message type
            this.mIcon = mVariableMessageIcon;
        } else if (v.getElement() != null) {
            // Element type
            this.mIcon = mVariableElementIcon;
        }
    }
    
    public void visit(PartNode node) {
        if (node.getChildren().size() == 0) {
            this.mIcon = mElementIcon;
        } else {
            this.mIcon = mPartIcon;
        }
        
    }
    
    public void visit(XSDAttributeNode node) {
        Attribute attribute = node.getAttribute();
        if (node.isOptional()) {
            this.mIcon = mTheOptionalAttribute;
        } else {
            this.mIcon = mAttributeIcon;
        }
    }
    
    public void visit(XSDElementNode node) {
        List children = node.getChildren();
        int size = children.size();
        //if there are children
        if(size > 0) {
            //if repeating node
            if(node.getMaxOccurs() > 1
                    || node.getMaxOccurs() == XSDElementNode.UNBOUNDED) {
                //if node is optional meaning minOccurs == 0
                if(node.isOptional()) {
                    this.mIcon = mRepeatingOptionalParentElementIcon;
                } else {
                    this.mIcon = mRepeatParentElementIcon;
                }
            } else {
                //if not repeating node
                //if node is optional meaning minOccurs == 0
                if(node.isOptional()) {
                    this.mIcon = mOptionalParentIcon;
                } else {
                    this.mIcon = mElementParentIcon;
                }
            }
        } else {
            //if there are no chidren
            
            //if repeating node
            if(node.getMaxOccurs() > 1
                    || node.getMaxOccurs() == XSDElementNode.UNBOUNDED) {
                //if node is optional meaning minOccurs == 0
                if(node.isOptional()) {
                    this.mIcon = mRepeatingOptionalElementIcon;
                } else {
                    this.mIcon = mRepeatElementIcon;
                }
            } else {
                //if not repeating node
//				if node is optional meaning minOccurs == 0
                if(node.isOptional()) {
                    this.mIcon = mOptionalElementIcon;
                } else {
                    this.mIcon = mElementIcon;
                }
            }
        }
    }
    
    public void visit(XSDComplexTypeNode node) {
    }
    
    public void visit(XSDSimpleTypeNode node) {
    }
    
    public void visit(XPathOperatorNode node) {
    }
    
    public void visit(XPathPredicateNode node) {
    }
    
    public void visit(XPathPredicatesNode node) {
    }
    
    public void visit(XPathLocationStepNode node) {
        Node sourceOfLocationStepNode = node.getSourceOfLocationStepNode();
        
        if(sourceOfLocationStepNode != null) {
            sourceOfLocationStepNode.accept(this);
        }
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(FinalCounterValuePlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(DurationPlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        this.mIcon = mResultIcon;
    }
    
    public void visit(RootPlaceHolderNode node) {
        this.mIcon = mContainersIcon;
    }
    
    /**
     * Loads an image resource and creates an ImageIcon from it.
     * @param name the name of the image resource
     * @return an <code>ImageIcon</code> value
     */
    static Icon loadImageIcon(String path) {
        return (new ImageIcon(NodeIconSelectorVisitor.class.getClassLoader().getResource(path)));
    }
}
