/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.CatchNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ForEachNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ScopeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicateNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicatesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.bpel.xpath.model.xsd.visitor.XSDDisplayNameGeneratorVisitor;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class NodeDisplayNameGeneratorVisitor extends AbstractNodeVisitor {
    
    private StringBuffer mDisplayNameBuffer;
    
    
    public NodeDisplayNameGeneratorVisitor() {
        mDisplayNameBuffer = new StringBuffer(20);
    }
    
    
    public void clear() {
        mDisplayNameBuffer = new StringBuffer(20);
    }
    
    public String getDisplayName() {
        return this.mDisplayNameBuffer.toString();
    }
    
    public void visit(VariablesNode node) {
        mDisplayNameBuffer.append(NbBundle.getMessage(getClass(), "VariablesNode_DisplayName"));
    }
    
    public void visit(ScopeNode node) {
        mDisplayNameBuffer.append(node.getName());
    }
    
    public void visit(ForEachNode node) {
        mDisplayNameBuffer.append(node.getName());
    }
    
    public void visit(CatchNode node) {
        mDisplayNameBuffer.append(node.getName());
    }
    
    public void visit(VariableNode node) {
        VariableDeclaration variable = node.getVariableDeclaration();
        String variableName = node.getName();
        
        if(variableName != null) {
            if(!variableName.trim().equals("")) {
                mDisplayNameBuffer.append(variableName);
            } else {
                mDisplayNameBuffer.append(
                        NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                            "STR_VARIABLE_NAME_IS_EMPTY"));     // NOI18N
            }
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_VARIABLE_NAME_IS_NULL"));  // NOI18N
        }
    }
    
    public void visit(PartNode node) {
        Part part = node.getPart();
        String partName = part.getName();
        if(partName != null) {
            if(!partName.trim().equals("")) {
                mDisplayNameBuffer.append(partName);
            } else {
                mDisplayNameBuffer.append(
                        NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                            "STR_PART_NAME_IS_EMPTY"));     // NOI18N
            }
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_PART_NAME_IS_NULL"));  // NOI18N
        }
    }
    
    public void visit(XSDAttributeNode node) {
        Attribute attribute = node.getAttribute();
        if(attribute != null) {
            XSDDisplayNameGeneratorVisitor xdnGenerator = new XSDDisplayNameGeneratorVisitor();
            attribute.accept(xdnGenerator);
            mDisplayNameBuffer.append(xdnGenerator.getDisplayName());
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_ATTRIBUTE_NAME_IS_NULL")); // NOI18N
        }
        
    }
    
    public void visit(XSDElementNode node) {
        Element element = node.getElement();
        
        if(element != null) {
            XSDDisplayNameGeneratorVisitor xdnGenerator = new XSDDisplayNameGeneratorVisitor();
            element.accept(xdnGenerator);
            mDisplayNameBuffer.append(xdnGenerator.getDisplayName());
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_ELEMENT_NAME_IS_NULL"));   // NOI18N
        }
    }
    
    public void visit(XSDComplexTypeNode node) {
        ComplexType cType = node.getComplexType();
        String cTypeName = null;
        if(cType instanceof Nameable) {
            cTypeName = ((Nameable)cType).getName();
        }
        if(cTypeName != null) {
            if(!cTypeName.trim().equals("")) {
                mDisplayNameBuffer.append(cTypeName);
            } else {
                mDisplayNameBuffer.append(
                        NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_COMPLEXTYPE_NAME_IS_EMPTY"));     // NOI18N
            }
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_COMPLEXTYPE_NAME_IS_NULL"));   // NOI18N
        }
    }
    
    public void visit(XSDSimpleTypeNode node) {
        SimpleType sType = node.getSimpleType();
        //TODO: fix me
        
        String sTypeName =
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "STR_SIMPLETYPE_NEEDS_TO_BE_CALCULATED");   // NOI18N
        if(sTypeName != null) {
            if(!sTypeName.trim().equals("")) {
                mDisplayNameBuffer.append(sTypeName);
            } else {
                mDisplayNameBuffer.append(
                        NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                            "STR_SIMPLETYPE_NAME_IS_EMPTY"));   // NOI18N
            }
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "STR_SIMPLETYPE_NAME_IS_NULL"));    // NOI18N
        }
    }
    
    
    public void visit(XPathOperatorNode node) {
    }
    
    
    
    public void visit(XPathPredicateNode node) {
        XPathPredicateExpression predicateExpression = node.getPredicateExpression();
        String expressionString = predicateExpression.getExpressionString();
        if(expressionString != null) {
            if(!expressionString.trim().equals("")) {
                mDisplayNameBuffer.append(expressionString);
            } else {
                mDisplayNameBuffer.append(
                        NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                            "STR_PREDICATE_EXPRESSION_IS_EMPTY"));  // NOI18N
            }
        } else {
            mDisplayNameBuffer.append(
                    NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                        "STR_PREDICATE_EXPRESSION_IS_NULL"));   // NOI18N
        }
    }
    
    public void visit(XPathPredicatesNode node) {
        XPathPredicateExpression[] predicateExpression = node.getPredicateExpression();
        for(int i = 0; i < predicateExpression.length; i++) {
            mDisplayNameBuffer.append(predicateExpression[i].getExpressionString());
        }
    }
    
    public void visit(XPathLocationStepNode node) {
        
        TreeNode baseNode = node.getSourceOfLocationStepNode();
        String baseNodeName = baseNode.getName();
        mDisplayNameBuffer.append(baseNodeName);
        //
        LocationStep step = node.getLocationStep();
        XPathPredicateExpression[] predicateArr = step.getPredicates();
        for (XPathPredicateExpression pred : predicateArr) {
            String predText = pred.getPredicate().getExpressionString();
            mDisplayNameBuffer.append("[").append(predText).append("]");
        }
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "BooleanPlaceHolderNode_DisplayName")); // NOI18N
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "StartCounterValuePlaceHolderNode_DisplayName"));   // NOI18N
    }
        
    public void visit(FinalCounterValuePlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "FinalCounterValuePlaceHolderNode_DisplayName"));   // NOI18N
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                "BranchesPlaceHolderNode_DisplayName"));    // NOI18N
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                "DeadlinePlaceHolderNode_DisplayName"));    // NOI18N
    }
    
    public void visit(DurationPlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "DurationPlaceHolderNode_DisplayName"));    // NOI18N
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        mDisplayNameBuffer.append(
                NbBundle.getMessage(NodeDisplayNameGeneratorVisitor.class,
                    "PredicatePlaceHolderNode_DisplayName"));   // NOI18N
    }
    
    public void visit(RootPlaceHolderNode node) {
        mDisplayNameBuffer.append(node.getDisplayName());
    }
    
}
