/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.ToPartContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitorAdaptor;

/**
 *
 * @author jsandusky
 */
public class DownstreamVariableFinderVisitor extends BpelModelVisitorAdaptor {
    
    private Map mMatchingVariables;
    private BpelEntity mPreviousEntity;
    private boolean mDiscontinueTraversal;
    
    
    public DownstreamVariableFinderVisitor(BpelEntity entity) {
        mPreviousEntity = entity;
        entity.accept(this);
    }

    
    /**
     * key:   variable name (String)
     * value: variable declaration (VariableDeclaration)
     */
    public Map getMatchingVariables() {
        return mMatchingVariables;
    }
    

    public void visit( OnMessage message ) {
        visit( (BpelContainer) message);
    }

    public void visit( OnAlarmPick onAlarmPick ) {
        visit( (BpelContainer) onAlarmPick);
    }

    public void visit( FaultHandlers handlers ) {
        visit( (BpelContainer) handlers);
    }
    
    public void visit( Catch catc ) {
        visit( (BpelContainer) catc);
    }
    
    public void visit( CatchAll catchAll ) {
        visit( (BpelContainer) catchAll);
    }

    
    protected void visit( BpelContainer activity ) {
        traverseEntity(activity);
    }
    
    protected void visit( Activity activity ) {
        traverseEntity(activity);
    }
    
    private void traverseEntity(BpelEntity entity) {
        BpelContainer parent = entity.getParent();
        if (parent instanceof Sequence) {
            Sequence sequence = (Sequence) parent;
            int startIndex =
                    sequence.indexOf(BpelEntity.class, mPreviousEntity) + 1;
            traverseSequenceChildren(parent, startIndex);
        }
        if (!mDiscontinueTraversal) {
            mPreviousEntity = parent;
            if (parent != null) {
                parent.accept(this);
            }
        }
    }
    
    private void traverseSequenceChildren(BpelEntity parent, int startIndex) {
        if (parent instanceof Sequence) {
            Sequence sequence = (Sequence) parent;
            for (
                    int i = startIndex; 
                    !mDiscontinueTraversal && i < sequence.sizeOfActivities(); 
                    i++)
            {
                ExtendableActivity child = sequence.getActivity(i);
                checkElement(child);
                if (!mDiscontinueTraversal) {
                    traverseSequenceChildren(child, 0);
                }
            }
        }
    }

    private void checkElement(BpelEntity entity) {
        if        (entity instanceof Invoke) {
            addRelevantEntity( (Invoke) entity );
        } else if (entity instanceof Reply) {
            addRelevantEntity( (Reply) entity );
        }
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.bpel.model.api.support.BpelModelVisitor#visit(org.netbeans.modules.bpel.model.api.Invoke)
     */
    /** {@inheritDoc} */
    private void addRelevantEntity( Invoke invoke ) {
        
        if (invoke.getInputVariable() != null && invoke.getInputVariable().get() != null) {
            // Handle the "inputVariable" attribute.
            // Mutually exclusive with the <toParts> element.
            VariableDeclaration dec = (VariableDeclaration) invoke.getInputVariable().get();
            recordMatch(dec.getVariableName(), dec);
        } else {
            // Handle the <toParts> element.
            // Mutually exclusive with the "inputVariable" attribute.
            ToPartContainer toPartContainer = invoke.getToPartContaner();
            ToPart[] toParts = toPartContainer == null 
                    ? null
                    : toPartContainer.getToParts();
            if (toParts != null) {
                for (int i=0; i < toParts.length; i++) {
                    addRelevantEntity(toParts[i]);
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.bpel.model.api.support.BpelModelVisitor#visit(org.netbeans.modules.bpel.model.api.Reply)
     */
    /** {@inheritDoc} */
    private void addRelevantEntity( Reply reply ) {
        
        if (reply.getVariable() != null && reply.getVariable().get() != null) {
            // Handle the "variable" attribute.
            // Mutually exclusive with the <toParts> element.
            VariableDeclaration dec = (VariableDeclaration) reply.getVariable().get();
            recordMatch(dec.getVariableName(), dec);
        } else {
            // Handle the <toParts> element.
            // Mutually exclusive with the "variable" attribute.
            ToPartContainer toPartContainer = reply.getToPartContaner();
            ToPart[] toParts = toPartContainer == null 
                    ? null 
                    : toPartContainer.getToParts();
            if (toParts != null) {
                for (int i=0; i < toParts.length; i++) {
                    addRelevantEntity(toParts[i]);
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.bpel.model.api.support.BpelModelVisitor#visit(org.netbeans.modules.bpel.model.api.ToPart)
     */
    /** {@inheritDoc} */
    private void addRelevantEntity( ToPart toPart ) {
        
        if (toPart.getFromVariable() != null && toPart.getFromVariable().get() != null) {
            VariableDeclaration dec = (VariableDeclaration) toPart.getFromVariable().get();
            recordMatch(dec.getVariableName(), dec);
        }
    }
    
    private void recordMatch(String variableName, VariableDeclaration dec) {
        if (mMatchingVariables == null) {
            mMatchingVariables = new HashMap();
        }
        mMatchingVariables.put(dec.getVariableName(), dec);
        mDiscontinueTraversal = true;
    }
}
