/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * TaskWrapperForBPELModel.java
 *
 * Created on July 13, 2006, 2:53 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.bpel.project.anttasks;

import java.io.File;

import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/**
 *
 * @author sgenipudi
 */
public class TaskWrapperForBPELModel extends Task {
    private Reference m_ref = null;    
    private AntClassLoader m_myClassLoader = null;    
    private String mClassName = null;
    private String mFileName = null;
    /** Creates a new instance of TaskWrapperForBPELModel */
    public TaskWrapperForBPELModel() {
    }
    
    public void setClasspathRef(Reference ref) {
        System.out.println("Reference is set!!!");
        this.m_ref = ref;
    }
    
    public void setClassName(String className) {
        this.mClassName= className;
    }
    
    public void setFileName(String fileName) {
        this.mFileName = fileName;
    }
    
    public void execute() throws BuildException  {
        m_myClassLoader = new AntClassLoader(); 
        initClassLoader();   

         Class antTaskClass =  null;
         Object result = null;
         try {
             antTaskClass = Class.forName(mClassName, true,m_myClassLoader );
             m_myClassLoader.setThreadContextLoader();
             Thread.currentThread().setContextClassLoader(m_myClassLoader);
 
             Object genJBIInstObj = antTaskClass.newInstance();
             
             Method driver =null;
             
             driver = antTaskClass.getMethod("execute",
                            new Class[] {java.io.File.class});
            System.out.println("BPEL FILE NAME = " +
             mFileName
            );
            result = driver.invoke(genJBIInstObj,
                       new Object[] {new File(mFileName)});
         }catch (Exception e) {
             e.printStackTrace();
             throw new BuildException(e);
         }
        if (result == null || (((String)result).toUpperCase().indexOf("FAIL") != -1)) {
            throw new BuildException( " TEST CASE FAILED!"+(result!=null?(String)result:""));
        }
         
    }
        
    private void initClassLoader() {
        Path path = new Path(getProject());
        path.setRefid(m_ref);
        
        Path parentPath = new Path(getProject());
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof AntClassLoader) {
            parentPath.setPath(((AntClassLoader)cl).getClasspath());
            ((AntClassLoader)cl).setParent(null);
            parentPath.add(path);
            path = parentPath;
        }  
        
        m_myClassLoader.setClassPath(path);
        m_myClassLoader.setParent(null);
        m_myClassLoader.setParentFirst(false);
        
        System.out.println("Classpath="+m_myClassLoader.getClasspath());
                
    }
    
}
