/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.properties.editors.controls;

import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.netbeans.modules.soa.ui.form.CustomNodeChooser;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/**
 *
 * @author nk160297
 */
public class TreeNodeChooser extends JPanel implements CustomNodeChooser<Node> {
    
    static final long serialVersionUID = 1L;
    
    private AbstractTreeChooserPanel myTreePanel;
    
    // This Validation State Manager intended to be used when anything changed
    // by the user.
    private DefaultValidStateManager fastValidationState;
    
    // This Validation State Manager intended to be used after the user
    // press Ok button.
    private transient DefaultValidStateManager finalValidationState;
    
    private PropertyChangeListener selectionChangeListener;
    
    public TreeNodeChooser(AbstractTreeChooserPanel treePanel) {
        myTreePanel = treePanel;
        //
        createContent();
        // initControls();
        //
        Util.attachDefaultDblClickAction(myTreePanel, myTreePanel);
        Util.activateInlineMnemonics(this);
    }
    
    public AbstractTreeChooserPanel getTreePanel() {
        return myTreePanel;
    }
    
    public void createContent() {
        initComponents();
        fastValidationState = new DefaultValidStateManager();
        finalValidationState = new DefaultValidStateManager();
        //
        myTreePanel.createContent();
    }
    
    public boolean initControls() {
        myTreePanel.initControls();
        myTreePanel.subscribeListeners();
        myTreePanel.getValidator().revalidate(true);
        return false;
    }
    
    public void setSelectedValue(Node newValue) {
        myTreePanel.setSelectedValue(newValue);
    }
    
    public Node getSelectedValue() {
        return myTreePanel.getSelectedNode();
    }
    
    public ValidStateManager getValidStateManager(boolean isFast) {
        return isFast ? fastValidationState : finalValidationState;
    }
    
    public boolean unsubscribeListeners() {
        return true;
    }
    
    public boolean subscribeListeners() {
        return true;
    }
    
    public boolean afterClose() {
        return true;
    }
    
    public Lookup getLookup() {
        return myTreePanel.getLookup();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        pnlTreePanel = getTreePanel();

        org.jdesktop.layout.GroupLayout pnlTreePanelLayout = new org.jdesktop.layout.GroupLayout(pnlTreePanel);
        pnlTreePanel.setLayout(pnlTreePanelLayout);
        pnlTreePanelLayout.setHorizontalGroup(
            pnlTreePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 376, Short.MAX_VALUE)
        );
        pnlTreePanelLayout.setVerticalGroup(
            pnlTreePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 287, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(pnlTreePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(pnlTreePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pnlTreePanel;
    // End of variables declaration//GEN-END:variables
    
}
