/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.watch;

import org.netbeans.modules.bpel.debugger.api.variables.SimpleValue;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.modules.bpel.debugger.ui.variable.HelperViewModel;
import org.netbeans.modules.bpel.debugger.ui.variable.XmlUtil;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author Alexander Zgursky
 */
public class WatchHelperViewModel 
        extends HelperViewModel
        implements NodeModel, TableModel, Constants
{
    public Object getValueAt(Object object, String column) throws UnknownTypeException {
        if (object instanceof Node) {
            if (column.equals(WATCH_VALUE_COLUMN_ID)) {
                return nodeAsString((Node)object);
            } else if (column.equals(WATCH_TO_STRING_COLUMN_ID)) {
                return nodeAsString((Node)object);
            } else if (column.equals(WATCH_TYPE_COLUMN_ID)) {
                return "";
            }
        } else if (object instanceof Value) {
            if (column.equals(WATCH_VALUE_COLUMN_ID)) {
                return valueAsString((Value)object);
            } else if (column.equals(WATCH_TO_STRING_COLUMN_ID)) {
                return valueAsString((Value)object);
            } else if (column.equals(WATCH_TYPE_COLUMN_ID)) {
                return "";
            }
        }
        
        throw new UnknownTypeException(object);
    }
    
    public void setValueAt(Object object, String column, Object value) throws UnknownTypeException {
        if (object instanceof Node) {
            return;
        } else if (object instanceof Value) {
            return;
        }
        
        throw new UnknownTypeException(object);
    }
    
    public boolean isReadOnly(Object object, String column) throws UnknownTypeException {
        if (object instanceof Node) {
            return true;
        } else if (object instanceof Value) {
            return true;
        }
        
        throw new UnknownTypeException(object);
    }

    private String nodeAsString(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList children = element.getChildNodes();
            if (    children.getLength() == 1 &&
                    children.item(0).getNodeType() == Node.TEXT_NODE)
            {
                return children.item(0).getNodeValue();
            } else {
                return XmlUtil.domNodeToString(element);
            }
        } else {
            String nodeValue = node.getNodeValue();
            return nodeValue != null ? nodeValue : "";
        }
    }

    private Object valueAsString(Value value) throws UnknownTypeException {
        if (value instanceof SimpleValue) {
            return ((SimpleValue)value).getValueAsString();
        } else if (value instanceof XmlElementValue) {
            return getValueAt(
                    ((XmlElementValue)value).getElement(),
                    WATCH_VALUE_COLUMN_ID);
        } else {
            return "";
        }
    }
}
