/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.runtime;

import java.awt.Point;

/**
 *
 * @author apepin
 */
public class SourceElement{
    private XmlEditor editor = null;
    private int startLine = -1;
    private int startColumn = -1;
    private int endLine = -1;
    private int endColumn = -1;
    private String element = null;
    public SourceElement(XmlEditor editor, String elTagName)throws ElementNotFoundException{
        if(editor == null)
            throw new IllegalArgumentException("XmlEditor is null");
        this.editor = editor;
        if(elTagName == null)
            element = "";
        else
            element = elTagName;
        //find beginning of the element
        startLine = editor.getLineNumber();
        String lineText = editor.getLine(startLine);
        startColumn = lineText.indexOf("<"+element);//assume that element starts at the same line
        if(startColumn<0)
//            startColumn = lineText.length()-1;
            throw new ElementNotFoundException("No element with name "+element+" exists in the source.");
        //find end of the element
        calcEndPosition();
        //get tag name assuming it's following <
        if(element.equals("")){
            char[] chars = new char[]{' ', '/', '>', '\n'};
            int delim = -1;
            for(int i=0; i<chars.length; i++){
                int occur = lineText.indexOf(chars[i], startColumn+1);
                if(occur>=0 && occur<delim)
                    delim = occur;
            }
            if(delim != -1)
                element = lineText.substring(startColumn+1, delim);
        }
    }
    private void calcEndPosition(){
        //find end of the element
        endLine = startLine;
        endColumn = editor.getLine(startLine).indexOf('>',startColumn);
        while(endColumn<0){
            endLine++;
            endColumn = editor.getLine(endLine).indexOf('>');
        }
    }
    public void setAttribute(String attrName, String attrVal){
        Point pos = findAttribute(attrName);
        if(pos.x<0){
            //create an attribute at the end of element
            int insertCol = 
            hasContent()? endColumn: endColumn-1;
            editor.insertTextIntoLine(" "+attrName+"=\""+attrVal+"\"", endLine, insertCol);
        }
        else{
            //assume that value is in the same line
            String prop = editor.getLine(pos.y).substring(pos.x);
            int valStart = prop.indexOf('"');
            int valEnd = prop.indexOf('"', valStart+1);

            editor.deleteTextFromLine(pos.y, pos.x+valStart+1, pos.x+valEnd);
            editor.insertTextIntoLine(attrVal, pos.y, pos.x+valStart+1);
        }
        calcEndPosition();
    }
        
    public void removeAttribute(String attrName){
        Point pos = findAttribute(attrName);
        if(pos.x<0)
            return;
        //assume that value is in the same line
        String prop = editor.getLine(pos.y).substring(pos.x);
        int valStart = prop.indexOf('"');
        int valEnd = prop.indexOf('"', valStart+1);
        editor.deleteTextFromLine(pos.y, pos.x, pos.x+valEnd+1);
        calcEndPosition();
    }
    public String getAttribute(String attrName){
        Point pos = findAttribute(attrName);
        if(pos.x<0)
            return null;
        //assume that value is in the same line
        String prop = editor.getLine(pos.y).substring(pos.x);
        int valStart = prop.indexOf('"');
        int valEnd = prop.indexOf('"', valStart+1);
        return prop.substring(valStart+1, valEnd);
    }
    protected Point findAttribute(String attrName){
        int line = startLine;
        int col = -1;
        if(startLine == endLine)
            col = editor.getLine(startLine).indexOf(attrName, startColumn);
        else{
            for(;line<endLine; line++){
                if((col = editor.getLine(line).indexOf(attrName)) >= 0)
                    break;
            }
            if(col<0){
                //searching in the last line
                col = editor.getLine(line).substring(0, endColumn).indexOf(attrName);
            }
        }
        return new Point(col, line);
    }
    public SourceElement createChildElement(String elType) throws ElementNotFoundException{
        String offset = "";
        for(int i=0; i<startColumn; i++)
            offset += " ";

        if(!hasContent()){
            //create content
            editor.deleteTextFromLine(endLine, endColumn-1,  endColumn);
            calcEndPosition();
            editor.appendLine(offset+"</"+element+">", endLine+1);
        }
        //create child
        editor.appendLine("    "+offset+"<"+elType+"/>", endLine+1);
        editor.setLineNumber(endLine+1);
        
        return new SourceElement(editor, elType);
    }
    
    public SourceElement findChildElement(String elType) throws ElementNotFoundException{
        if(!hasContent()){
            throw new ElementNotFoundException("Element has no children.");
        }
        int eoe = editor.findLineStartsWith("</"+element, endLine);
        
        SourceElement child = editor.findSourceElement(elType, endLine);
        if(child.endLine > eoe){
            throw new ElementNotFoundException("Element has no children of type "+elType);
        }
        
        return child;
    }
    
    public boolean hasContent(){
        return editor.getLine(endLine).charAt(endColumn-1) != '/';
    }
    
}
