/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.model.api.XmlComment;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;

/**
 *
 * 
 */
public class XmlCommentImpl implements XmlComment {

    private Comment mComment;
    
    private ProcessImpl mParent;
    
    private Logger mLogger = Logger.getLogger(XmlCommentImpl.class.getName());
    
    public XmlCommentImpl(ProcessImpl parent, 
                          Comment comment) {
        this.mComment = comment;
        this.mParent = parent;
    }
    
    public String getCommentText() {
        return this.mComment.getNodeValue();
    }

    public void setCommmentText(String comment) {
        try {
        mParent.setCommentText(mComment, comment);
        } catch(Exception ex) {
            mLogger.log(Level.SEVERE, NbBundle.getMessage(XmlCommentImpl.class, "XmlCommentImpl_FailedToSetComment", new Object[] {comment}), ex);
        }
    }

    public Comment getPeer() {
        return this.mComment;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = true;
        
        if(!(object instanceof XmlComment)) {
            result = false;
        }
        
        XmlComment comment = (XmlComment) object;
        
        result = this.getPeer() != null ? this.getPeer().equals(comment.getPeer()) : comment.getPeer() == null;
        
        return result;
        
    }
    
    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        
        if(getPeer() != null) {
            hashCode = getPeer().hashCode();
        }
        return hashCode;
    }
}
