/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.concurrent.atomic.AtomicReference;

import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeReference;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
public abstract class ReplyReceiveIntersectImpl extends InvokeReceiveReplyCommonImpl
        implements VariableReference, MessageExchangeReference
{

    ReplyReceiveIntersectImpl( BpelModelImpl model, Element e ) {
        super(model, e);
    }

    ReplyReceiveIntersectImpl( BpelBuilderImpl builder, String tagName )
    {
        super(builder, tagName);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.VariableSpec#getVariable()
     */
    public BpelReference<VariableDeclaration> getVariable() {
        return getBpelReference( BpelAttributes.VARIABLE_REF , 
                VariableDeclaration.class);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.VariableSpec#removeVariable()
     */
    public void removeVariable() {
        removeReference( BpelAttributes.VARIABLE_REF );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.VariableSpec#setVariable(org.netbeans.modules.soa.model.bpel20.references.VariableReference)
     */
    public void setVariable( BpelReference<VariableDeclaration> value ) {
        setBpelReference( BpelAttributes.VARIABLE_REF ,value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.MessageExchangeSpec#getMessageExchange()
     */
    public BpelReference<MessageExchange> getMessageExchange() {
        return getBpelReference( BpelAttributes.MESSAGE_EXCHANGE , 
                MessageExchange.class);
    }


    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.MessageExchangeSpec#setMessageExchange(java.lang.String)
     */
    public void setMessageExchange( BpelReference<MessageExchange> ref ) {
        setBpelReference( BpelAttributes.MESSAGE_EXCHANGE , ref );
    }


    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.MessageExchangeSpec#removeMessageExchange()
     */
    public void removeMessageExchange() {
        removeReference( BpelAttributes.MESSAGE_EXCHANGE );
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.references.ReferenceCollection#getReferences()
     */
    public Reference[] getReferences(){
        Reference[] refs = super.getReferences();
        Reference[] ret = new Reference[ refs.length +2 ];
        System.arraycopy( refs, 0 , ret , 2 , refs.length );
        ret[0] = getVariable();
        ret[1] = getMessageExchange();
        return ret;
    }


    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.impl.BpelEntityImpl#getDomainAttributes()
     */
    protected Attribute[] getDomainAttributes() {
        if ( myAttributes.get() == null ){
            Attribute[] attr = super.getDomainAttributes();
            Attribute[] ret = new Attribute[ attr.length + 2];
            System.arraycopy( attr , 0 , ret , 2 , attr.length );
            ret[ 0 ] = BpelAttributes.VARIABLE_REF;
            ret[ 1 ] = BpelAttributes.MESSAGE_EXCHANGE; // Fix for #81457
            myAttributes.compareAndSet( null,  ret);
        }
        return myAttributes.get();
    }
    
    private static AtomicReference<Attribute[]> myAttributes = 
        new AtomicReference<Attribute[]>();
}
