/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComMethod;
import com4j.DefaultMethod;
import com4j.IllegalAnnotationException;
import com4j.Native;
import com4j.NativeType;
import com4j.ReturnValue;
import com4j.StandardComMethod;
import com4j.VTID;
import java.lang.reflect.Method;

public class DefaultedComMethod
extends ComMethod {
    private final int[] vtids;
    private final StandardComMethod last;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int[] EMPTY_INTARRAY = new int[0];

    public DefaultedComMethod(Method m, ReturnValue retVal) {
        Class<? extends Com4jObject>[] intermediates = retVal.defaultPropertyThrough();
        this.vtids = new int[intermediates.length];
        for (int idx = 0; idx < this.vtids.length; ++idx) {
            VTID id = m.getAnnotation(VTID.class);
            assert (id != null);
            this.vtids[idx] = id.value();
            m = this.findDefaultMethod(intermediates[idx]);
            if (m != null) continue;
            throw new IllegalAnnotationException(intermediates[idx].getName() + " needs to have a method with @DefaultMethod");
        }
        this.last = new StandardComMethod(m);
    }

    private Method findDefaultMethod(Class intf) {
        for (Method m : intf.getMethods()) {
            if (m.getAnnotation(DefaultMethod.class) == null) continue;
            return m;
        }
        return null;
    }

    Object invoke(int ptr, Object[] args) {
        Native.addRef(ptr);
        for (int vtid : this.vtids) {
            int newPtr = (Integer)Native.invoke(ptr, vtid, EMPTY_ARRAY, EMPTY_INTARRAY, 0, false, NativeType.ComObject.code);
            Native.release(ptr);
            ptr = newPtr;
        }
        Object r = this.last.invoke(ptr, args);
        Native.release(ptr);
        return r;
    }
}

