/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.awt;

import com.sun.perseus.awt.JSVGDocumentComponent;
import com.sun.perseus.awt.SVGDocumentComponent;
import com.sun.perseus.awt.SVGDocumentComponentSupport;
import com.sun.perseus.model.DocumentNode;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;

public final class SVGAnimatorImpl
extends SVGAnimator {
    public static final int STATE_STOPPED = 1;
    public static final int STATE_PLAYING = 2;
    public static final int STATE_PAUSED = 3;
    static final String AWT_COMPONENT_CLASS = "java.awt.Component";
    static final String SWING_COMPONENT_CLASS = "javax.swing.JComponent";
    Component svgComponent;
    SVGDocumentComponentSupport svgComponentSupport;

    private SVGAnimatorImpl(SVGImage svgImage, boolean isSwing) {
        if (isSwing) {
            this.svgComponent = new JSVGDocumentComponent((DocumentNode)svgImage.getDocument());
            this.svgComponentSupport = ((JSVGDocumentComponent)this.svgComponent).support;
        } else {
            this.svgComponent = new SVGDocumentComponent((DocumentNode)svgImage.getDocument());
            this.svgComponentSupport = ((SVGDocumentComponent)this.svgComponent).support;
        }
        this.svgComponent.setFocusable(true);
        this.svgComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SVGAnimatorImpl.this.svgComponent.requestFocus();
            }
        });
    }

    public static SVGAnimator createAnimator(SVGImage svgImage, String componentBaseClass) {
        if (svgImage == null) {
            throw new NullPointerException();
        }
        if (componentBaseClass != null && !AWT_COMPONENT_CLASS.equals(componentBaseClass) && !SWING_COMPONENT_CLASS.equals(componentBaseClass)) {
            throw new IllegalArgumentException();
        }
        boolean isSwing = true;
        if (AWT_COMPONENT_CLASS.equals(componentBaseClass)) {
            isSwing = false;
        }
        return new SVGAnimatorImpl(svgImage, isSwing);
    }

    public void setSVGEventListener(SVGEventListener svgEventListener) {
        this.svgComponentSupport.setSVGEventListener(svgEventListener);
    }

    public void setTimeIncrement(float timeIncrement) {
        this.svgComponentSupport.setTimeIncrement(timeIncrement);
    }

    public float getTimeIncrement() {
        return this.svgComponentSupport.getTimeIncrement();
    }

    public void play() {
        this.svgComponentSupport.play();
    }

    public void pause() {
        this.svgComponentSupport.pause();
    }

    public void stop() {
        this.svgComponentSupport.stop();
    }

    public Object getTargetComponent() {
        return this.svgComponent;
    }

    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        this.svgComponentSupport.invokeAndWait(runnable);
    }

    public void invokeLater(Runnable runnable) {
        this.svgComponentSupport.invokeLater(runnable);
    }

    public int getState() {
        return this.svgComponentSupport.getState();
    }
}

