/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGoRectangle
extends JGoDrawable {
    public JGoRectangle() {
    }

    public JGoRectangle(Rectangle rect) {
        super(rect);
    }

    public JGoRectangle(Point location, Dimension size) {
        super(location, size);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoRectangle newobj = (JGoRectangle)super.copyObject(env);
        if (newobj != null) {
            // empty if block
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoRect = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoRectangle", jGoElementGroup);
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement element = svgDoc.createElement("rect");
            this.SVGWriteAttributes(element);
            jGoElementGroup.appendChild(element);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        } else if (svgElement.getTagName().equalsIgnoreCase("rect")) {
            this.SVGReadAttributes(svgElement);
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        svgElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        svgElement.setAttribute("width", Integer.toString(this.getWidth()));
        svgElement.setAttribute("height", Integer.toString(this.getHeight()));
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String nX = svgElement.getAttribute("x");
        String nY = svgElement.getAttribute("y");
        if (nX.length() > 0 && nY.length() > 0) {
            this.setTopLeft(new Point(Integer.parseInt(nX), Integer.parseInt(nY)));
        }
        String nWidth = svgElement.getAttribute("width");
        String nHeight = svgElement.getAttribute("height");
        if (nWidth.length() > 0 && nHeight.length() > 0) {
            this.setWidth(Integer.parseInt(nWidth));
            this.setHeight(Integer.parseInt(nHeight));
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        Rectangle rect = this.getBoundingRect();
        this.drawRect(g, rect.x, rect.y, rect.width, rect.height);
    }

    public static boolean getNearestIntersectionPoint(int left, int top, int width, int height, int px, int py, int cx, int cy, Point result) {
        double dist;
        int right = left + width;
        int bottom = top + height;
        double closestdist = 1.0E21;
        int closestx = cx;
        int closesty = cy;
        if (JGoStroke.getNearestIntersectionOnLine(left, top, right, top, px, py, cx, cy, result) && (dist = (double)((result.x - px) * (result.x - px) + (result.y - py) * (result.y - py))) < closestdist) {
            closestdist = dist;
            closestx = result.x;
            closesty = result.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(right, top, right, bottom, px, py, cx, cy, result) && (dist = (double)((result.x - px) * (result.x - px) + (result.y - py) * (result.y - py))) < closestdist) {
            closestdist = dist;
            closestx = result.x;
            closesty = result.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(right, bottom, left, bottom, px, py, cx, cy, result) && (dist = (double)((result.x - px) * (result.x - px) + (result.y - py) * (result.y - py))) < closestdist) {
            closestdist = dist;
            closestx = result.x;
            closesty = result.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(left, bottom, left, top, px, py, cx, cy, result) && (dist = (double)((result.x - px) * (result.x - px) + (result.y - py) * (result.y - py))) < closestdist) {
            closestdist = dist;
            closestx = result.x;
            closesty = result.y;
        }
        result.x = closestx;
        result.y = closesty;
        return closestdist < 1.0E21;
    }
}

