/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class JGoButton
extends JGoControl {
    public static final int ChangedLabel = 1001;
    private String myLabel = "";
    private int myFontSize = 10;

    public JGoButton() {
    }

    public JGoButton(Rectangle rect, String label) {
        super(rect);
        this.myLabel = label;
    }

    public JGoButton(Point location, Dimension size, String label) {
        super(location, size);
        this.myLabel = label;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoButton newobj = (JGoButton)super.copyObject(env);
        if (newobj != null) {
            newobj.myLabel = this.myLabel;
            newobj.myFontSize = this.myFontSize;
        }
        return newobj;
    }

    public JComponent createComponent(JGoView view) {
        JButton button = new JButton(this.getLabel());
        Font oldfont = button.getFont();
        this.myFontSize = oldfont.getSize();
        button.addActionListener(new JBListener(this, view));
        return button;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoButton = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoButton", jGoElementGroup);
            jGoButton.setAttribute("fontsize", Integer.toString(this.myFontSize));
            jGoButton.setAttribute("label", this.myLabel);
        }
        if (svgDoc.SVGOutputEnabled()) {
            DomElement element = svgDoc.createElement("rect");
            this.SVGWriteAttributes(element);
            jGoElementGroup.appendChild(element);
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.myFontSize = Integer.parseInt(jGoChildElement.getAttribute("fontsize"));
            this.myLabel = jGoChildElement.getAttribute("label");
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("x", Integer.toString(this.getTopLeft().x));
        svgElement.setAttribute("y", Integer.toString(this.getTopLeft().y));
        svgElement.setAttribute("width", Integer.toString(this.getWidth()));
        svgElement.setAttribute("height", Integer.toString(this.getHeight()));
        svgElement.setAttribute("style", "stroke:black;stroke-width:1;fill:none");
    }

    public void SVGReadAttributes(DomElement svgElement) {
        super.SVGReadAttributes(svgElement);
        String nX = svgElement.getAttribute("x");
        String nY = svgElement.getAttribute("y");
        this.setTopLeft(new Point(Integer.parseInt(nX), Integer.parseInt(nY)));
        String nWidth = svgElement.getAttribute("width");
        String nHeight = svgElement.getAttribute("height");
        this.setWidth(Integer.parseInt(nWidth));
        this.setHeight(Integer.parseInt(nHeight));
    }

    public void paint(Graphics2D g, JGoView view) {
        JComponent comp = this.getComponent(view);
        if (comp instanceof JButton) {
            JButton button = (JButton)comp;
            if (Math.abs(view.getScale() - 1.0) >= 0.01) {
                Font oldfont = button.getFont();
                Font newfont = new Font(oldfont.getFontName(), oldfont.getStyle(), (int)((double)this.myFontSize * view.getScale()));
                comp.setFont(newfont);
            }
            Rectangle viewRect = view.getTempRectangle();
            Rectangle b = this.getBoundingRect();
            viewRect.x = b.x;
            viewRect.y = b.y;
            viewRect.width = b.width;
            viewRect.height = b.height;
            view.convertDocToView(viewRect);
            comp.setBounds(viewRect);
            button.setText(this.getLabel());
            comp.repaint();
        }
    }

    public String getLabel() {
        return this.myLabel;
    }

    public void setLabel(String newLabel) {
        String oldLabel = this.myLabel;
        if (!oldLabel.equals(newLabel)) {
            this.myLabel = newLabel != null ? newLabel : "";
            this.update(1001, 0, oldLabel);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 1001: {
                e.setNewValue(this.getLabel());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 1001: {
                this.setLabel((String)e.getValue(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    class JBListener
    implements ActionListener {
        JGoButton button;
        JGoView view;

        JBListener(JGoButton b, JGoView v) {
            this.button = b;
            this.view = v;
        }

        public void actionPerformed(ActionEvent e) {
            this.view.fireUpdate(22, 0, this.button);
            Point dc = this.button.getSpotLocation(0);
            Point vc = this.view.docToViewCoords(dc);
            this.button.doMouseClick(0, dc, vc, this.view);
        }
    }
}

