/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.idoc.jco;

import com.sap.mw.idoc.jco.JCoIDoc;
import com.sap.mw.idoc.util.AboutDialog;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class About
extends AboutDialog {
    public static final String VERSION = "1.0.6 (2006-05-17)";
    private static final String NOT_FOUND = "Library not found";
    private static final String SYS_PATH = "System defined path";

    public About() {
        super("SAP Java Connector IDoc Class Library");
        PrintWriter pw;
        StringWriter sw;
        String libidocjco_path = null;
        String libidoc_path = null;
        String libjco_path = null;
        String idocjco_version = VERSION;
        String idoc_version = "unknown";
        String jco_version = "unknown";
        String idocjco_error = null;
        String idoc_error = null;
        String jco_error = null;
        try {
            libidocjco_path = this.getOwnFilePath();
            idocjco_version = JCoIDoc.getVersion();
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            idocjco_error = sw.toString();
            System.out.println(idocjco_error);
        }
        try {
            Class<?> idocAboutClass = Class.forName("com.sap.mw.idoc.About");
            libidoc_path = AboutDialog.getFilePathToClass(idocAboutClass);
            idoc_version = (String)idocAboutClass.getField("VERSION").get(null);
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            idoc_error = sw.toString();
            System.out.println(idoc_error);
        }
        try {
            Class<?> jcoAboutClass = Class.forName("com.sap.mw.jco.About");
            libjco_path = AboutDialog.getFilePathToClass(jcoAboutClass);
            jco_version = (String)jcoAboutClass.getField("VERSION").get(null);
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            jco_error = sw.toString();
            System.out.println(jco_error);
        }
        AboutDialog.Section section = new AboutDialog.Section("Versions");
        section.addEntry("JCoIDoc API", idocjco_version);
        section.addEntry("IDoc API", idoc_version);
        section.addEntry("JCo API", jco_version);
        this.addSection(section);
        section = new AboutDialog.Section("Library Paths");
        section.addEntry("Path to sapidocjco.jar", libidocjco_path == null ? SYS_PATH : libidocjco_path);
        section.addEntry("Path to sapidoc.jar", libidoc_path == null ? SYS_PATH : libidoc_path);
        section.addEntry("Path to sapjco.jar", libjco_path == null ? NOT_FOUND : libjco_path);
        this.addSection(section);
        if (idocjco_error != null || idoc_error != null || jco_error != null) {
            section = new AboutDialog.Section("Initialization Errors");
            if (idocjco_error != null) {
                section.addEntry("JCoIDoc error", idocjco_error);
            }
            if (idoc_error != null) {
                section.addEntry("IDoc error", idoc_error);
            }
            if (jco_error != null) {
                section.addEntry("JCo error", jco_error);
            }
            this.addSection(section);
        }
    }

    public static void main(String[] args) {
        new About().show(args);
    }
}

