/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.ComponentAdmin;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public class UndeployTask
extends ComponentAdmin {
    private static final String UNDEPLOY_COMMAND = "undeploy";
    LocalStringsManager lsm = new LocalStringsManager();
    private boolean droptables;
    private boolean droptablesIsSet = false;
    private boolean cascade;
    private boolean cascadeIsSet = false;

    protected void checkComponentConfig(AppServerAdmin.Server aServer, ComponentAdmin.Component comp) throws BuildException {
        super.checkComponentConfig(aServer, comp);
        String theName = comp.getName();
        if (theName == null || theName.length() == 0) {
            String msg = this.lsm.getString("InvalidComponentName", new Object[]{theName});
            throw new BuildException(msg, this.getLocation());
        }
    }

    public void setDroptables(boolean droptables) {
        this.droptables = droptables;
        this.droptablesIsSet = true;
    }

    public void setCascade(boolean casacde) {
        this.cascade = this.cascade;
        this.cascadeIsSet = true;
    }

    protected String getCommandString(AppServerAdmin.Server server, ComponentAdmin.Component comp) {
        String lTarget;
        StringBuffer cmdString = new StringBuffer(UNDEPLOY_COMMAND);
        cmdString.append(server.getCommandParameters(true));
        if (comp.getType() != null) {
            this.log(this.lsm.getString("DeprecatedTypeAttribute"), 1);
        }
        if (this.droptablesIsSet) {
            cmdString.append(" --droptables=").append(this.droptables);
            this.droptablesIsSet = false;
        }
        if (this.cascade) {
            cmdString.append(" --cascade=").append(this.cascade);
            this.cascadeIsSet = false;
        }
        if ((lTarget = comp.getTarget()) != null && lTarget.length() > 0) {
            cmdString.append(" --target ").append(lTarget);
        }
        cmdString.append(" ").append(comp.getName());
        return cmdString.toString();
    }
}

